package com.sforce.soap.tooling;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.bind.TypeMapper;

import java.util.HashMap;

import javax.xml.namespace.QName;

/**
 * This is a generated class for the SObject Enterprise API.
 * Do not edit this file, as your changes will be lost.
 */
public class ToolingConnection {

  private TypeMapper __typeMapper = new TypeMapper(null, null, false);
  private ConnectorConfig __config;
  private HashMap<QName, XMLizable> __extraHeaders = new HashMap<QName, XMLizable>();

  public ConnectorConfig getConfig() {
    return __config;
  }

  private com.sforce.soap.tooling.AllOrNoneHeader_element __AllOrNoneHeader;

  public void setAllOrNoneHeader(boolean allOrNone) {
    __AllOrNoneHeader = new com.sforce.soap.tooling.AllOrNoneHeader_element();
    __AllOrNoneHeader.setAllOrNone(allOrNone);
  }

  public void clearAllOrNoneHeader() {
    __AllOrNoneHeader = null;
  }

  public com.sforce.soap.tooling.AllOrNoneHeader_element getAllOrNoneHeader() {
    return  __AllOrNoneHeader;
  }

  public void __setAllOrNoneHeader(com.sforce.soap.tooling.AllOrNoneHeader_element __header) {
    __AllOrNoneHeader = __header ;
  }

  private com.sforce.soap.tooling.DebuggingHeader_element __DebuggingHeader;

  public void setDebuggingHeader(com.sforce.soap.tooling.LogInfo[] categories,com.sforce.soap.tooling.LogType debugLevel) {
    __DebuggingHeader = new com.sforce.soap.tooling.DebuggingHeader_element();
    __DebuggingHeader.setCategories(categories);
    __DebuggingHeader.setDebugLevel(debugLevel);
  }

  public void clearDebuggingHeader() {
    __DebuggingHeader = null;
  }

  public com.sforce.soap.tooling.DebuggingHeader_element getDebuggingHeader() {
    return  __DebuggingHeader;
  }

  public void __setDebuggingHeader(com.sforce.soap.tooling.DebuggingHeader_element __header) {
    __DebuggingHeader = __header ;
  }

  private com.sforce.soap.tooling.CallOptions_element __CallOptions;

  public void setCallOptions(java.lang.String client) {
    __CallOptions = new com.sforce.soap.tooling.CallOptions_element();
    __CallOptions.setClient(client);
  }

  public void clearCallOptions() {
    __CallOptions = null;
  }

  public com.sforce.soap.tooling.CallOptions_element getCallOptions() {
    return  __CallOptions;
  }

  public void __setCallOptions(com.sforce.soap.tooling.CallOptions_element __header) {
    __CallOptions = __header ;
  }

  private com.sforce.soap.tooling.MetadataVersionCheck_element __MetadataVersionCheck;

  public void setMetadataVersionCheck(com.sforce.soap.tooling.Fact[] facts,com.sforce.soap.tooling.Operation operation) {
    __MetadataVersionCheck = new com.sforce.soap.tooling.MetadataVersionCheck_element();
    __MetadataVersionCheck.setFacts(facts);
    __MetadataVersionCheck.setOperation(operation);
  }

  public void clearMetadataVersionCheck() {
    __MetadataVersionCheck = null;
  }

  public com.sforce.soap.tooling.MetadataVersionCheck_element getMetadataVersionCheck() {
    return  __MetadataVersionCheck;
  }

  public void __setMetadataVersionCheck(com.sforce.soap.tooling.MetadataVersionCheck_element __header) {
    __MetadataVersionCheck = __header ;
  }

  private com.sforce.soap.tooling.MetadataWarningsHeader_element __MetadataWarningsHeader;

  public void setMetadataWarningsHeader(boolean ignoreSaveWarnings) {
    __MetadataWarningsHeader = new com.sforce.soap.tooling.MetadataWarningsHeader_element();
    __MetadataWarningsHeader.setIgnoreSaveWarnings(ignoreSaveWarnings);
  }

  public void clearMetadataWarningsHeader() {
    __MetadataWarningsHeader = null;
  }

  public com.sforce.soap.tooling.MetadataWarningsHeader_element getMetadataWarningsHeader() {
    return  __MetadataWarningsHeader;
  }

  public void __setMetadataWarningsHeader(com.sforce.soap.tooling.MetadataWarningsHeader_element __header) {
    __MetadataWarningsHeader = __header ;
  }

  private com.sforce.soap.tooling.AllowFieldTruncationHeader_element __AllowFieldTruncationHeader;

  public void setAllowFieldTruncationHeader(boolean allowFieldTruncation) {
    __AllowFieldTruncationHeader = new com.sforce.soap.tooling.AllowFieldTruncationHeader_element();
    __AllowFieldTruncationHeader.setAllowFieldTruncation(allowFieldTruncation);
  }

  public void clearAllowFieldTruncationHeader() {
    __AllowFieldTruncationHeader = null;
  }

  public com.sforce.soap.tooling.AllowFieldTruncationHeader_element getAllowFieldTruncationHeader() {
    return  __AllowFieldTruncationHeader;
  }

  public void __setAllowFieldTruncationHeader(com.sforce.soap.tooling.AllowFieldTruncationHeader_element __header) {
    __AllowFieldTruncationHeader = __header ;
  }

  private com.sforce.soap.tooling.PackageVersionHeader_element __PackageVersionHeader;

  public void setPackageVersionHeader(com.sforce.soap.tooling.PackageVersion[] packageVersions) {
    __PackageVersionHeader = new com.sforce.soap.tooling.PackageVersionHeader_element();
    __PackageVersionHeader.setPackageVersions(packageVersions);
  }

  public void clearPackageVersionHeader() {
    __PackageVersionHeader = null;
  }

  public com.sforce.soap.tooling.PackageVersionHeader_element getPackageVersionHeader() {
    return  __PackageVersionHeader;
  }

  public void __setPackageVersionHeader(com.sforce.soap.tooling.PackageVersionHeader_element __header) {
    __PackageVersionHeader = __header ;
  }

  private com.sforce.soap.tooling.APIPerformanceInfo_element __APIPerformanceInfo;

  public void setAPIPerformanceInfo(java.lang.String encodedIntervalTimerTree,com.sforce.soap.tooling.NameValuePair[] handlerMetrics) {
    __APIPerformanceInfo = new com.sforce.soap.tooling.APIPerformanceInfo_element();
    __APIPerformanceInfo.setEncodedIntervalTimerTree(encodedIntervalTimerTree);
    __APIPerformanceInfo.setHandlerMetrics(handlerMetrics);
  }

  public void clearAPIPerformanceInfo() {
    __APIPerformanceInfo = null;
  }

  public com.sforce.soap.tooling.APIPerformanceInfo_element getAPIPerformanceInfo() {
    return  __APIPerformanceInfo;
  }

  public void __setAPIPerformanceInfo(com.sforce.soap.tooling.APIPerformanceInfo_element __header) {
    __APIPerformanceInfo = __header ;
  }

  private com.sforce.soap.tooling.SessionHeader_element __SessionHeader;

  public void setSessionHeader(java.lang.String sessionId) {
    __SessionHeader = new com.sforce.soap.tooling.SessionHeader_element();
    __SessionHeader.setSessionId(sessionId);
  }

  public void clearSessionHeader() {
    __SessionHeader = null;
  }

  public com.sforce.soap.tooling.SessionHeader_element getSessionHeader() {
    return  __SessionHeader;
  }

  public void __setSessionHeader(com.sforce.soap.tooling.SessionHeader_element __header) {
    __SessionHeader = __header ;
  }

  private com.sforce.soap.tooling.DisableFeedTrackingHeader_element __DisableFeedTrackingHeader;

  public void setDisableFeedTrackingHeader(boolean disableFeedTracking) {
    __DisableFeedTrackingHeader = new com.sforce.soap.tooling.DisableFeedTrackingHeader_element();
    __DisableFeedTrackingHeader.setDisableFeedTracking(disableFeedTracking);
  }

  public void clearDisableFeedTrackingHeader() {
    __DisableFeedTrackingHeader = null;
  }

  public com.sforce.soap.tooling.DisableFeedTrackingHeader_element getDisableFeedTrackingHeader() {
    return  __DisableFeedTrackingHeader;
  }

  public void __setDisableFeedTrackingHeader(com.sforce.soap.tooling.DisableFeedTrackingHeader_element __header) {
    __DisableFeedTrackingHeader = __header ;
  }

  private com.sforce.soap.tooling.DebuggingInfo_element __DebuggingInfo;

  public void setDebuggingInfo(java.lang.String debugLog) {
    __DebuggingInfo = new com.sforce.soap.tooling.DebuggingInfo_element();
    __DebuggingInfo.setDebugLog(debugLog);
  }

  public void clearDebuggingInfo() {
    __DebuggingInfo = null;
  }

  public com.sforce.soap.tooling.DebuggingInfo_element getDebuggingInfo() {
    return  __DebuggingInfo;
  }

  public void __setDebuggingInfo(com.sforce.soap.tooling.DebuggingInfo_element __header) {
    __DebuggingInfo = __header ;
  }



  public ToolingConnection(ConnectorConfig config) throws ConnectionException {
    this.__config = config;
    this.__typeMapper.setConfig(config);

    config.verifyToolingEndpoint();
    if (!config.isManualLogin()) {
      if (config.getSessionId()==null) {
        config.setServiceEndpoint(config.getAuthEndpoint());
        com.sforce.soap.tooling.LoginResult result = login(config.getUsername(), config.getPassword());
        config.setSessionId(result.getSessionId());
        config.setServiceEndpoint(result.getServerUrl());
      } else {
        if (config.getServiceEndpoint() == null) {
          throw new com.sforce.ws.ConnectionException("Please set ServiceEndpoint");
        }
      }
    }

      __SessionHeader = new SessionHeader_element();
      __SessionHeader.setSessionId(config.getSessionId());
  }

  private com.sforce.ws.transport.SoapConnection newConnection() {
      com.sforce.ws.transport.SoapConnection __c   = new com.sforce.ws.transport.SoapConnection(
           __config.getServiceEndpoint(), "urn:sobject.tooling.soap.sforce.com", __typeMapper, __config);

      __c.setConnection(this);
      __c.setKnownHeaders(knownHeaders);
      return __c;
   }

  public com.sforce.soap.tooling.DeleteResult[] delete(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Delete_element __request = new com.sforce.soap.tooling.Delete_element();

    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__MetadataWarningsHeader != null) __connection.addHeader(MetadataWarningsHeader_qname, __MetadataWarningsHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.DeleteResponse_element __response = (com.sforce.soap.tooling.DeleteResponse_element) __connection.send("",
       delete_qname, __request, deleteResponse_qname,
       com.sforce.soap.tooling.DeleteResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.LoginResult login(java.lang.String username,java.lang.String password)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Login_element __request = new com.sforce.soap.tooling.Login_element();

    __request.setUsername(username);
    __request.setPassword(password);

    addHeaders(__connection);

    com.sforce.soap.tooling.LoginResponse_element __response = (com.sforce.soap.tooling.LoginResponse_element) __connection.send("",
       login_qname, __request, loginResponse_qname,
       com.sforce.soap.tooling.LoginResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.QueryResult queryAll(java.lang.String queryString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.QueryAll_element __request = new com.sforce.soap.tooling.QueryAll_element();

    __request.setQueryString(queryString);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.QueryAllResponse_element __response = (com.sforce.soap.tooling.QueryAllResponse_element) __connection.send("",
       queryAll_qname, __request, queryAllResponse_qname,
       com.sforce.soap.tooling.QueryAllResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.SaveResult[] update(com.sforce.soap.tooling.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Update_element __request = new com.sforce.soap.tooling.Update_element();

    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__MetadataWarningsHeader != null) __connection.addHeader(MetadataWarningsHeader_qname, __MetadataWarningsHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__MetadataVersionCheck != null) __connection.addHeader(MetadataVersionCheck_qname, __MetadataVersionCheck);

    addHeaders(__connection);

    com.sforce.soap.tooling.UpdateResponse_element __response = (com.sforce.soap.tooling.UpdateResponse_element) __connection.send("",
       update_qname, __request, updateResponse_qname,
       com.sforce.soap.tooling.UpdateResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeSObjectResult describeSObject(java.lang.String type)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeSObject_element __request = new com.sforce.soap.tooling.DescribeSObject_element();

    __request.setType(type);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeSObjectResponse_element __response = (com.sforce.soap.tooling.DescribeSObjectResponse_element) __connection.send("",
       describeSObject_qname, __request, describeSObjectResponse_qname,
       com.sforce.soap.tooling.DescribeSObjectResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeValueTypeResult describeValueType(java.lang.String type)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeValueType_element __request = new com.sforce.soap.tooling.DescribeValueType_element();

    __request.setType(type);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeValueTypeResponse_element __response = (com.sforce.soap.tooling.DescribeValueTypeResponse_element) __connection.send("",
       describeValueType_qname, __request, describeValueTypeResponse_qname,
       com.sforce.soap.tooling.DescribeValueTypeResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.GetServerTimestampResult getServerTimestamp()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.GetServerTimestamp_element __request = new com.sforce.soap.tooling.GetServerTimestamp_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.GetServerTimestampResponse_element __response = (com.sforce.soap.tooling.GetServerTimestampResponse_element) __connection.send("",
       getServerTimestamp_qname, __request, getServerTimestampResponse_qname,
       com.sforce.soap.tooling.GetServerTimestampResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.ChangeOwnPasswordResult changeOwnPassword(java.lang.String oldPassword,java.lang.String newPassword)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.ChangeOwnPassword_element __request = new com.sforce.soap.tooling.ChangeOwnPassword_element();

    __request.setOldPassword(oldPassword);
    __request.setNewPassword(newPassword);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.ChangeOwnPasswordResponse_element __response = (com.sforce.soap.tooling.ChangeOwnPasswordResponse_element) __connection.send("",
       changeOwnPassword_qname, __request, changeOwnPasswordResponse_qname,
       com.sforce.soap.tooling.ChangeOwnPasswordResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.SetPasswordResult setPassword(java.lang.String userId,java.lang.String password)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.SetPassword_element __request = new com.sforce.soap.tooling.SetPassword_element();

    __request.setUserId(userId);
    __request.setPassword(password);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.SetPasswordResponse_element __response = (com.sforce.soap.tooling.SetPasswordResponse_element) __connection.send("",
       setPassword_qname, __request, setPasswordResponse_qname,
       com.sforce.soap.tooling.SetPasswordResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeSoqlListViewResult describeSoqlListViews(com.sforce.soap.tooling.DescribeSoqlListViewsRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeSoqlListViews_element __request = new com.sforce.soap.tooling.DescribeSoqlListViews_element();

    __request.setRequest(request);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeSoqlListViewsResponse_element __response = (com.sforce.soap.tooling.DescribeSoqlListViewsResponse_element) __connection.send("",
       describeSoqlListViews_qname, __request, describeSoqlListViewsResponse_qname,
       com.sforce.soap.tooling.DescribeSoqlListViewsResponse_element.class);

    return __response.getResult();
  }public java.lang.String runTestsAsynchronous(java.lang.String classids,java.lang.String suiteids,int maxFailedTests,com.sforce.soap.tooling.TestLevel testLevel,java.lang.String classNames,java.lang.String suiteNames,com.sforce.soap.tooling.TestsNode[] tests,boolean skipCodeCoverage)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.RunTestsAsynchronous_element __request = new com.sforce.soap.tooling.RunTestsAsynchronous_element();

    __request.setClassids(classids);
    __request.setSuiteids(suiteids);
    __request.setMaxFailedTests(maxFailedTests);
    __request.setTestLevel(testLevel);
    __request.setClassNames(classNames);
    __request.setSuiteNames(suiteNames);
    __request.setTests(tests);
    __request.setSkipCodeCoverage(skipCodeCoverage);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.RunTestsAsynchronousResponse_element __response = (com.sforce.soap.tooling.RunTestsAsynchronousResponse_element) __connection.send("",
       runTestsAsynchronous_qname, __request, runTestsAsynchronousResponse_qname,
       com.sforce.soap.tooling.RunTestsAsynchronousResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.ExecuteAnonymousResult executeAnonymous(java.lang.String String)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.ExecuteAnonymous_element __request = new com.sforce.soap.tooling.ExecuteAnonymous_element();

    __request.setString(String);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.ExecuteAnonymousResponse_element __response = (com.sforce.soap.tooling.ExecuteAnonymousResponse_element) __connection.send("",
       executeAnonymous_qname, __request, executeAnonymousResponse_qname,
       com.sforce.soap.tooling.ExecuteAnonymousResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.SaveResult[] create(com.sforce.soap.tooling.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Create_element __request = new com.sforce.soap.tooling.Create_element();

    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__MetadataWarningsHeader != null) __connection.addHeader(MetadataWarningsHeader_qname, __MetadataWarningsHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.CreateResponse_element __response = (com.sforce.soap.tooling.CreateResponse_element) __connection.send("",
       create_qname, __request, createResponse_qname,
       com.sforce.soap.tooling.CreateResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeWorkitemActionResult[] describeWorkitemActions(java.lang.String[] workitemIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeWorkitemActions_element __request = new com.sforce.soap.tooling.DescribeWorkitemActions_element();

    __request.setWorkitemIds(workitemIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeWorkitemActionsResponse_element __response = (com.sforce.soap.tooling.DescribeWorkitemActionsResponse_element) __connection.send("",
       describeWorkitemActions_qname, __request, describeWorkitemActionsResponse_qname,
       com.sforce.soap.tooling.DescribeWorkitemActionsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.InvalidateSessionsResult[] invalidateSessions(java.lang.String[] ArrayList)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.InvalidateSessions_element __request = new com.sforce.soap.tooling.InvalidateSessions_element();

    __request.setArrayList(ArrayList);

    addHeaders(__connection);

    com.sforce.soap.tooling.InvalidateSessionsResponse_element __response = (com.sforce.soap.tooling.InvalidateSessionsResponse_element) __connection.send("",
       invalidateSessions_qname, __request, invalidateSessionsResponse_qname,
       com.sforce.soap.tooling.InvalidateSessionsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.RunTestsResult runTests(com.sforce.soap.tooling.RunTestsRequest RunTestsRequest)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.RunTests_element __request = new com.sforce.soap.tooling.RunTests_element();

    __request.setRunTestsRequest(RunTestsRequest);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.RunTestsResponse_element __response = (com.sforce.soap.tooling.RunTestsResponse_element) __connection.send("",
       runTests_qname, __request, runTestsResponse_qname,
       com.sforce.soap.tooling.RunTestsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.GetDeletedResult getDeleted(java.lang.String sObjectType,java.util.Calendar start,java.util.Calendar end)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.GetDeleted_element __request = new com.sforce.soap.tooling.GetDeleted_element();

    __request.setSObjectType(sObjectType);
    __request.setStart(start);
    __request.setEnd(end);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.GetDeletedResponse_element __response = (com.sforce.soap.tooling.GetDeletedResponse_element) __connection.send("",
       getDeleted_qname, __request, getDeletedResponse_qname,
       com.sforce.soap.tooling.GetDeletedResponse_element.class);

    return __response.getResult();
  }public void logout()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Logout_element __request = new com.sforce.soap.tooling.Logout_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

__connection.send("",
       logout_qname, __request, logoutResponse_qname,
       com.sforce.soap.tooling.LogoutResponse_element.class);

  }public com.sforce.soap.tooling.SearchResult search(java.lang.String searchString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Search_element __request = new com.sforce.soap.tooling.Search_element();

    __request.setSearchString(searchString);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.SearchResponse_element __response = (com.sforce.soap.tooling.SearchResponse_element) __connection.send("",
       search_qname, __request, searchResponse_qname,
       com.sforce.soap.tooling.SearchResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.GetUpdatedResult getUpdated(java.lang.String sObjectType,java.util.Calendar start,java.util.Calendar end)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.GetUpdated_element __request = new com.sforce.soap.tooling.GetUpdated_element();

    __request.setSObjectType(sObjectType);
    __request.setStart(start);
    __request.setEnd(end);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.GetUpdatedResponse_element __response = (com.sforce.soap.tooling.GetUpdatedResponse_element) __connection.send("",
       getUpdated_qname, __request, getUpdatedResponse_qname,
       com.sforce.soap.tooling.GetUpdatedResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.UpsertResult[] upsert(java.lang.String fieldName,com.sforce.soap.tooling.sobject.SObject[] entities)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Upsert_element __request = new com.sforce.soap.tooling.Upsert_element();

    __request.setFieldName(fieldName);
    __request.setEntities(entities);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__MetadataWarningsHeader != null) __connection.addHeader(MetadataWarningsHeader_qname, __MetadataWarningsHeader);
    if (__MetadataVersionCheck != null) __connection.addHeader(MetadataVersionCheck_qname, __MetadataVersionCheck);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.UpsertResponse_element __response = (com.sforce.soap.tooling.UpsertResponse_element) __connection.send("",
       upsert_qname, __request, upsertResponse_qname,
       com.sforce.soap.tooling.UpsertResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.QueryResult query(java.lang.String queryString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Query_element __request = new com.sforce.soap.tooling.Query_element();

    __request.setQueryString(queryString);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__MetadataVersionCheck != null) __connection.addHeader(MetadataVersionCheck_qname, __MetadataVersionCheck);

    addHeaders(__connection);

    com.sforce.soap.tooling.QueryResponse_element __response = (com.sforce.soap.tooling.QueryResponse_element) __connection.send("",
       query_qname, __request, queryResponse_qname,
       com.sforce.soap.tooling.QueryResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeGlobalResult describeGlobal()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeGlobal_element __request = new com.sforce.soap.tooling.DescribeGlobal_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeGlobalResponse_element __response = (com.sforce.soap.tooling.DescribeGlobalResponse_element) __connection.send("",
       describeGlobal_qname, __request, describeGlobalResponse_qname,
       com.sforce.soap.tooling.DescribeGlobalResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeSObjectResult[] describeSObjects(java.lang.String[] types)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeSObjects_element __request = new com.sforce.soap.tooling.DescribeSObjects_element();

    __request.setTypes(types);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeSObjectsResponse_element __response = (com.sforce.soap.tooling.DescribeSObjectsResponse_element) __connection.send("",
       describeSObjects_qname, __request, describeSObjectsResponse_qname,
       com.sforce.soap.tooling.DescribeSObjectsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.GetUserInfoResult getUserInfo()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.GetUserInfo_element __request = new com.sforce.soap.tooling.GetUserInfo_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.GetUserInfoResponse_element __response = (com.sforce.soap.tooling.GetUserInfoResponse_element) __connection.send("",
       getUserInfo_qname, __request, getUserInfoResponse_qname,
       com.sforce.soap.tooling.GetUserInfoResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.sobject.SObject[] retrieve(java.lang.String select,java.lang.String type,java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.Retrieve_element __request = new com.sforce.soap.tooling.Retrieve_element();

    __request.setSelect(select);
    __request.setType(type);
    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.RetrieveResponse_element __response = (com.sforce.soap.tooling.RetrieveResponse_element) __connection.send("",
       retrieve_qname, __request, retrieveResponse_qname,
       com.sforce.soap.tooling.RetrieveResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.QueryResult queryMore(java.lang.String queryLocator)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.QueryMore_element __request = new com.sforce.soap.tooling.QueryMore_element();

    __request.setQueryLocator(queryLocator);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.tooling.QueryMoreResponse_element __response = (com.sforce.soap.tooling.QueryMoreResponse_element) __connection.send("",
       queryMore_qname, __request, queryMoreResponse_qname,
       com.sforce.soap.tooling.QueryMoreResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.tooling.DescribeLayoutResult describeLayout(java.lang.String type,java.lang.String layoutName,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.tooling.DescribeLayout_element __request = new com.sforce.soap.tooling.DescribeLayout_element();

    __request.setType(type);
    __request.setLayoutName(layoutName);
    __request.setRecordTypeIds(recordTypeIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);

    addHeaders(__connection);

    com.sforce.soap.tooling.DescribeLayoutResponse_element __response = (com.sforce.soap.tooling.DescribeLayoutResponse_element) __connection.send("",
       describeLayout_qname, __request, describeLayoutResponse_qname,
       com.sforce.soap.tooling.DescribeLayoutResponse_element.class);

    return __response.getResult();
  }

  private void addHeaders(com.sforce.ws.transport.SoapConnection __connection) {
    for(java.util.Map.Entry<QName, XMLizable> entry : __extraHeaders.entrySet()) {
      __connection.addHeader(entry.getKey(), entry.getValue());
    }
  }

  public void addExtraHeader(QName __headerName, XMLizable __value) {
    __extraHeaders.put(__headerName, __value);
  }

  public void removeExtraHeader(QName __headerName) {
    __extraHeaders.remove(__headerName);
  }

  public XMLizable getExtraHeader(QName __headerName) {
    return __extraHeaders.get(__headerName);
  }

  public void clearExtraHeaders() {
    __extraHeaders = new HashMap<QName, XMLizable>();
  }

    private static final javax.xml.namespace.QName delete_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "delete");
    private static final javax.xml.namespace.QName deleteResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "deleteResponse");
    private static final javax.xml.namespace.QName login_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "login");
    private static final javax.xml.namespace.QName loginResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "loginResponse");
    private static final javax.xml.namespace.QName queryAll_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "queryAll");
    private static final javax.xml.namespace.QName queryAllResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "queryAllResponse");
    private static final javax.xml.namespace.QName update_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "update");
    private static final javax.xml.namespace.QName updateResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "updateResponse");
    private static final javax.xml.namespace.QName describeSObject_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeSObject");
    private static final javax.xml.namespace.QName describeSObjectResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeSObjectResponse");
    private static final javax.xml.namespace.QName describeValueType_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeValueType");
    private static final javax.xml.namespace.QName describeValueTypeResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeValueTypeResponse");
    private static final javax.xml.namespace.QName getServerTimestamp_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getServerTimestamp");
    private static final javax.xml.namespace.QName getServerTimestampResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getServerTimestampResponse");
    private static final javax.xml.namespace.QName changeOwnPassword_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "changeOwnPassword");
    private static final javax.xml.namespace.QName changeOwnPasswordResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "changeOwnPasswordResponse");
    private static final javax.xml.namespace.QName setPassword_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "setPassword");
    private static final javax.xml.namespace.QName setPasswordResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "setPasswordResponse");
    private static final javax.xml.namespace.QName describeSoqlListViews_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeSoqlListViews");
    private static final javax.xml.namespace.QName describeSoqlListViewsResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeSoqlListViewsResponse");
    private static final javax.xml.namespace.QName runTestsAsynchronous_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "runTestsAsynchronous");
    private static final javax.xml.namespace.QName runTestsAsynchronousResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "runTestsAsynchronousResponse");
    private static final javax.xml.namespace.QName executeAnonymous_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "executeAnonymous");
    private static final javax.xml.namespace.QName executeAnonymousResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "executeAnonymousResponse");
    private static final javax.xml.namespace.QName create_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "create");
    private static final javax.xml.namespace.QName createResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "createResponse");
    private static final javax.xml.namespace.QName describeWorkitemActions_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeWorkitemActions");
    private static final javax.xml.namespace.QName describeWorkitemActionsResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeWorkitemActionsResponse");
    private static final javax.xml.namespace.QName invalidateSessions_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "invalidateSessions");
    private static final javax.xml.namespace.QName invalidateSessionsResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "invalidateSessionsResponse");
    private static final javax.xml.namespace.QName runTests_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "runTests");
    private static final javax.xml.namespace.QName runTestsResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "runTestsResponse");
    private static final javax.xml.namespace.QName getDeleted_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getDeleted");
    private static final javax.xml.namespace.QName getDeletedResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getDeletedResponse");
    private static final javax.xml.namespace.QName logout_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "logout");
    private static final javax.xml.namespace.QName logoutResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "logoutResponse");
    private static final javax.xml.namespace.QName search_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "search");
    private static final javax.xml.namespace.QName searchResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "searchResponse");
    private static final javax.xml.namespace.QName getUpdated_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getUpdated");
    private static final javax.xml.namespace.QName getUpdatedResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getUpdatedResponse");
    private static final javax.xml.namespace.QName upsert_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "upsert");
    private static final javax.xml.namespace.QName upsertResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "upsertResponse");
    private static final javax.xml.namespace.QName query_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "query");
    private static final javax.xml.namespace.QName queryResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "queryResponse");
    private static final javax.xml.namespace.QName describeGlobal_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeGlobal");
    private static final javax.xml.namespace.QName describeGlobalResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeGlobalResponse");
    private static final javax.xml.namespace.QName describeSObjects_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeSObjects");
    private static final javax.xml.namespace.QName describeSObjectsResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeSObjectsResponse");
    private static final javax.xml.namespace.QName getUserInfo_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getUserInfo");
    private static final javax.xml.namespace.QName getUserInfoResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "getUserInfoResponse");
    private static final javax.xml.namespace.QName retrieve_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "retrieve");
    private static final javax.xml.namespace.QName retrieveResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "retrieveResponse");
    private static final javax.xml.namespace.QName queryMore_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "queryMore");
    private static final javax.xml.namespace.QName queryMoreResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "queryMoreResponse");
    private static final javax.xml.namespace.QName describeLayout_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeLayout");
    private static final javax.xml.namespace.QName describeLayoutResponse_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "describeLayoutResponse");
    private static final javax.xml.namespace.QName AllOrNoneHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "AllOrNoneHeader");
    private static final javax.xml.namespace.QName DebuggingHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "DebuggingHeader");
    private static final javax.xml.namespace.QName CallOptions_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "CallOptions");
    private static final javax.xml.namespace.QName MetadataVersionCheck_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "MetadataVersionCheck");
    private static final javax.xml.namespace.QName MetadataWarningsHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "MetadataWarningsHeader");
    private static final javax.xml.namespace.QName AllowFieldTruncationHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "AllowFieldTruncationHeader");
    private static final javax.xml.namespace.QName PackageVersionHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "PackageVersionHeader");
    private static final javax.xml.namespace.QName APIPerformanceInfo_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "APIPerformanceInfo");
    private static final javax.xml.namespace.QName SessionHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "SessionHeader");
    private static final javax.xml.namespace.QName DisableFeedTrackingHeader_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "DisableFeedTrackingHeader");
    private static final javax.xml.namespace.QName DebuggingInfo_qname = new javax.xml.namespace.QName("urn:tooling.soap.sforce.com", "DebuggingInfo");


  private static HashMap<QName, java.lang.Class> knownHeaders = new HashMap<QName, java.lang.Class>();

  static {
      knownHeaders.put(AllOrNoneHeader_qname,com.sforce.soap.tooling.AllOrNoneHeader_element.class);
      knownHeaders.put(DebuggingHeader_qname,com.sforce.soap.tooling.DebuggingHeader_element.class);
      knownHeaders.put(CallOptions_qname,com.sforce.soap.tooling.CallOptions_element.class);
      knownHeaders.put(MetadataVersionCheck_qname,com.sforce.soap.tooling.MetadataVersionCheck_element.class);
      knownHeaders.put(MetadataWarningsHeader_qname,com.sforce.soap.tooling.MetadataWarningsHeader_element.class);
      knownHeaders.put(AllowFieldTruncationHeader_qname,com.sforce.soap.tooling.AllowFieldTruncationHeader_element.class);
      knownHeaders.put(PackageVersionHeader_qname,com.sforce.soap.tooling.PackageVersionHeader_element.class);
      knownHeaders.put(APIPerformanceInfo_qname,com.sforce.soap.tooling.APIPerformanceInfo_element.class);
      knownHeaders.put(SessionHeader_qname,com.sforce.soap.tooling.SessionHeader_element.class);
      knownHeaders.put(DisableFeedTrackingHeader_qname,com.sforce.soap.tooling.DisableFeedTrackingHeader_element.class);
      knownHeaders.put(DebuggingInfo_qname,com.sforce.soap.tooling.DebuggingInfo_element.class);
  }
}
