-- transfer a file from local to remote
DECLARE
  sourceDirectory VARCHAR2(200) := ?;          -- source Oracle directory object name
  sourceFileName VARCHAR2(200) := ?;           -- source file basename
  destDirectory VARCHAR2(200) := ?;            -- destination Oracle directory object name
  destFileName VARCHAR2(200) := ?;             -- destination file basename
  remoteLink VARCHAR2(200) := ?;               -- database link to destination database
BEGIN
 
  DBMS_FILE_TRANSFER.PUT_FILE(
    source_directory_object       => sourceDirectory,
    source_file_name              => sourceFileName,
    destination_directory_object  => destDirectory,
    destination_file_name         => destFileName,
    destination_database          => remoteLink
  );

END;
