/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdUpdater;

abstract class RrdPrimitive {
    static final int STRING_LENGTH = 20;
    static final int RRD_INT = 0;
    static final int RRD_LONG = 1;
    static final int RRD_DOUBLE = 2;
    static final int RRD_STRING = 3;
    static final int[] RRD_PRIM_SIZES = new int[]{4, 8, 8, 40};
    private RrdBackend backend;
    private int byteCount;
    private final long pointer;
    private final boolean cachingAllowed;

    RrdPrimitive(RrdUpdater updater, int type, boolean isConstant) throws IOException {
        this(updater, type, 1, isConstant);
    }

    RrdPrimitive(RrdUpdater updater, int type, int count, boolean isConstant) throws IOException {
        this.backend = updater.getRrdBackend();
        this.byteCount = RRD_PRIM_SIZES[type] * count;
        this.pointer = updater.getRrdAllocator().allocate(this.byteCount);
        this.cachingAllowed = isConstant || this.backend.isCachingAllowed();
    }

    final byte[] readBytes() throws IOException {
        byte[] b = new byte[this.byteCount];
        this.backend.read(this.pointer, b);
        return b;
    }

    final void writeBytes(byte[] b) throws IOException {
        assert (b.length == this.byteCount) : "Invalid number of bytes supplied to RrdPrimitive.write method";
        this.backend.write(this.pointer, b);
    }

    final int readInt() throws IOException {
        return this.backend.readInt(this.pointer);
    }

    final void writeInt(int value) throws IOException {
        this.backend.writeInt(this.pointer, value);
    }

    final long readLong() throws IOException {
        return this.backend.readLong(this.pointer);
    }

    final void writeLong(long value) throws IOException {
        this.backend.writeLong(this.pointer, value);
    }

    final double readDouble() throws IOException {
        return this.backend.readDouble(this.pointer);
    }

    final double readDouble(int index) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(offset);
    }

    final double[] readDouble(int index, int count) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(offset, count);
    }

    final void writeDouble(double value) throws IOException {
        this.backend.writeDouble(this.pointer, value);
    }

    final void writeDouble(int index, double value) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(offset, value);
    }

    final void writeDouble(int index, double value, int count) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(offset, value, count);
    }

    final void writeDouble(int index, double[] values) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(offset, values);
    }

    final String readString() throws IOException {
        return this.backend.readString(this.pointer);
    }

    final void writeString(String value) throws IOException {
        this.backend.writeString(this.pointer, value);
    }

    final boolean isCachingAllowed() {
        return this.cachingAllowed;
    }
}

