/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.DateMathParser;

public class CreateAliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    private final OverseerCollectionMessageHandler ocmh;

    private static boolean anyRoutingParams(ZkNodeProps message) {
        return message.keySet().stream().anyMatch(k -> k.startsWith("router."));
    }

    public CreateAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String aliasName = message.getStr("name");
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        if (!CreateAliasCmd.anyRoutingParams(message)) {
            this.callCreatePlainAlias(message, aliasName, zkStateReader);
        } else {
            this.callCreateRoutedAlias(message, aliasName, zkStateReader, state);
        }
        Thread.sleep(100L);
    }

    private void callCreatePlainAlias(ZkNodeProps message, String aliasName, ZkStateReader zkStateReader) {
        List<String> canonicalCollectionList = this.parseCollectionsParameter(message.get("collections"));
        String canonicalCollectionsString = StrUtils.join(canonicalCollectionList, (char)',');
        this.validateAllCollectionsExistAndNoDups(canonicalCollectionList, zkStateReader);
        zkStateReader.aliasesManager.applyModificationAndExportToZk(aliases -> aliases.cloneWithCollectionAlias(aliasName, canonicalCollectionsString));
    }

    private List<String> parseCollectionsParameter(Object colls) {
        if (colls == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing collections param");
        }
        if (colls instanceof List) {
            return (List)colls;
        }
        return StrUtils.splitSmart((String)colls.toString(), (String)",", (boolean)true).stream().map(String::trim).collect(Collectors.toList());
    }

    private void callCreateRoutedAlias(ZkNodeProps message, String aliasName, ZkStateReader zkStateReader, ClusterState state) throws Exception {
        if (!message.getProperties().keySet().containsAll(TimeRoutedAlias.REQUIRED_ROUTER_PARAMS)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A routed alias requires these params: " + TimeRoutedAlias.REQUIRED_ROUTER_PARAMS + " plus some create-collection prefixed ones.");
        }
        LinkedHashMap<String, String> aliasProperties = new LinkedHashMap<String, String>();
        message.getProperties().entrySet().stream().filter(entry -> TimeRoutedAlias.PARAM_IS_PROP.test((String)entry.getKey())).forEach(entry -> aliasProperties.put((String)entry.getKey(), (String)entry.getValue()));
        TimeRoutedAlias timeRoutedAlias = new TimeRoutedAlias(aliasName, aliasProperties);
        String start = message.getStr("router.start");
        Instant startTime = this.parseStart(start, timeRoutedAlias.getTimeZone());
        String initialCollectionName = TimeRoutedAlias.formatCollectionNameFromInstant(aliasName, startTime);
        MaintainRoutedAliasCmd.createCollectionAndWait(state, aliasName, aliasProperties, initialCollectionName, this.ocmh);
        this.validateAllCollectionsExistAndNoDups(Collections.singletonList(initialCollectionName), zkStateReader);
        zkStateReader.aliasesManager.applyModificationAndExportToZk(aliases -> aliases.cloneWithCollectionAlias(aliasName, initialCollectionName).cloneWithCollectionAliasProperties(aliasName, aliasProperties));
    }

    private Instant parseStart(String str, TimeZone zone) {
        Instant start = DateMathParser.parseMath(new Date(), str, zone).toInstant();
        this.checkMilis(start);
        return start;
    }

    private void checkMilis(Instant date) {
        if (!date.truncatedTo(ChronoUnit.SECONDS).equals(date)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Date or date math for start time includes milliseconds, which is not supported. (Hint: 'NOW' used without rounding always has this problem)");
        }
    }

    private void validateAllCollectionsExistAndNoDups(List<String> collectionList, ZkStateReader zkStateReader) {
        String collectionStr = StrUtils.join(collectionList, (char)',');
        if (new HashSet<String>(collectionList).size() != collectionList.size()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', since it contains duplicates", collectionStr));
        }
        ClusterState clusterState = zkStateReader.getClusterState();
        Set aliasNames = zkStateReader.getAliases().getCollectionAliasListMap().keySet();
        for (String collection : collectionList) {
            if (clusterState.getCollectionOrNull(collection) != null || aliasNames.contains(collection)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', '%s' is not an existing collection or alias", collectionStr, collection));
        }
    }
}

