/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.export.BoolFieldWriter;
import org.apache.solr.handler.export.DateFieldWriter;
import org.apache.solr.handler.export.DoubleAsc;
import org.apache.solr.handler.export.DoubleDesc;
import org.apache.solr.handler.export.DoubleFieldWriter;
import org.apache.solr.handler.export.DoubleValue;
import org.apache.solr.handler.export.DoubleValueSortDoc;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.FloatAsc;
import org.apache.solr.handler.export.FloatDesc;
import org.apache.solr.handler.export.FloatFieldWriter;
import org.apache.solr.handler.export.FloatValue;
import org.apache.solr.handler.export.IntComp;
import org.apache.solr.handler.export.IntFieldWriter;
import org.apache.solr.handler.export.IntValue;
import org.apache.solr.handler.export.LongAsc;
import org.apache.solr.handler.export.LongDesc;
import org.apache.solr.handler.export.LongFieldWriter;
import org.apache.solr.handler.export.LongValue;
import org.apache.solr.handler.export.MultiFieldWriter;
import org.apache.solr.handler.export.QuadValueSortDoc;
import org.apache.solr.handler.export.SingleValueSortDoc;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortQueue;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.handler.export.StringFieldWriter;
import org.apache.solr.handler.export.StringValue;
import org.apache.solr.handler.export.TripleValueSortDoc;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWriter
implements SolrCore.RawWriter,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OutputStreamWriter respWriter;
    final SolrQueryRequest req;
    final SolrQueryResponse res;
    FieldWriter[] fieldWriters;
    int totalHits = 0;
    FixedBitSet[] sets = null;
    PushWriter writer;
    private String wt;

    public ExportWriter(SolrQueryRequest req, SolrQueryResponse res, String wt) {
        this.req = req;
        this.res = res;
        this.wt = wt;
    }

    @Override
    public String getContentType() {
        if ("javabin".equals(this.wt)) {
            return "application/octet-stream";
        }
        return "json";
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.respWriter != null) {
            this.respWriter.flush();
            this.respWriter.close();
        }
    }

    protected void writeException(Exception e, PushWriter w, boolean logException) throws IOException {
        w.writeMap(mw -> mw.put((CharSequence)"responseHeader", Collections.singletonMap("status", 400)).put((CharSequence)"response", (Object)Utils.makeMap((Object[])new Object[]{"numFound", 0, "docs", Collections.singletonList(Collections.singletonMap("EXCEPTION", e.getMessage()))})));
        if (logException) {
            SolrException.log((Logger)log, (Throwable)e);
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        QueryResponseWriter rw = this.req.getCore().getResponseWriters().get(this.wt);
        if (rw instanceof BinaryResponseWriter) {
            this.writer = new JavaBinCodec(os, null);
        } else {
            this.respWriter = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            this.writer = JSONResponseWriter.getPushWriter(this.respWriter, this.req, this.res);
        }
        Exception exception = this.res.getException();
        if (exception != null) {
            if (!(exception instanceof IgnoreException)) {
                this.writeException(exception, this.writer, false);
            }
            return;
        }
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        SortSpec sortSpec = info.getResponseBuilder().getSortSpec();
        if (sortSpec == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        SolrIndexSearcher searcher = this.req.getSearcher();
        Sort sort = searcher.weightSort(sortSpec.getSort());
        if (sort == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        if (sort != null && sort.needsScores()) {
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        if (this.req.getContext().get("totalHits") != null) {
            this.totalHits = (Integer)this.req.getContext().get("totalHits");
            this.sets = (FixedBitSet[])this.req.getContext().get("export");
            if (this.sets == null) {
                this.writeException(new IOException(new SyntaxError("xport RankQuery is required for xsort: rq={!xport}")), this.writer, true);
                return;
            }
        }
        SolrParams params = this.req.getParams();
        String fl = params.get("fl");
        String[] fields = null;
        if (fl == null) {
            this.writeException(new IOException(new SyntaxError("export field list (fl) must be specified.")), this.writer, true);
            return;
        }
        fields = fl.split(",");
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
            if (!fields[i].equals("score")) continue;
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        try {
            this.fieldWriters = this.getFieldWriters(fields, this.req.getSearcher());
        }
        catch (Exception e) {
            this.writeException(e, this.writer, true);
            return;
        }
        this.writer.writeMap(m -> {
            m.put((CharSequence)"responseHeader", Collections.singletonMap("status", 0));
            m.put((CharSequence)"response", mw -> {
                mw.put((CharSequence)"numFound", this.totalHits);
                mw.put((CharSequence)"docs", iw -> this.writeDocs(this.req, iw, sort));
            });
        });
    }

    protected void writeDocs(SolrQueryRequest req, IteratorWriter.ItemWriter writer, Sort sort) throws IOException {
        List leaves = req.getSearcher().getTopReaderContext().leaves();
        SortDoc sortDoc = this.getSortDoc(req.getSearcher(), sort.getSort());
        int count = 0;
        int queueSize = 30000;
        if (this.totalHits < 30000) {
            queueSize = this.totalHits;
        }
        SortQueue queue = new SortQueue(queueSize, sortDoc);
        SortDoc[] outDocs = new SortDoc[queueSize];
        while (count < this.totalHits) {
            int i;
            queue.reset();
            SortDoc top = (SortDoc)queue.top();
            for (int i2 = 0; i2 < leaves.size(); ++i2) {
                int docId;
                sortDoc.setNextReader((LeafReaderContext)leaves.get(i2));
                BitSetIterator it = new BitSetIterator((BitSet)this.sets[i2], 0L);
                while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                    sortDoc.setValues(docId);
                    if (!top.lessThan(sortDoc)) continue;
                    top.setValues(sortDoc);
                    top = (SortDoc)queue.updateTop();
                }
            }
            int outDocsIndex = -1;
            for (i = 0; i < queueSize; ++i) {
                SortDoc s = (SortDoc)queue.pop();
                if (s.docId <= -1) continue;
                outDocs[++outDocsIndex] = s;
            }
            count += outDocsIndex + 1;
            try {
                for (i = outDocsIndex; i >= 0; --i) {
                    SortDoc s = outDocs[i];
                    writer.add(ew -> {
                        this.writeDoc(s, leaves, ew);
                        s.reset();
                    });
                }
            }
            catch (Throwable e) {
                for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                    String m = ex.getMessage();
                    if (m == null || !m.contains("Broken pipe")) continue;
                    throw new IgnoreException();
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
    }

    protected void writeDoc(SortDoc sortDoc, List<LeafReaderContext> leaves, MapWriter.EntryWriter ew) throws IOException {
        int ord = sortDoc.ord;
        FixedBitSet set = this.sets[ord];
        set.clear(sortDoc.docId);
        LeafReaderContext context = leaves.get(ord);
        int fieldIndex = 0;
        for (FieldWriter fieldWriter : this.fieldWriters) {
            if (!fieldWriter.write(sortDoc, context.reader(), ew, fieldIndex)) continue;
            ++fieldIndex;
        }
    }

    protected FieldWriter[] getFieldWriters(String[] fields, SolrIndexSearcher searcher) throws IOException {
        IndexSchema schema = searcher.getSchema();
        FieldWriter[] writers = new FieldWriter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            writers[i] = this.getFieldWriter(fields[i], schema.getField(fields[i]));
        }
        return writers;
    }

    protected FieldWriter getFieldWriter(String field, SchemaField schemaField) throws IOException {
        FieldWriter fieldWriter = null;
        if (!schemaField.hasDocValues()) {
            throw new IOException(field + " must have DocValues to use this feature.");
        }
        boolean multiValued = schemaField.multiValued();
        FieldType fieldType = schemaField.getType();
        if (fieldType instanceof IntValueFieldType) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, true) : new IntFieldWriter(field);
        } else if (fieldType instanceof LongValueFieldType) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, true) : new LongFieldWriter(field);
        } else if (fieldType instanceof FloatValueFieldType) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, true) : new FloatFieldWriter(field);
        } else if (fieldType instanceof DoubleValueFieldType) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, true) : new DoubleFieldWriter(field);
        } else if (fieldType instanceof StrField) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, false) : new StringFieldWriter(field, fieldType);
        } else if (fieldType instanceof DateValueFieldType) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, false) : new DateFieldWriter(field);
        } else if (fieldType instanceof BoolField) {
            fieldWriter = multiValued ? new MultiFieldWriter(field, fieldType, schemaField, true) : new BoolFieldWriter(field, fieldType);
        } else {
            throw new IOException("Export fields must either be one of the following types: int,float,long,double,string,date,boolean");
        }
        return fieldWriter;
    }

    protected SortDoc getSortDoc(SolrIndexSearcher searcher, SortField[] sortFields) throws IOException {
        SortValue[] sortValues = new SortValue[sortFields.length];
        IndexSchema schema = searcher.getSchema();
        for (int i = 0; i < sortFields.length; ++i) {
            sortValues[i] = this.getSortDoc(searcher, schema, sortFields[i]);
        }
        if (sortValues.length == 1) {
            return new SingleValueSortDoc(sortValues[0]);
        }
        if (sortValues.length == 2) {
            return new DoubleValueSortDoc(sortValues[0], sortValues[1]);
        }
        if (sortValues.length == 3) {
            return new TripleValueSortDoc(sortValues[0], sortValues[1], sortValues[2]);
        }
        if (sortValues.length == 4) {
            return new QuadValueSortDoc(sortValues[0], sortValues[1], sortValues[2], sortValues[3]);
        }
        return new SortDoc(sortValues);
    }

    protected SortValue getSortDoc(SolrIndexSearcher searcher, IndexSchema schema, SortField sf) throws IOException {
        SortValue sortValue = null;
        String field = sf.getField();
        boolean reverse = sf.getReverse();
        SchemaField schemaField = schema.getField(field);
        FieldType ft = schemaField.getType();
        if (!schemaField.hasDocValues()) {
            throw new IOException(field + " must have DocValues to use this feature.");
        }
        if (ft instanceof IntValueFieldType) {
            sortValue = reverse ? new IntValue(field, new IntDesc()) : new IntValue(field, new IntAsc());
        } else if (ft instanceof FloatValueFieldType) {
            sortValue = reverse ? new FloatValue(field, new FloatDesc()) : new FloatValue(field, new FloatAsc());
        } else if (ft instanceof DoubleValueFieldType) {
            sortValue = reverse ? new DoubleValue(field, new DoubleDesc()) : new DoubleValue(field, new DoubleAsc());
        } else if (ft instanceof LongValueFieldType) {
            sortValue = reverse ? new LongValue(field, new LongDesc()) : new LongValue(field, new LongAsc());
        } else if (ft instanceof StrField) {
            LeafReader reader = searcher.getSlowAtomicReader();
            SortedDocValues vals = reader.getSortedDocValues(field);
            sortValue = reverse ? new StringValue(vals, field, new IntDesc()) : new StringValue(vals, field, new IntAsc());
        } else if (ft instanceof DateValueFieldType) {
            sortValue = reverse ? new LongValue(field, new LongDesc()) : new LongValue(field, new LongAsc());
        } else if (ft instanceof BoolField) {
            LeafReader reader = searcher.getSlowAtomicReader();
            SortedDocValues vals = reader.getSortedDocValues(field);
            sortValue = reverse ? new StringValue(vals, field, new IntDesc()) : new StringValue(vals, field, new IntAsc());
        } else {
            throw new IOException("Sort fields must be one of the following types: int,float,long,double,string,date,boolean");
        }
        return sortValue;
    }

    public static class IgnoreException
    extends IOException {
        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print("Early Client Disconnect");
        }

        @Override
        public String getMessage() {
            return "Early Client Disconnect";
        }
    }

    public class IntDesc
    implements IntComp {
        @Override
        public int resetValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public int compare(int a, int b) {
            return Integer.compare(a, b);
        }
    }

    public class IntAsc
    implements IntComp {
        @Override
        public int resetValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int compare(int a, int b) {
            return Integer.compare(b, a);
        }
    }
}

