/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.schema.FieldType;

public class StringFieldWriter
extends FieldWriter {
    private String field;
    private FieldType fieldType;
    private CharsRefBuilder cref = new CharsRefBuilder();
    final ByteArrayUtf8CharSequence utf8 = new ByteArrayUtf8CharSequence(new byte[0], 0, 0){

        public String toString() {
            String str = this.utf16;
            if (str != null) {
                return str;
            }
            StringFieldWriter.this.fieldType.indexedToReadable(new BytesRef(this.buf, this.offset, this.length), StringFieldWriter.this.cref);
            this.utf16 = str = StringFieldWriter.this.cref.toString();
            return str;
        }
    };

    public StringFieldWriter(String field, FieldType fieldType) {
        this.field = field;
        this.fieldType = fieldType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(SortDoc sortDoc, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        BytesRef ref;
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (!sortValue.isPresent()) return false;
            ref = (BytesRef)sortValue.getCurrentValue();
        } else {
            SortedDocValues vals = DocValues.getSorted((LeafReader)reader, (String)this.field);
            if (vals.advance(sortDoc.docId) != sortDoc.docId) {
                return false;
            }
            int ord = vals.ordValue();
            ref = vals.lookupOrd(ord);
        }
        if (ew instanceof JavaBinCodec.BinEntryWriter) {
            ew.put((CharSequence)this.field, (CharSequence)this.utf8.reset(ref.bytes, ref.offset, ref.length, null));
            return true;
        } else {
            this.fieldType.indexedToReadable(ref, this.cref);
            String v = this.cref.toString();
            ew.put((CharSequence)this.field, (CharSequence)v);
        }
        return true;
    }
}

