/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.LongValues;
import org.apache.solr.handler.export.IntComp;
import org.apache.solr.handler.export.SortValue;

public class StringValue
implements SortValue {
    protected SortedDocValues globalDocValues;
    protected OrdinalMap ordinalMap;
    protected LongValues toGlobal = LongValues.IDENTITY;
    protected SortedDocValues docValues;
    protected String field;
    protected int currentOrd;
    protected IntComp comp;
    protected int lastDocID;
    private boolean present;

    public StringValue(SortedDocValues globalDocValues, String field, IntComp comp) {
        this.globalDocValues = globalDocValues;
        this.docValues = globalDocValues;
        if (globalDocValues instanceof MultiDocValues.MultiSortedDocValues) {
            this.ordinalMap = ((MultiDocValues.MultiSortedDocValues)globalDocValues).mapping;
        }
        this.field = field;
        this.comp = comp;
        this.currentOrd = comp.resetValue();
        this.present = false;
    }

    @Override
    public StringValue copy() {
        return new StringValue(this.globalDocValues, this.field, this.comp);
    }

    @Override
    public void setCurrentValue(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new AssertionError((Object)("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs doc=" + docId));
        }
        this.lastDocID = docId;
        if (docId > this.docValues.docID()) {
            this.docValues.advance(docId);
        }
        if (docId == this.docValues.docID()) {
            this.present = true;
            this.currentOrd = (int)this.toGlobal.get((long)this.docValues.ordValue());
        } else {
            this.present = false;
            this.currentOrd = -1;
        }
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void setCurrentValue(SortValue sv) {
        StringValue v = (StringValue)sv;
        this.currentOrd = v.currentOrd;
        this.present = v.present;
    }

    @Override
    public Object getCurrentValue() throws IOException {
        assert (this.present);
        return this.docValues.lookupOrd(this.currentOrd);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        if (this.ordinalMap != null) {
            this.toGlobal = this.ordinalMap.getGlobalOrds(context.ord);
        }
        this.docValues = DocValues.getSorted((LeafReader)context.reader(), (String)this.field);
        this.lastDocID = 0;
    }

    @Override
    public void reset() {
        this.currentOrd = this.comp.resetValue();
        this.present = false;
    }

    @Override
    public int compareTo(SortValue o) {
        StringValue sv = (StringValue)o;
        return this.comp.compare(this.currentOrd, sv.currentOrd);
    }

    public String toString() {
        return Integer.toString(this.currentOrd);
    }
}

