/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;

public final class SlowCompositeReaderWrapper
extends LeafReader {
    private final CompositeReader in;
    private final Fields fields;
    private final LeafMetaData metaData;
    private final FieldInfos fieldInfos;
    final Map<String, OrdinalMap> cachedOrdMaps = new HashMap<String, OrdinalMap>();

    public static LeafReader wrap(IndexReader reader) throws IOException {
        if (reader instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader);
        }
        assert (reader instanceof LeafReader);
        return (LeafReader)reader;
    }

    SlowCompositeReaderWrapper(CompositeReader reader) throws IOException {
        this.in = reader;
        this.fields = MultiFields.getFields((IndexReader)this.in);
        this.in.registerParentReader((IndexReader)this);
        if (reader.leaves().isEmpty()) {
            this.metaData = new LeafMetaData(Version.LATEST.major, Version.LATEST, null);
        } else {
            Version minVersion = Version.LATEST;
            for (LeafReaderContext leafReaderContext : reader.leaves()) {
                Version leafVersion = leafReaderContext.reader().getMetaData().getMinVersion();
                if (leafVersion == null) {
                    minVersion = null;
                    break;
                }
                if (!minVersion.onOrAfter(leafVersion)) continue;
                minVersion = leafVersion;
            }
            this.metaData = new LeafMetaData(((LeafReaderContext)reader.leaves().get(0)).reader().getMetaData().getCreatedVersionMajor(), minVersion, null);
        }
        this.fieldInfos = MultiFields.getMergedFieldInfos((IndexReader)this.in);
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        return this.fields.terms(field);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNumericValues((IndexReader)this.in, (String)field);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getBinaryValues((IndexReader)this.in, (String)field);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getSortedNumericValues((IndexReader)this.in, (String)field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        OrdinalMap map = null;
        Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(field);
            if (map == null) {
                SortedDocValues dv = MultiDocValues.getSortedValues((IndexReader)this.in, (String)field);
                if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                    map = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                    IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
                    if (cacheHelper != null && map.owner == cacheHelper.getKey()) {
                        this.cachedOrdMaps.put(field, map);
                    }
                }
                return dv;
            }
        }
        int size = this.in.leaves().size();
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = (LeafReaderContext)this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED) {
                return null;
            }
            SortedDocValues v = reader.getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            }
            totalCost += v.cost();
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedDocValues(values, starts, map, totalCost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        OrdinalMap map = null;
        Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(field);
            if (map == null) {
                SortedSetDocValues dv = MultiDocValues.getSortedSetValues((IndexReader)this.in, (String)field);
                if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                    IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
                    if (cacheHelper != null && map.owner == cacheHelper.getKey()) {
                        this.cachedOrdMaps.put(field, map);
                    }
                }
                return dv;
            }
        }
        assert (map != null);
        int size = this.in.leaves().size();
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long cost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = (LeafReaderContext)this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            }
            values[i] = v;
            starts[i] = context.docBase;
            cost += v.cost();
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map, cost);
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNormValues((IndexReader)this.in, (String)field);
    }

    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        return this.in.getTermVectors(docID);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    public Bits getLiveDocs() {
        this.ensureOpen();
        return MultiFields.getLiveDocs((IndexReader)this.in);
    }

    public PointValues getPointValues(String field) {
        this.ensureOpen();
        return null;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReaderContext ctx : this.in.leaves()) {
            ctx.reader().checkIntegrity();
        }
    }

    public LeafMetaData getMetaData() {
        return this.metaData;
    }
}

