/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetFieldMerger;
import org.apache.solr.search.facet.FacetFieldProcessorByArrayDV;
import org.apache.solr.search.facet.FacetFieldProcessorByArrayUIF;
import org.apache.solr.search.facet.FacetFieldProcessorByEnumTermsStream;
import org.apache.solr.search.facet.FacetFieldProcessorByHashDV;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetRequestSorted;

public class FacetField
extends FacetRequestSorted {
    public static final int DEFAULT_FACET_LIMIT = 10;
    String field;
    boolean missing;
    boolean allBuckets;
    boolean filterAllBuckets;
    boolean numBuckets;
    boolean buckets = true;
    String prefix;
    FacetMethod method;
    int cacheDf;
    Boolean perSeg;

    public FacetField() {
        this.mincount = 1L;
        this.limit = 10L;
    }

    @Override
    public FacetProcessor createFacetProcessor(FacetContext fcontext) {
        boolean multiToken;
        SchemaField sf = fcontext.searcher.getSchema().getField(this.field);
        FieldType ft = sf.getType();
        boolean bl = multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        if (fcontext.facetInfo != null) {
            if (multiToken && !sf.hasDocValues() && this.method != FacetMethod.DV && sf.isUninvertible()) {
                return new FacetFieldProcessorByArrayUIF(fcontext, this, sf);
            }
            return new FacetFieldProcessorByArrayDV(fcontext, this, sf);
        }
        NumberType ntype = ft.getNumberType();
        if (ntype != null) {
            if (this.prefix != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doesn't make sense to set facet prefix on a numeric field");
            }
            if (this.mincount == 0L) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Numeric fields do not support facet mincount=0; try indexing as terms");
            }
        }
        if (this.method == FacetMethod.ENUM) {
            this.method = FacetMethod.STREAM;
        }
        if (this.method == FacetMethod.STREAM && sf.indexed() && !ft.isPointField() && (fcontext.isShard() ? FacetRequest.FacetSort.INDEX_ASC.equals(null == this.prelim_sort ? this.sort : this.prelim_sort) : null == this.prelim_sort && FacetRequest.FacetSort.INDEX_ASC.equals(this.sort))) {
            return new FacetFieldProcessorByEnumTermsStream(fcontext, this, sf);
        }
        if (!multiToken) {
            if (this.mincount > 0L && this.prefix == null && (ntype != null || this.method == FacetMethod.DVHASH)) {
                return new FacetFieldProcessorByHashDV(fcontext, this, sf);
            }
            if (ntype == null) {
                return new FacetFieldProcessorByArrayDV(fcontext, this, sf);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't pick facet algorithm for field " + sf);
        }
        if (sf.hasDocValues() && sf.getType().isPointField()) {
            return new FacetFieldProcessorByHashDV(fcontext, this, sf);
        }
        if (sf.hasDocValues() || this.method == FacetMethod.DV || !sf.isUninvertible()) {
            return new FacetFieldProcessorByArrayDV(fcontext, this, sf);
        }
        return new FacetFieldProcessorByArrayUIF(fcontext, this, sf);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new FacetFieldMerger(this);
    }

    @Override
    public Map<String, Object> getFacetDescription() {
        HashMap<String, Object> descr = new HashMap<String, Object>();
        descr.put("field", this.field);
        descr.put("limit", this.limit);
        return descr;
    }

    public static enum FacetMethod {
        DV,
        UIF,
        DVHASH,
        ENUM,
        STREAM,
        SMART;

        static FacetMethod DEFAULT_METHOD;

        public static FacetMethod fromString(String method) {
            if (method == null || method.length() == 0) {
                return DEFAULT_METHOD;
            }
            switch (method) {
                case "dv": {
                    return DV;
                }
                case "uif": {
                    return UIF;
                }
                case "dvhash": {
                    return DVHASH;
                }
                case "enum": {
                    return ENUM;
                }
                case "stream": {
                    return STREAM;
                }
                case "smart": {
                    return SMART;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown FacetField method " + method);
        }

        static {
            DEFAULT_METHOD = SMART;
        }
    }
}

