/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.stats.HttpClientMetricNameStrategy;
import org.apache.solr.util.stats.InstrumentedHttpRequestExecutor;
import org.apache.solr.util.stats.InstrumentedPoolingHttpClientConnectionManager;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler
implements SolrMetricProducer,
SolrInfoBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExecutorService updateExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrjNamedThreadFactory("updateExecutor"), false);
    private ExecutorService recoveryExecutor;
    private final CloseableHttpClient updateOnlyClient;
    private final CloseableHttpClient recoveryOnlyClient;
    private final CloseableHttpClient defaultClient;
    private final InstrumentedPoolingHttpClientConnectionManager updateOnlyConnectionManager;
    private final InstrumentedPoolingHttpClientConnectionManager recoveryOnlyConnectionManager;
    private final InstrumentedPoolingHttpClientConnectionManager defaultConnectionManager;
    private final InstrumentedHttpRequestExecutor httpRequestExecutor;
    private final Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private MetricRegistry registry;
    private int socketTimeout = 600000;
    private int connectionTimeout = 60000;

    public UpdateShardHandler(UpdateShardHandlerConfig cfg) {
        this.updateOnlyConnectionManager = new InstrumentedPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)HttpClientUtil.getSchemaRegisteryProvider().getSchemaRegistry());
        this.recoveryOnlyConnectionManager = new InstrumentedPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)HttpClientUtil.getSchemaRegisteryProvider().getSchemaRegistry());
        this.defaultConnectionManager = new InstrumentedPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)HttpClientUtil.getSchemaRegisteryProvider().getSchemaRegistry());
        if (cfg != null) {
            this.updateOnlyConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.updateOnlyConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
            this.recoveryOnlyConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.recoveryOnlyConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
            this.defaultConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.defaultConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
        }
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        if (cfg != null) {
            clientParams.set("socketTimeout", cfg.getDistributedSocketTimeout());
            clientParams.set("connTimeout", cfg.getDistributedConnectionTimeout());
            this.socketTimeout = cfg.getDistributedSocketTimeout();
            this.connectionTimeout = cfg.getDistributedConnectionTimeout();
        }
        HttpClientMetricNameStrategy metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get("queryLessURLAndMethod");
        if (cfg != null && (metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get(cfg.getMetricNameStrategy())) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + cfg.getMetricNameStrategy() + " found. Must be one of: " + InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        this.httpRequestExecutor = new InstrumentedHttpRequestExecutor(metricNameStrategy);
        this.updateOnlyClient = HttpClientUtil.createClient((SolrParams)clientParams, (PoolingHttpClientConnectionManager)this.updateOnlyConnectionManager, (boolean)false, (HttpRequestExecutor)this.httpRequestExecutor);
        this.recoveryOnlyClient = HttpClientUtil.createClient((SolrParams)clientParams, (PoolingHttpClientConnectionManager)this.recoveryOnlyConnectionManager, (boolean)false, (HttpRequestExecutor)this.httpRequestExecutor);
        this.defaultClient = HttpClientUtil.createClient((SolrParams)clientParams, (PoolingHttpClientConnectionManager)this.defaultConnectionManager, (boolean)false, (HttpRequestExecutor)this.httpRequestExecutor);
        if (cfg != null) {
            clientParams.set("maxConnections", cfg.getMaxUpdateConnections());
            clientParams.set("maxConnectionsPerHost", cfg.getMaxUpdateConnectionsPerHost());
        }
        log.debug("Created default UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        log.debug("Created update only UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        SolrjNamedThreadFactory recoveryThreadFactory = new SolrjNamedThreadFactory("recoveryExecutor");
        if (cfg != null && cfg.getMaxRecoveryThreads() > 0) {
            log.debug("Creating recoveryExecutor with pool size {}", (Object)cfg.getMaxRecoveryThreads());
            this.recoveryExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)cfg.getMaxRecoveryThreads(), (ThreadFactory)recoveryThreadFactory);
        } else {
            log.debug("Creating recoveryExecutor with unbounded pool");
            this.recoveryExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)recoveryThreadFactory);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        this.registry = manager.registry(registryName);
        String expandedScope = SolrMetricManager.mkName(scope, this.getCategory().name());
        this.updateOnlyConnectionManager.initializeMetrics(manager, registryName, tag, expandedScope);
        this.defaultConnectionManager.initializeMetrics(manager, registryName, tag, expandedScope);
        this.updateExecutor = MetricUtils.instrumentedExecutorService(this.updateExecutor, this, this.registry, SolrMetricManager.mkName("updateOnlyExecutor", expandedScope, "threadPool"));
        this.recoveryExecutor = MetricUtils.instrumentedExecutorService(this.recoveryExecutor, this, this.registry, SolrMetricManager.mkName("recoveryExecutor", expandedScope, "threadPool"));
    }

    @Override
    public String getDescription() {
        return "Metrics tracked by UpdateShardHandler related to distributed updates and recovery";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.UPDATE;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public HttpClient getDefaultHttpClient() {
        return this.defaultClient;
    }

    public HttpClient getUpdateOnlyHttpClient() {
        return this.updateOnlyClient;
    }

    public HttpClient getRecoveryOnlyHttpClient() {
        return this.recoveryOnlyClient;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    public PoolingHttpClientConnectionManager getDefaultConnectionManager() {
        return this.defaultConnectionManager;
    }

    public PoolingHttpClientConnectionManager getRecoveryOnlyConnectionManager() {
        return this.recoveryOnlyConnectionManager;
    }

    public ExecutorService getRecoveryExecutor() {
        return this.recoveryExecutor;
    }

    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.updateExecutor);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.recoveryExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpClientUtil.close((HttpClient)this.updateOnlyClient);
            HttpClientUtil.close((HttpClient)this.recoveryOnlyClient);
            HttpClientUtil.close((HttpClient)this.defaultClient);
            this.updateOnlyConnectionManager.close();
            this.defaultConnectionManager.close();
            this.recoveryOnlyConnectionManager.close();
        }
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }
}

