/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSchemaFieldsUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware,
UpdateRequestProcessorFactory.RunAlways {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TYPE_MAPPING_PARAM = "typeMapping";
    private static final String VALUE_CLASS_PARAM = "valueClass";
    private static final String FIELD_TYPE_PARAM = "fieldType";
    private static final String DEFAULT_FIELD_TYPE_PARAM = "defaultFieldType";
    private static final String COPY_FIELD_PARAM = "copyField";
    private static final String DEST_PARAM = "dest";
    private static final String MAX_CHARS_PARAM = "maxChars";
    private static final String IS_DEFAULT_PARAM = "default";
    private List<TypeMapping> typeMappings = Collections.emptyList();
    private FieldMutatingUpdateProcessorFactory.SelectorParams inclusions = new FieldMutatingUpdateProcessorFactory.SelectorParams();
    private Collection<FieldMutatingUpdateProcessorFactory.SelectorParams> exclusions = new ArrayList<FieldMutatingUpdateProcessorFactory.SelectorParams>();
    private SolrResourceLoader solrResourceLoader = null;
    private String defaultFieldType;

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new AddSchemaFieldsUpdateProcessor(next);
    }

    @Override
    public void init(NamedList args) {
        this.inclusions = FieldMutatingUpdateProcessorFactory.parseSelectorParams(args);
        this.validateSelectorParams(this.inclusions);
        this.inclusions.fieldNameMatchesSchemaField = false;
        this.exclusions = FieldMutatingUpdateProcessorFactory.parseSelectorExclusionParams(args);
        for (FieldMutatingUpdateProcessorFactory.SelectorParams exclusion : this.exclusions) {
            this.validateSelectorParams(exclusion);
        }
        Object defaultFieldTypeParam = args.remove(DEFAULT_FIELD_TYPE_PARAM);
        if (null != defaultFieldTypeParam) {
            if (!(defaultFieldTypeParam instanceof CharSequence)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'defaultFieldType' must be a <str>");
            }
            this.defaultFieldType = defaultFieldTypeParam.toString();
        }
        this.typeMappings = AddSchemaFieldsUpdateProcessorFactory.parseTypeMappings(args);
        if (null == this.defaultFieldType && this.typeMappings.stream().noneMatch(TypeMapping::isDefault)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Must specify either 'defaultFieldType' or declare one typeMapping as default.");
        }
        super.init(args);
    }

    @Override
    public void inform(SolrCore core) {
        this.solrResourceLoader = core.getResourceLoader();
        for (TypeMapping typeMapping : this.typeMappings) {
            typeMapping.populateValueClasses(core);
        }
    }

    private static List<TypeMapping> parseTypeMappings(NamedList args) {
        ArrayList<TypeMapping> typeMappings = new ArrayList<TypeMapping>();
        List typeMappingsParams = args.getAll(TYPE_MAPPING_PARAM);
        for (Object typeMappingObj : typeMappingsParams) {
            if (null == typeMappingObj) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeMapping' init param cannot be null");
            }
            if (!(typeMappingObj instanceof NamedList)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeMapping' init param must be a <lst>");
            }
            NamedList typeMappingNamedList = (NamedList)typeMappingObj;
            Object fieldTypeObj = typeMappingNamedList.remove(FIELD_TYPE_PARAM);
            if (null == fieldTypeObj) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'typeMapping' <lst/> must contain a 'fieldType' <str>");
            }
            if (!(fieldTypeObj instanceof CharSequence)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'fieldType' init param must be a <str>");
            }
            if (null != typeMappingNamedList.get(FIELD_TYPE_PARAM)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'typeMapping' <lst/> may contain only one 'fieldType' <str>");
            }
            String fieldType = fieldTypeObj.toString();
            Collection valueClasses = typeMappingNamedList.removeConfigArgs(VALUE_CLASS_PARAM);
            if (valueClasses.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'typeMapping' <lst/> must contain at least one 'valueClass' <str>");
            }
            Boolean isDefault = false;
            Object isDefaultObj = typeMappingNamedList.remove(IS_DEFAULT_PARAM);
            if (null != isDefaultObj) {
                if (!(isDefaultObj instanceof Boolean)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'default' init param must be a <bool>");
                }
                if (null != typeMappingNamedList.get(IS_DEFAULT_PARAM)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'copyField' <lst/> may contain only one 'default' <bool>");
                }
                isDefault = Boolean.parseBoolean(isDefaultObj.toString());
            }
            ArrayList<CopyFieldDef> copyFieldDefs = new ArrayList<CopyFieldDef>();
            while (typeMappingNamedList.get(COPY_FIELD_PARAM) != null) {
                Object copyFieldObj = typeMappingNamedList.remove(COPY_FIELD_PARAM);
                if (!(copyFieldObj instanceof NamedList)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'copyField' init param must be a <lst>");
                }
                NamedList copyFieldNamedList = (NamedList)copyFieldObj;
                Object destObj = copyFieldNamedList.remove(DEST_PARAM);
                if (null == destObj) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'copyField' <lst/> must contain a 'dest' <str>");
                }
                if (!(destObj instanceof CharSequence)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'copyField' init param must be a <str>");
                }
                if (null != copyFieldNamedList.get(COPY_FIELD_PARAM)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'copyField' <lst/> may contain only one 'copyField' <str>");
                }
                String dest = destObj.toString();
                Integer maxChars = 0;
                Object maxCharsObj = copyFieldNamedList.remove(MAX_CHARS_PARAM);
                if (null != maxCharsObj) {
                    if (!(maxCharsObj instanceof Integer)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'maxChars' init param must be a <int>");
                    }
                    if (null != copyFieldNamedList.get(MAX_CHARS_PARAM)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'copyField' <lst/> may contain only one 'maxChars' <str>");
                    }
                    maxChars = Integer.parseInt(maxCharsObj.toString());
                }
                copyFieldDefs.add(new CopyFieldDef(dest, maxChars));
            }
            typeMappings.add(new TypeMapping(fieldType, valueClasses, isDefault, copyFieldDefs));
            if (0 != typeMappingNamedList.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected 'typeMapping' init sub-param(s): '" + typeMappingNamedList.toString() + "'");
            }
            args.remove(TYPE_MAPPING_PARAM);
        }
        return typeMappings;
    }

    private void validateSelectorParams(FieldMutatingUpdateProcessorFactory.SelectorParams params) {
        if (!params.typeName.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeName' init param is not allowed in this processor");
        }
        if (!params.typeClass.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeClass' init param is not allowed in this processor");
        }
        if (null != params.fieldNameMatchesSchemaField) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'fieldNameMatchesSchemaField' init param is not allowed in this processor");
        }
    }

    private class AddSchemaFieldsUpdateProcessor
    extends UpdateRequestProcessor {
        public AddSchemaFieldsUpdateProcessor(UpdateRequestProcessor next) {
            super(next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (!cmd.getReq().getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            SolrInputDocument doc = cmd.getSolrInputDocument();
            SolrCore core = cmd.getReq().getCore();
            IndexSchema oldSchema = cmd.getReq().getSchema();
            while (true) {
                ArrayList<SchemaField> newFields = new ArrayList<SchemaField>();
                HashMap<String, Map<Integer, List<CopyFieldDef>>> newCopyFields = new HashMap<String, Map<Integer, List<CopyFieldDef>>>();
                FieldMutatingUpdateProcessor.FieldNameSelector selector = this.buildSelector(oldSchema);
                HashMap<String, List<SolrInputField>> unknownFields = new HashMap<String, List<SolrInputField>>();
                this.getUnknownFields(selector, doc, unknownFields);
                for (Map.Entry entry : unknownFields.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    String fieldTypeName = AddSchemaFieldsUpdateProcessorFactory.this.defaultFieldType;
                    TypeMapping typeMapping = this.mapValueClassesToFieldType((List)entry.getValue());
                    if (typeMapping != null) {
                        fieldTypeName = typeMapping.fieldTypeName;
                        if (!typeMapping.copyFieldDefs.isEmpty()) {
                            newCopyFields.put(fieldName, typeMapping.copyFieldDefs.stream().collect(Collectors.groupingBy(CopyFieldDef::getMaxChars)));
                        }
                    }
                    newFields.add(oldSchema.newField(fieldName, fieldTypeName, Collections.emptyMap()));
                }
                if (newFields.isEmpty() && newCopyFields.isEmpty()) {
                    log.debug("No fields or copyFields to add to the schema.");
                    break;
                }
                if (this.isImmutableConfigSet(core)) {
                    String message = "This ConfigSet is immutable.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This ConfigSet is immutable.");
                }
                if (log.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\nFields to be added to the schema: [");
                    boolean isFirst = true;
                    for (SchemaField field : newFields) {
                        builder.append(isFirst ? "" : ",");
                        isFirst = false;
                        builder.append(field.getName());
                        builder.append("{type=").append(field.getType().getTypeName()).append("}");
                    }
                    builder.append("]");
                    builder.append("\nCopyFields to be added to the schema: [");
                    isFirst = true;
                    for (String fieldName : newCopyFields.keySet()) {
                        builder.append(isFirst ? "" : ",");
                        isFirst = false;
                        builder.append("source=").append(fieldName).append("{");
                        for (List copyFieldDefList : ((Map)newCopyFields.get(fieldName)).values()) {
                            for (CopyFieldDef copyFieldDef : copyFieldDefList) {
                                builder.append("{dest=").append(copyFieldDef.getDest(fieldName));
                                builder.append(", maxChars=").append(copyFieldDef.getMaxChars()).append("}");
                            }
                        }
                        builder.append("}");
                    }
                    builder.append("]");
                    log.debug(builder.toString());
                }
                Object object = oldSchema.getSchemaUpdateLock();
                synchronized (object) {
                    try {
                        IndexSchema newSchema = oldSchema.addFields(newFields, Collections.emptyMap(), false);
                        for (String srcField : newCopyFields.keySet()) {
                            for (Integer maxChars : ((Map)newCopyFields.get(srcField)).keySet()) {
                                newSchema = newSchema.addCopyFields(srcField, ((List)((Map)newCopyFields.get(srcField)).get(maxChars)).stream().map(f -> f.getDest(srcField)).collect(Collectors.toList()), maxChars);
                            }
                        }
                        if (null != newSchema) {
                            ((ManagedIndexSchema)newSchema).persistManagedSchema(false);
                            core.setLatestSchema(newSchema);
                            cmd.getReq().updateSchemaToLatest();
                            log.debug("Successfully added field(s) and copyField(s) to the schema.");
                            break;
                        }
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to add fields and/or copyFields.");
                    }
                    catch (ManagedIndexSchema.FieldExistsException e) {
                        log.error("At least one field to be added already exists in the schema - retrying.");
                        oldSchema = core.getLatestSchema();
                        cmd.getReq().updateSchemaToLatest();
                    }
                    catch (ManagedIndexSchema.SchemaChangedInZkException e) {
                        log.debug("Schema changed while processing request - retrying.");
                        oldSchema = core.getLatestSchema();
                        cmd.getReq().updateSchemaToLatest();
                    }
                }
            }
            super.processAdd(cmd);
        }

        private void getUnknownFields(FieldMutatingUpdateProcessor.FieldNameSelector selector, SolrInputDocument doc, Map<String, List<SolrInputField>> unknownFields) {
            for (String fieldName : doc.getFieldNames()) {
                assert (fieldName != null);
                if (fieldName == null || !selector.shouldMutate(fieldName)) continue;
                List<SolrInputField> solrInputFields = unknownFields.get(fieldName);
                if (null == solrInputFields) {
                    solrInputFields = new ArrayList<SolrInputField>();
                    unknownFields.put(fieldName, solrInputFields);
                }
                solrInputFields.add(doc.getField(fieldName));
            }
            List childDocs = doc.getChildDocuments();
            if (null != childDocs) {
                for (SolrInputDocument childDoc : childDocs) {
                    this.getUnknownFields(selector, childDoc, unknownFields);
                }
            }
        }

        private TypeMapping mapValueClassesToFieldType(List<SolrInputField> fields) {
            block0: for (TypeMapping typeMapping : AddSchemaFieldsUpdateProcessorFactory.this.typeMappings) {
                for (SolrInputField field : fields) {
                    assert (field.getValues() != null);
                    if (field.getValues() == null) continue;
                    block2: for (Object fieldValue : field.getValues()) {
                        for (Class<?> valueClass : typeMapping.valueClasses) {
                            if (!valueClass.isInstance(fieldValue)) continue;
                            continue block2;
                        }
                        continue block0;
                    }
                }
                return typeMapping;
            }
            List defaultMappings = AddSchemaFieldsUpdateProcessorFactory.this.typeMappings.stream().filter(TypeMapping::isDefault).collect(Collectors.toList());
            if (defaultMappings.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Only one typeMapping can be default");
            }
            if (defaultMappings.size() == 1) {
                return (TypeMapping)defaultMappings.get(0);
            }
            return null;
        }

        private FieldMutatingUpdateProcessor.FieldNameSelector buildSelector(IndexSchema schema) {
            FieldMutatingUpdateProcessor.FieldNameSelector selector = FieldMutatingUpdateProcessor.createFieldNameSelector(AddSchemaFieldsUpdateProcessorFactory.this.solrResourceLoader, schema, AddSchemaFieldsUpdateProcessorFactory.this.inclusions, fieldName -> null == schema.getFieldTypeNoEx(fieldName));
            for (FieldMutatingUpdateProcessorFactory.SelectorParams exc : AddSchemaFieldsUpdateProcessorFactory.this.exclusions) {
                selector = FieldMutatingUpdateProcessor.wrap(selector, FieldMutatingUpdateProcessor.createFieldNameSelector(AddSchemaFieldsUpdateProcessorFactory.this.solrResourceLoader, schema, exc, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS));
            }
            return selector;
        }

        private boolean isImmutableConfigSet(SolrCore core) {
            NamedList args = core.getConfigSetProperties();
            Object immutable = args != null ? args.get("immutable") : null;
            return immutable != null ? Boolean.parseBoolean(immutable.toString()) : false;
        }
    }

    private static class CopyFieldDef {
        private final String destGlob;
        private final Integer maxChars;

        public CopyFieldDef(String destGlob, Integer maxChars) {
            this.destGlob = destGlob;
            this.maxChars = maxChars;
            if (destGlob.contains("*") && !destGlob.startsWith("*") && !destGlob.endsWith("*")) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "dest '" + destGlob + "' is invalid. Must either be a plain field name or start or end with '*'");
            }
        }

        public Integer getMaxChars() {
            return this.maxChars;
        }

        public String getDest(String srcFieldName) {
            if (!this.destGlob.contains("*")) {
                return this.destGlob;
            }
            if (this.destGlob.startsWith("*")) {
                return srcFieldName + this.destGlob.substring(1);
            }
            return this.destGlob.substring(0, this.destGlob.length() - 1) + srcFieldName;
        }
    }

    private static class TypeMapping {
        public String fieldTypeName;
        public Collection<String> valueClassNames;
        public Collection<CopyFieldDef> copyFieldDefs;
        public Set<Class<?>> valueClasses;
        public Boolean isDefault;

        public TypeMapping(String fieldTypeName, Collection<String> valueClassNames, boolean isDefault, Collection<CopyFieldDef> copyFieldDefs) {
            this.fieldTypeName = fieldTypeName;
            this.valueClassNames = valueClassNames;
            this.isDefault = isDefault;
            this.copyFieldDefs = copyFieldDefs;
        }

        public void populateValueClasses(SolrCore core) {
            IndexSchema schema = core.getLatestSchema();
            ClassLoader loader = core.getResourceLoader().getClassLoader();
            if (null == schema.getFieldTypeByName(this.fieldTypeName)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "fieldType '" + this.fieldTypeName + "' not found in the schema");
            }
            this.valueClasses = new HashSet();
            for (String valueClassName : this.valueClassNames) {
                try {
                    this.valueClasses.add(loader.loadClass(valueClassName));
                }
                catch (ClassNotFoundException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "valueClass '" + valueClassName + "' not found for fieldType '" + this.fieldTypeName + "'");
                }
            }
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

