

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetAvgBkpThroughput.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAvgBkpThroughput'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAvgBkpThroughput]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAvgBkpThroughput]
  delete from GXDBVersions where name = 'GetAvgBkpThroughput' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetAvgBkpThroughput]
	(
		@i_CommServUniqueId INT = 0,
		@i_lastNDays INT = 1,
		@i_Type INT = 0, --0-> Tape, 1 = DISK, 2->All
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	)
	RETURNS DECIMAL(32,2)
	AS
	BEGIN
	IF ( @i_lastNDays = 0) return 0
	DECLARE @AvgThroughput DECIMAL(32, 2) = 0
	DECLARE @iQueryId INT = 55
	DECLARE @iLatest INT = 1
	DECLARE	@LastDays INT = @i_lastNDays

	SELECT @AvgThroughput =
		   SUM(csInfo.AppSizeGB)/(@i_lastNDays*24)
	FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@iQueryId, @i_CommServUniqueId, @iLatest, NULL, NULL, @i_UserId, @i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND (csInfo.IsDisk = @i_Type OR @i_Type = 2) --Disk OR Tape OR Both
			AND DATEDIFF(day, jobsEndDate,resultView.Logdate) <= @i_lastNDays
	RETURN @AvgThroughput
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAvgBkpThroughput]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAvgBkpThroughput' AND revision = '1.6')

  insert into GXDBVersions values(5, 'GetAvgBkpThroughput',  '1.6', 'GetAvgBkpThroughput', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
