

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetUnixTimeBig.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUnixTimeBig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUnixTimeBig]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUnixTimeBig]
  delete from GXDBVersions where name = 'GetUnixTimeBig' and type = 5
END
GO

	CREATE FUNCTION GetUnixTimeBig (@DateTimeArg datetime)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @dateTimeBase DATETIME
    DECLARE @unixtime BIGINT
    SET @dateTimeBase = '01/01/1970'
	IF (@DateTimeArg < @dateTimeBase)
	  set @unixtime = 0
	ELSE
		SET @unixtime = (convert(bigint, datediff(day, @dateTimeBase, @DateTimeArg)) * 24 * 60 * 60) + (datediff(second, dateadd(day, datediff(day, 0, @DateTimeArg), 0), @DateTimeArg))
	return @unixtime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUnixTimeBig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUnixTimeBig' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetUnixTimeBig',  '1.2', 'GetUnixTimeBig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
