

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/JobSelectionPatternFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JobSelectionPatternFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JobSelectionPatternFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JobSelectionPatternFunc]
  delete from GXDBVersions where name = 'JobSelectionPatternFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[JobSelectionPatternFunc] (
		@SelectionType INT, @SelectionFlags INT, @NumberPeriod INT, @DayNumber INT
		)
		RETURNS VARCHAR(1024)
	AS
	BEGIN
		DECLARE	@tempStr VARCHAR(1024)

		IF	@SelectionType = 0
			SET	@tempStr = 'All jobs'
		ELSE
		IF	@SelectionType = 1
			SET	@tempStr = 'All full jobs'
		ELSE
		IF	@SelectionType = 2
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'week' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' weeks' END
							+ ' starting from '
							+ CASE @DayNumber WHEN 1 THEN 'Monday' WHEN 2 THEN 'Tuesday' WHEN 3 THEN 'Wednesday'
								WHEN 4 THEN 'Thurday' WHEN 5 THEN 'Friday' WHEN 6 THEN 'Saturday' ELSE 'Sunday' END
		ELSE
		IF	@SelectionType = 3
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'day' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' days' END
		ELSE
		IF	@SelectionType = 4
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'month' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' months' END
							+ ' starting from '
							+ CASE @DayNumber WHEN 1 THEN '1st' WHEN 2 THEN '2nd' WHEN 3 THEN '3rd'
								ELSE CAST(@DayNumber AS VARCHAR(8)) + 'th' END + ' day'
		ELSE
		IF	@SelectionType = 8
			SET	@tempStr = 'Latest full jobs'
		ELSE
		IF	@SelectionType = 9
			SET	@tempStr = 'Manually selected full jobs'
		ELSE
		IF	@SelectionType = 10
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'hour' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' hours' END

		RETURN @tempStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JobSelectionPatternFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JobSelectionPatternFunc' AND revision = '1.1')

  insert into GXDBVersions values(5, 'JobSelectionPatternFunc',  '1.1', 'JobSelectionPatternFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
