

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/PredictDateToBeFullFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: PredictDateToBeFullFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PredictDateToBeFullFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[PredictDateToBeFullFunc]
  delete from GXDBVersions where name = 'PredictDateToBeFullFunc' and type = 5
END
GO

    IF  NOT EXISTS (SELECT * FROM sys.types st WHERE st.name = N'PeakSizeTblType')
    BEGIN
		create TYPE PeakSizeTblType AS TABLE
		(
			KeyCol1 varchar(max),
			KeyCol2 varchar(max),
			CommServUniqueId int,
			WeekStart datetime,
			DiskUsageMB bigint,
			FreeDiskSpaceMB bigint
		);
    END
    GO
    IF  NOT EXISTS (SELECT * FROM sys.types st WHERE st.name = N'SrcTblType')
    BEGIN
		create TYPE SrcTblType AS TABLE
		(
			KeyCol1 varchar(max),
			KeyCol2 varchar(max),
			CommServUniqueId int,
			LogDateUTC datetime,
			LogDate datetime,
			TotalCapacityMB bigint,
			DiskUsageMB bigint,
			FreeDiskSpaceMB bigint
		);
    END
    GO

	CREATE FUNCTION [dbo].[PredictDateToBeFullFunc]
	(
		@i_SrcTbl SrcTblType READONLY,
		@i_PeakSizeTbl PeakSizeTblType READONLY,
		@i_CommServUniqueID int
	)
	RETURNS @Results TABLE (
		CommServUniqueId int,
		KeyCol1 varchar(max),
		KeyCol2 varchar(max),
		Slope float,
		DaysToBeFull bigint
	)
	as
	begin
		DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
		DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
		DECLARE @CurrWeek DATE = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
		DECLARE @MaxNumOfWeeksforGrowthRate INT = 12
		DECLARE @FirstWeek DATE = DATEADD(WEEK, -@MaxNumOfWeeksforGrowthRate, @CurrWeek)

		DECLARE @TblLeastSquareData TABLE (
			CommServUniqueId INT,
			KeyCol1 varchar(max),
			KeyCol2 varchar(max),
			X INT,
			Y FLOAT
		)

		INSERT INTO @TblLeastSquareData
		SELECT S.CommServUniqueId, S.KeyCol1, S.KeyCol2, DATEDIFF(WEEK, S.WeekStart, @CurrWeek), ISNULL(S.DiskUsageMB, -1)
		FROM @i_PeakSizeTbl S
				INNER JOIN (
					select A.CommServUniqueId, A.KeyCol1, A.KeyCol2, isnull(max(A.TotalCapacityMB),0) as TotalCapacityMBMax
					from @i_SrcTbl as A
					group by A.CommServUniqueId, A.KeyCol1, A.KeyCol2
				) T ON S.CommservUniqueId = T.CommServUniqueId AND S.KeyCol1 = T.KeyCol1 AND S.KeyCol2 = T.KeyCol2
		WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DiskUsageMB, -1) > 0 and T.TotalCapacityMBMax > 0
		OPTION	(RECOMPILE)

		DELETE  @TblLeastSquareData
		FROM    @TblLeastSquareData T INNER JOIN
				(SELECT CommServUniqueId, KeyCol1, KeyCol2, Max(X) AS MaxX, COUNT(*) AS NumOfPrevData
				FROM    @TblLeastSquareData
				GROUP BY CommServUniqueId, KeyCol1, KeyCol2
				) S ON T.CommServUniqueId = S.CommServUniqueId AND S.KeyCol1 = T.KeyCol1 AND S.KeyCol2 = T.KeyCol2
		WHERE   X = MaxX AND NumOfPrevData > 2 OR NumOfPrevData < 2
		OPTION	(RECOMPILE)

		DELETE  @TblLeastSquareData
		FROM    @TblLeastSquareData T INNER JOIN
				(SELECT CommServUniqueId, KeyCol1, KeyCol2, COUNT(*) AS NumOfPrevData
				FROM    @TblLeastSquareData
				GROUP BY CommServUniqueId, KeyCol1, KeyCol2
				) S ON T.CommServUniqueId = S.CommServUniqueId AND S.KeyCol1 = T.KeyCol1 AND S.KeyCol2 = T.KeyCol2
		WHERE   X = 0 AND NumOfPrevData > 2
		OPTION	(RECOMPILE)

		insert into @Results
		SELECT DISTINCT
			F.CommServUniqueId, F.KeyCol1, F.KeyCol2, F.Slope,
			(
			case
			when csInfo.FreeDiskSpaceMB is null
			then
				@NA
			else
				case
				when csInfo.FreeDiskSpaceMB > 0
				then
					case
					when F.Slope is null
					then
						@NA
					else
						case
						when (-F.Slope > 0)
						then
							case
							when csInfo.LogDateUTC is null
							then
								@NA
							else
								CASE
								WHEN (FreeDiskSpaceMB/(-F.Slope) - DATEDIFF(DAY, csInfo.LogDateUTC, GETUTCDATE())) <= 0 THEN 0
								WHEN (FreeDiskSpaceMB/(-F.Slope) - DATEDIFF(DAY, csInfo.LogDateUTC, GETUTCDATE())) > 9999 THEN @Never
								ELSE (FreeDiskSpaceMB/(-F.Slope) - DATEDIFF(DAY, csInfo.LogDateUTC, GETUTCDATE()))
								END
							END
						else
							@Never
						end
					end
				else
					0
				end
			end
			) as DaysToBeFull
		FROM @i_SrcTbl AS csInfo
			left join (
				SELECT  A.CommServUniqueId, A.KeyCol1, A.KeyCol2, SUM((X - AvgX)*(Y - AvgY))/SUM((X - AvgX)*(X - AvgX))/7.0 as Slope
			FROM    (
				SELECT CommServUniqueId, KeyCol1, KeyCol2, AVG(X) as AvgX, AVG(Y) as AvgY
			FROM    @TblLeastSquareData
			GROUP BY CommServUniqueId, KeyCol1, KeyCol2

			) A INNER JOIN @TblLeastSquareData D ON A.CommServUniqueId = D.CommServUniqueId AND A.KeyCol1 = D.KeyCol1 AND A.KeyCol2 = D.KeyCol2
			GROUP BY A.CommServUniqueId, A.KeyCol1, A.KeyCol2
			HAVING SUM((X - AvgX)*(X - AvgX)) > 0
			) F
				on csInfo.CommServUniqueId = F.CommServUniqueId
				and csInfo.KeyCol1 = F.KeyCol1
				and csInfo.KeyCol2 = F.KeyCol2
				where (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		OPTION	(RECOMPILE)

		return
	end


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [PredictDateToBeFullFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'PredictDateToBeFullFunc' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'PredictDateToBeFullFunc',  '1.1.2.2', 'PredictDateToBeFullFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
