

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptCommCellSLAInfo.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptCommCellSLAInfo'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptCommCellSLAInfo]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptCommCellSLAInfo]
  delete from GXDBVersions where name = 'RptCommCellSLAInfo' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptCommCellSLAInfo] (
		@i_CommServUniqueId INT = 0,
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	 )
	RETURNS @TblCommCellSLAInfo TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID INTEGER NOT NULL,
		SLAPercent DECIMAL(6, 2) NOT NULL,
		SLAStatus VARCHAR(10) NOT NULL,
		SLAAsOf DATETIME NOT NULL,
		ProtectedSubclients INTEGER NOT NULL,
		NotProtectedSubclients INTEGER NOT NULL
	)
	 AS
	 BEGIN
	DECLARE @strGood		VARCHAR(10) = 'Good'
	DECLARE @strInfo		VARCHAR(10) = 'Info'
	DECLARE @strWarning		VARCHAR(10) = 'Warning'
	DECLARE @strCritical	VARCHAR(10) = 'Critical'
	DECLARE @strUnknown		VARCHAR(10) = 'Unknown'
	DECLARE @WarningThreshold INT, @CriticalThreshold INT
	SELECT @WarningThreshold = WarningThreshold, @CriticalThreshold= CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 27

	INSERT INTO @TblCommCellSLAInfo
	SELECT
		sub.CommServUniqueId,
		CAST(sub.CommCellID AS INT) AS CommCellID,
		CASE
			WHEN (sub.NotProtectedClients+sub.ProtectedClients) > 0 THEN CAST(sub.ProtectedClients*100.0/(sub.NotProtectedClients+sub.ProtectedClients) AS DECIMAL(6, 2))
			ELSE 0
		END,
		CASE
			WHEN (sub.NotProtectedClients+sub.ProtectedClients) = 0 THEN @strUnknown
			WHEN sub.ProtectedClients*100/(sub.NotProtectedClients+sub.ProtectedClients) < @criticalThreshold THEN @strCritical
			WHEN sub.ProtectedClients*100/(sub.NotProtectedClients+sub.ProtectedClients) < @warningThreshold THEN @strWarning
			ELSE @strGood
		END,
		sub.AsOfDate,
		ProtectedClients,
		NotProtectedClients
	FROM
		(SELECT DISTINCT
			resultView.CommServUniqueId,
			resultView.CommCellID,
			csInfo.AsOfDate,
			csInfo.ProtectedClients,
			csInfo.NotProtectedClients
		FROM
			cf_SurveySLASummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueId, 1, 0, 0, @i_UserId, @i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId AND (csInfo.Days = 30 OR csInfo.Days < 0)) AS sub
	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptCommCellSLAInfo]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptCommCellSLAInfo' AND revision = '1.4.2.2')

  insert into GXDBVersions values(5, 'RptCommCellSLAInfo',  '1.4.2.2', 'RptCommCellSLAInfo', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
