

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetCommCellGroups.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetCommCellGroups'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetCommCellGroups]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetCommCellGroups]
  delete from GXDBVersions where name = 'RptGetCommCellGroups' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetCommCellGroups]
	(
		@i_UserId INT = NULL
	)
	RETURNS @TblGroupResult TABLE
	(
		GroupId INTEGER NOT NULL,
		GroupName NVARCHAR(512) NOT NULL,
		GroupDescription NVARCHAR(MAX) NULL,
		CommCellCount INTEGER NOT NULL,
		ActiveClients INTEGER NOT NULL,
		SLA INTEGER NOT NULL,
		GroupCreatedBy NVARCHAR(255) NULL,
		GroupModifiedBy NVARCHAR(255) NULL
	)
	AS
	BEGIN
	DECLARE @UserCapability INT = -1
	DECLARE @UserProp xml
	SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
	IF @i_UserId = -1
		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = 1)
	ELSE
		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
	DECLARE @groupTbl TABLE (gId INT)
	IF (@i_UserId = -1 OR @UserCapability = 1) --pickup all groups for users with surveycapability set
	BEGIN
		INSERT INTO @groupTbl(gId) SELECT id FROM cf_CommcellGroup WITH (NOLOCK)
 	END
 	ELSE IF (@i_UserId IS NOT NULL)
	BEGIN
		INSERT INTO @groupTbl(gId)
		SELECT ccg.value('@clientGroupId', 'INT')
		FROM   @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
			   CROSS apply resp.nodes('commcellGroups') AS ccg(ccg)
		UNION
		SELECT CG.id
		FROM (
				SELECT
					ccg.value('@userGroupId', 'INT') companyId
				From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
					CROSS apply resp.nodes('companies/company') AS ccg(ccg)
			) UG
			INNER JOIN cf_CustomerGroup G WITH(NOLOCK)
				ON G.id = UG.companyId
			INNER JOIN cf_CommcellGroup CG WITH(NOLOCK)
				ON CG.id = G.clientGroupId
				AND CG.status & 32 <> 0
	END
	ELSE
	BEGIN
		RETURN
	END

	DECLARE @CommCellCount TABLE (gId INT, nCommCells INT)
	INSERT	INTO @CommCellCount
	SELECT	gId, COUNT(DISTINCT CommcellIdNameMap_ID)
	FROM	cf_CommcellGroupAssoc WITH (NOLOCK)
			INNER JOIN cf_CommcellIdNameMap ON CommcellIdNameMap_ID = ID
			INNER JOIN @groupTbl ON gId = commCellGroupId
	GROUP BY gId

	DECLARE @ClientCount TABLE (gId INT, nActiveClients INT)
	INSERT	INTO @ClientCount
	SELECT	gId, SUM(ISNULL(TotalActiveClients,0))
	FROM	dbo.cf_SurveyResultFuncV1(8, 0, 3, NULL, NULL, @i_UserId, -1) AS R
			INNER JOIN cf_SurveyClientStatisticsInfo C WITH (NOLOCK) ON C.SurveyResultId = R.SurverResultId
			INNER JOIN cf_CommcellGroupAssoc WITH (NOLOCK) ON CommcellIdNameMap_ID = R.CommServUniqueId
			INNER JOIN @groupTbl ON gId = CommCellGroupId
	GROUP BY gId

	DECLARE @SLACounts TABLE (gId INT, ProtectedClients INT, NotProtectedClients INT)
	INSERT	INTO @SLACounts
	SELECT	gId, SUM(ISNULL(ProtectedClients,0)), SUM(ISNULL(NotProtectedClients,0))
	FROM	dbo.cf_SurveyResultFuncV1(146, 0, 3, NULL, NULL, @i_UserId, -1) AS R
			INNER JOIN cf_CommcellSummary C WITH (NOLOCK) ON C.SurveyResultId = R.SurverResultId
			INNER JOIN cf_CommcellGroupAssoc WITH (NOLOCK) ON CommcellIdNameMap_ID = R.CommServUniqueId
			INNER JOIN @groupTbl ON gId = CommCellGroupId
	GROUP BY gId

	INSERT INTO @TblGroupResult
	SELECT
		g.id,
		g.name,
		g.description,
		ISNULL(cc.nCommCells, 0),
		ISNULL(cl.nActiveClients, 0),
		ISNULL(CAST((CASE WHEN (NotProtectedClients+ProtectedClients)>0 THEN 100.0*ProtectedClients/(NotProtectedClients+ProtectedClients) ELSE 0 END) AS INT), 0),
		g.createdByUser,
		g.modifiedByUser
	FROM	cf_CommCellGroup g WITH (NOLOCK)
		INNER JOIN @groupTbl t ON t.gId = g.id
		LEFT OUTER JOIN @CommCellCount cc ON cc.gId = g.id
		LEFT OUTER JOIN @ClientCount cl ON cl.gId = g.id
		LEFT OUTER JOIN @SLACounts sla ON sla.gId = g.id
	ORDER BY g.name ASC

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetCommCellGroups]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetCommCellGroups' AND revision = '1.9.2.7')

  insert into GXDBVersions values(5, 'RptGetCommCellGroups',  '1.9.2.7', 'RptGetCommCellGroups', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
