

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/cf_SurveyResultFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: cf_SurveyResultFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_SurveyResultFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cf_SurveyResultFunc]
  delete from GXDBVersions where name = 'cf_SurveyResultFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[cf_SurveyResultFunc] (
		@i_QueryId		INT,
		@i_CSUniqueId	INT = 0,
		@i_LatestOnly	INT = 1,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEnd	DATETIME = NULL,
		@i_UserId  		INT = NULL
	 )
	 RETURNS @Results TABLE (
	 	CommServUniqueId INT,
		CommCellID       VARCHAR(32),
		CommServIP       VARCHAR(256),
		CommServGUID     VARCHAR(256),
		CustomerName     NVARCHAR(256),
		CommServName     NVARCHAR(256),
		CommServTimeZone VARCHAR(256),
		CommServVersion  VARCHAR(256),
		CommServEdition	 VARCHAR(256),
		SurverResultId   INT,
		SurveyID         INT,
		LogDate          DATETIME,
		LogDateUTC       DATETIME,
		RunningTime      INT,
		SureyResultFlags INT
	 )
	 AS
	 BEGIN
	 		DECLARE @i_GroupId INT
	 		SET @i_GroupId = -1
	 		INSERT INTO @Results
			SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, CustomerName, CommServName,
					CommServTimeZone, CommServVersion, CommServEdition, SurverResultId,
					SurveyID, LogDate, LogDateUTC, RunningTime, SureyResultFlags
			FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CSUniqueId, @i_LatestOnly, @i_LogDateStart, @i_LogDateEnd, @i_UserId, @i_GroupId) AS result

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cf_SurveyResultFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cf_SurveyResultFunc' AND revision = '1.8')

  insert into GXDBVersions values(5, 'cf_SurveyResultFunc',  '1.8', 'cf_SurveyResultFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
