

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/AddUpdateCommcellNotes.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/AddUpdateCommcellNotes.sp,v $ $Id: AddUpdateCommcellNotes.sp,v 1.1.2.4 2018/05/03 03:36:09 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AddUpdateCommcellNotes <<<'

IF EXISTS (select * from sysobjects where name='AddUpdateCommcellNotes')
	drop procedure AddUpdateCommcellNotes
IF EXISTS (select * from GxQscripts where name='AddUpdateCommcellNotes')
	delete from GxQscripts where name = 'AddUpdateCommcellNotes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddUpdateCommcellNotes')
	delete from GXDBVersions where aliasname = 'AddUpdateCommcellNotes'
GO
print '... Creating Procedure: AddUpdateCommcellNotes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AddUpdateCommcellNotes
  @i_CommServGUID varchar(256),
  @i_userId INT,
  @i_notes NVARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
    DECLARE @CommcellUniqueId INT
    SELECT @CommcellUniqueId = ID FROM cf_CommcellIdNameMap WHERE CommServGUID = @i_CommServGUID
    --update the older notes
    UPDATE cf_CommservSurveyCommcellNotes SET modified = dbo.GetUnixTimeBig(SYSDATETIME())
        WHERE CommcellIdNameMap_ID = @CommcellUniqueId AND modified = 0
    --Insert new notes
    INSERT INTO cf_CommservSurveyCommcellNotes (CommcellIdNameMap_ID, UserID, Notes, Created, Modified)
        VALUES (@CommcellUniqueId, @i_userId, @i_notes, dbo.GetUnixTimeBig(SYSDATETIME()), 0)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
END TRY
BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AddUpdateCommcellNotes')
	delete from GxQscripts where name = 'AddUpdateCommcellNotes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddUpdateCommcellNotes')
	delete from GXDBVersions where aliasname = 'AddUpdateCommcellNotes'
GO

insert into GXDBVersions values(2, 'AddUpdateCommcellNotes',  '00010001000200040000', 'AddUpdateCommcellNotes', '00010001000200040000')
GO

