

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_AssociateClientGroupToContract.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_AssociateClientGroupToContract.sp,v $ $Id: CM_AssociateClientGroupToContract.sp,v 1.1.2.14 2020/12/19 05:11:55 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CM_AssociateClientGroupToContract')
BEGIN
	print '>>> Drop Stored Procedure: CM_AssociateClientGroupToContract <<<'
	drop procedure CM_AssociateClientGroupToContract
END
IF EXISTS (select * from GxQscripts where name='CM_AssociateClientGroupToContract')
	delete from GxQscripts where name = 'CM_AssociateClientGroupToContract'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_AssociateClientGroupToContract')
	delete from GXDBVersions where aliasname = 'CM_AssociateClientGroupToContract'
GO
print '... Creating Procedure: CM_AssociateClientGroupToContract'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CM_AssociateClientGroupToContract
  @i_UserId INT = NULL,
  @i_Option INT = 1,
  @i_GroupId INT = 0,
  @i_ContractId INT	= 0,
  @i_MinimumFee FLOAT = 0,
  @i_BillingType INT = 0, --[0-monthly, 1-quarterly]
  @i_UseAsPO INT = 0, --[0-use as PO, 1-don't use as PO]
  @i_XML NTEXT = ''
AS
--Option 1, Associate a client group to a contract
--Option 2, Modify a client group association to a contract
--Option 3, Remove a client group association to a contract
--Option 4, Associate an aggregator to a contract
--Option 5, Modify an aggregator association to a contract
--Option 6, Remove an aggregator association to a contract
--Option 7, Associate a partner to a contract
--Option 8, Modify a partner association to a contract
--Option 9, Remove a partner association to a contract
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   VARIABLES
-- ----------------------------------------------------------------------------
DECLARE @retValue	INT = 0
DECLARE @errMsg		VARCHAR(256) = 'Procedure Completed Successfully'
DECLARE @idoc			INT
DECLARE @currencyCode NVARCHAR(5) = 'USD'
DECLARE @reportToVolumeDiscountMapId INT = NULL
DECLARE @temp TABLE (discountPercentage FLOAT, lowerThreshold FLOAT, upperThreshold FLOAT)
-- ----------------------------------------------------------------------------
--   Start a Transaction
-- ----------------------------------------------------------------------------
BEGIN TRANSACTION
	-- ----------------------------------------------------------------------------
	--   TRY-CATCH Block
	-- ----------------------------------------------------------------------------
	BEGIN TRY
		IF @i_Option IN (2,5,8)--find volume discount of client group/aggregator/partner
		BEGIN
			EXEC sp_xml_preparedocument @idoc OUTPUT, @i_XML--   PARSE XML
			INSERT @temp
            SELECT discountPercentage,lowerThreshold,upperThreshold
                        FROM   OPENXML(@idoc, '/WebReport_VolumeDiscount/discountTier', 3)
                        WITH    (discountPercentage  FLOAT,
                                 lowerThreshold      FLOAT,
                                 upperThreshold      FLOAT)
			--get contract currency
			SELECT @currencyCode=currencyCode FROM cm_Contract WITH (NOLOCK) WHERE contractId=@i_ContractId
		END
		--Default contract is now hidden in UI (from SP17). So contractId should be explicitly set to add/modify service provider & partner associations
		IF @i_Option IN (4,5,7,8)
		BEGIN
			IF @i_ContractId=-1
				SELECT @i_ContractId=contractId FROM cm_Contract WITH (NOLOCK) WHERE contractName='Legacy Partner Contract'
		END
		IF @i_Option = 1
		BEGIN
			IF EXISTS (SELECT contractId FROM cm_ClientGroupToContractMap WITH (NOLOCK) WHERE clientGroupId=@i_GroupId)
			BEGIN
				SET @errMsg='This Billing Group is already associated to another contract'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				INSERT INTO cm_ClientGroupToContractMap VALUES (@i_GroupId,@i_ContractId,@i_MinimumFee,@i_BillingType,@i_UseAsPO)
				SET @errMsg='Billing Group associated to contract successfully'
			END
		END
		ELSE IF @i_Option = 2
		BEGIN
			UPDATE cm_ClientGroupToContractMap SET contractId = @i_ContractId, minimumFee=@i_MinimumFee, billingType=@i_BillingType, useAsPO=@i_UseAsPO WHERE clientGroupId = @i_GroupId
			--insert/update volume discount for client group
			SELECT @reportToVolumeDiscountMapId=reportToVolumeDiscountMapId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=0 AND reportId=@i_GroupId
			IF @reportToVolumeDiscountMapId IS NOT NULL--volume discount for this client group is already defined
			BEGIN
				IF NOT EXISTS (SELECT 1 FROM @temp)--if volume discount is deleted, remove it from cm_ReportToVolumeDiscountMap
				BEGIN
					DELETE FROM cm_ReportToVolumeDiscountMap WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
				END
				ELSE
				BEGIN
					DELETE FROM cm_VolumeDiscount WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
					INSERT INTO cm_VolumeDiscount SELECT @reportToVolumeDiscountMapId, lowerThreshold, upperThreshold, discountPercentage, 0, 0 FROM @temp
				END
			END
			ELSE--adding volume discount for this client group newly
			BEGIN
				IF EXISTS (SELECT 1 FROM @temp)--insert into both tables only if volume discount entries are present. Without this check, issue in MR 278933 will occur and RR summary will be incorrect
				BEGIN
					INSERT INTO cm_ReportToVolumeDiscountMap VALUES (0, @i_GroupId, @currencyCode, 0, 0)
					SELECT @reportToVolumeDiscountMapId=SCOPE_IDENTITY()
					INSERT INTO cm_VolumeDiscount SELECT @reportToVolumeDiscountMapId, lowerThreshold, upperThreshold, discountPercentage, 0, 0 FROM @temp
				END
			END
			SET @errMsg='Successfully modified the Billing Group - Contract association'
		END
		ELSE IF @i_Option = 3
		BEGIN
			DELETE FROM cm_ClientGroupToContractMap WHERE clientGroupId = @i_GroupId
			--delete volume discount if it exists
			SELECT @reportToVolumeDiscountMapId=reportToVolumeDiscountMapId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=0 AND reportId=@i_GroupId
			DELETE FROM cm_VolumeDiscount WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
			DELETE FROM cm_ReportToVolumeDiscountMap WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
			SET @errMsg='Successfully deleted the Billing Group - Contract association'
		END
		ELSE IF @i_Option = 4
		BEGIN
			IF EXISTS (SELECT contractId FROM cm_AggregatorToContractMap WITH (NOLOCK) WHERE aggregatorId=@i_GroupId)
			BEGIN
				SET @errMsg='This Service Provider is already associated to another contract'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				INSERT INTO cm_AggregatorToContractMap VALUES (@i_GroupId,@i_ContractId,@i_BillingType,@i_UseAsPO,@i_MinimumFee)
				SET @errMsg='Service Provider associated to contract successfully'
			END
		END
		ELSE IF @i_Option = 5
		BEGIN
			UPDATE cm_AggregatorToContractMap SET contractId = @i_ContractId, billingType=@i_BillingType, useAsPO=@i_UseAsPO, minimumFee=@i_MinimumFee WHERE aggregatorId = @i_GroupId
			--insert/update volume discount for aggregator
			SELECT @reportToVolumeDiscountMapId=reportToVolumeDiscountMapId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=1 AND reportId=@i_GroupId
			IF @reportToVolumeDiscountMapId IS NOT NULL--volume discount for this aggregator is already defined
			BEGIN
				IF NOT EXISTS (SELECT 1 FROM @temp)--if volume discount is deleted, remove it from cm_ReportToVolumeDiscountMap
				BEGIN
					DELETE FROM cm_ReportToVolumeDiscountMap WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
				END
				ELSE
				BEGIN
					DELETE FROM cm_VolumeDiscount WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
					INSERT INTO cm_VolumeDiscount SELECT @reportToVolumeDiscountMapId, lowerThreshold, upperThreshold, discountPercentage, 0, 0 FROM @temp
				END
			END
			ELSE--adding volume discount for this aggregator newly
			BEGIN
				IF EXISTS (SELECT 1 FROM @temp)--insert into both tables only if volume discount entries are present. Without this check, issue in MR 278933 will occur and RR summary will be incorrect
				BEGIN
					INSERT INTO cm_ReportToVolumeDiscountMap VALUES (1, @i_GroupId, @currencyCode, 0, 0)
					SELECT @reportToVolumeDiscountMapId=SCOPE_IDENTITY()
					INSERT INTO cm_VolumeDiscount SELECT @reportToVolumeDiscountMapId, lowerThreshold, upperThreshold, discountPercentage, 0, 0 FROM @temp
				END
			END
			SET @errMsg='Successfully modified the Service Provider - Contract association'
		END
		ELSE IF @i_Option = 6
		BEGIN
			DELETE FROM cm_AggregatorToContractMap WHERE aggregatorId = @i_GroupId
			--delete volume discount if it exists
			SELECT @reportToVolumeDiscountMapId=reportToVolumeDiscountMapId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=1 AND reportId=@i_GroupId
			DELETE FROM cm_VolumeDiscount WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
			DELETE FROM cm_ReportToVolumeDiscountMap WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
			SET @errMsg='Successfully deleted the Service Provider - Contract association'
		END
		ELSE IF @i_Option = 7
		BEGIN
			IF EXISTS (SELECT contractId FROM cm_PartnerToContractMap WITH (NOLOCK) WHERE partnerId=@i_GroupId)
			BEGIN
				SET @errMsg='This Partner is already associated to another contract'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				INSERT INTO cm_PartnerToContractMap VALUES (@i_GroupId,@i_ContractId,@i_BillingType,@i_UseAsPO,@i_MinimumFee)
				SET @errMsg='Partner associated to contract successfully'
			END
		END
		ELSE IF @i_Option = 8
		BEGIN
			UPDATE cm_PartnerToContractMap SET contractId = @i_ContractId, billingType=@i_BillingType, useAsPO=@i_UseAsPO, discountPercentage=@i_MinimumFee WHERE partnerId = @i_GroupId
			--insert/update volume discount for partner
            SELECT @reportToVolumeDiscountMapId=reportToVolumeDiscountMapId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=2 AND reportId=@i_GroupId
            IF @reportToVolumeDiscountMapId IS NOT NULL--volume discount for this partner is already defined
            BEGIN
                IF NOT EXISTS (SELECT 1 FROM @temp)--if volume discount is deleted, remove it from cm_ReportToVolumeDiscountMap
                BEGIN
                    DELETE FROM cm_ReportToVolumeDiscountMap WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
                END
                ELSE
                BEGIN
                    DELETE FROM cm_VolumeDiscount WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
                    INSERT INTO cm_VolumeDiscount SELECT @reportToVolumeDiscountMapId, lowerThreshold, upperThreshold, discountPercentage, 0, 0 FROM @temp
                END
            END
            ELSE--adding volume discount for this partner newly
            BEGIN
                IF EXISTS (SELECT 1 FROM @temp)--insert into both tables only if volume discount entries are present. Without this check, issue in MR 278933 will occur and RR summary will be incorrect
                BEGIN
                    INSERT INTO cm_ReportToVolumeDiscountMap VALUES (2, @i_GroupId, @currencyCode, 0, 0)
                    SELECT @reportToVolumeDiscountMapId=SCOPE_IDENTITY()
                    INSERT INTO cm_VolumeDiscount SELECT @reportToVolumeDiscountMapId, lowerThreshold, upperThreshold, discountPercentage, 0, 0 FROM @temp
                END
            END
			SET @errMsg='Successfully modified the Partner - Contract association'
		END
		ELSE IF @i_Option = 9
		BEGIN
			DELETE FROM cm_PartnerToContractMap WHERE partnerId = @i_GroupId
			--delete volume discount if it exists
			SELECT @reportToVolumeDiscountMapId=reportToVolumeDiscountMapId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=2 AND reportId=@i_GroupId
			DELETE FROM cm_VolumeDiscount WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
			DELETE FROM cm_ReportToVolumeDiscountMap WHERE reportToVolumeDiscountMapId=@reportToVolumeDiscountMapId
			SET @errMsg='Successfully deleted the Partner - Contract association'
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		SET @retValue=ERROR_NUMBER()
		SET @errMsg=ERROR_MESSAGE()
	END CATCH
-- ----------------------------------------------------------------------------
--   CLEAN UP
-- ----------------------------------------------------------------------------
IF @retValue <> 0
	ROLLBACK TRANSACTION
ELSE
	COMMIT TRANSACTION
-- ----------------------------------------------------------------------------
--   Return back transaction details
-- ----------------------------------------------------------------------------
SELECT @retValue AS errorCode, @errMsg AS errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CM_AssociateClientGroupToContract')
	delete from GxQscripts where name = 'CM_AssociateClientGroupToContract'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_AssociateClientGroupToContract')
	delete from GXDBVersions where aliasname = 'CM_AssociateClientGroupToContract'
GO

insert into GXDBVersions values(2, 'CM_AssociateClientGroupToContract',  '00010001000200140000', 'CM_AssociateClientGroupToContract', '00010001000200140000')
GO

