

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_BillingHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_BillingHistory.sp,v $ $Id: CM_BillingHistory.sp,v 1.1.4.2 2018/05/23 07:43:05 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CM_BillingHistory <<<'

IF EXISTS (select * from sysobjects where name='CM_BillingHistory')
	drop procedure CM_BillingHistory
IF EXISTS (select * from GxQscripts where name='CM_BillingHistory')
	delete from GxQscripts where name = 'CM_BillingHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_BillingHistory')
	delete from GXDBVersions where aliasname = 'CM_BillingHistory'
GO
print '... Creating Procedure: CM_BillingHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CM_BillingHistory
  @userId INT = NULL,
  @groupId INT = 0,
  @date DATETIME = NULL,
  @aggregatorType INT = 0, --0-commcell group, 1-service provider, 2-partner
  @reportingFrequency INT = 5, --number of months of billing trends to be shown in graph
  @reportType INT = 0 --0-total cost tables, 1-total cost by skus, 2-total usage by skus
AS
SET NOCOUNT ON
DECLARE @retValue	INT = 0
DECLARE @errMsg		VARCHAR(256) = 'Procedure Completed Successfully'
BEGIN TRY
	--if end month is not inputted, draw graph ending in last month by default
	IF @date IS NULL OR @date = CONVERT(DATE,'1900-01-01')
	BEGIN
		SET @date = DATEADD(MONTH, -1, GETDATE())--previous month
		SET @date = DATEADD(MONTH, DATEDIFF(MONTH, 0, @date), 1)--2nd day of previous month
	END
	DECLARE @month DATETIME = CONVERT(VARCHAR(10),@date,101)--convert the above date to format MM/DD/YYYY
	DECLARE @requiredMinimum INT = 0, @discount INT = 0, @commCellGroupId INT = 0, @serviceProviderId INT = 0
	IF object_id('tempdb.dbo.#BillTotals') IS NOT NULL DROP TABLE #BillTotals
		CREATE TABLE #BillTotals(grpId INT,totalCost FLOAT,month DATE)
	IF object_id('tempdb.dbo.#SKUTotals') IS NOT NULL DROP TABLE #SKUTotals
		CREATE TABLE #SKUTotals(grpId INT,sku NVARCHAR(1024),countingType INT,skuUsage FLOAT,skuCost FLOAT,month DATE)
	IF object_id('tempdb.dbo.#PartnerBillTotals') IS NOT NULL DROP TABLE #PartnerBillTotals
		CREATE TABLE #PartnerBillTotals(grpId INT,totalCost FLOAT,month DATE)
	WHILE (@reportingFrequency > 0)
    BEGIN
		IF @aggregatorType=0--if graph is to be drawn at CommCell group level
		BEGIN
			EXEC CM_GenerateInvoice @userId, @groupId, @month, 0, 0, 0, 1
		END
		ELSE IF @aggregatorType=1
		BEGIN
			SET @commCellGroupId = 0
			DECLARE @CommCellGroupsCursor AS CURSOR;
			SET @CommCellGroupsCursor = CURSOR FAST_FORWARD FOR	SELECT commCellGroupId FROM cm_AggregatorAssoc WHERE aggregatorId=@groupId
			OPEN @CommCellGroupsCursor;
			FETCH NEXT FROM @CommCellGroupsCursor INTO @commCellGroupId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				EXEC CM_GenerateInvoice @userId, @commCellGroupId, @month, 0, 0, 0, 1
				--Now loop back to the next commcell group
				FETCH NEXT FROM @CommCellGroupsCursor INTO @commCellGroupId;
			END
			CLOSE @CommCellGroupsCursor;
			DEALLOCATE @CommCellGroupsCursor;
			SELECT @requiredMinimum=minimumFee FROM cm_AggregatorToContractMap WHERE aggregatorId=@groupId
		END
		ELSE IF @aggregatorType=2
		BEGIN
			SET @serviceProviderId = 0
			SET @requiredMinimum = 0
			DECLARE @ServiceProvidersCursor AS CURSOR;
			SET @ServiceProvidersCursor = CURSOR FAST_FORWARD FOR SELECT aggregatorId FROM cm_PartnerAssoc WHERE partnerId=@groupId
			OPEN @ServiceProvidersCursor;
			FETCH NEXT FROM @ServiceProvidersCursor INTO @serviceProviderId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @commCellGroupId = 0
				DECLARE @CommCellGrpsCursor AS CURSOR;
				SET @CommCellGroupsCursor = CURSOR FAST_FORWARD FOR	SELECT commCellGroupId FROM cm_AggregatorAssoc WHERE aggregatorId=@serviceProviderId
				OPEN @CommCellGroupsCursor;
				FETCH NEXT FROM @CommCellGroupsCursor INTO @commCellGroupId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					EXEC CM_GenerateInvoice @userId, @commCellGroupId, @month, 0, 0, 0, 1
					--Now loop back to the next commcell group
					FETCH NEXT FROM @CommCellGroupsCursor INTO @commCellGroupId;
				END
				CLOSE @CommCellGroupsCursor;
				DEALLOCATE @CommCellGroupsCursor;
				SELECT @requiredMinimum=minimumFee FROM cm_AggregatorToContractMap WHERE aggregatorId=@serviceProviderId
				INSERT #PartnerBillTotals
				SELECT @serviceProviderId, CASE WHEN @requiredMinimum > ROUND(SUM(totalCost),2) THEN @requiredMinimum ELSE ROUND(SUM(totalCost),2) END, month
				FROM #BillTotals GROUP BY month
				--clean this table before finding totals of next service provider
				DELETE FROM #BillTotals
				--Now loop back to the next service provider
				FETCH NEXT FROM @ServiceProvidersCursor INTO @serviceProviderId
			END
			CLOSE @ServiceProvidersCursor;
			DEALLOCATE @ServiceProvidersCursor;
			SELECT @discount=discountPercentage FROM cm_PartnerToContractMap WHERE partnerId=@groupId
		END
		SET @reportingFrequency = @reportingFrequency - 1 -- decrementing while loop counter
		SELECT @date=DATEADD(MONTH,-1,@date) --getting previous month billing
		SELECT @month=CONVERT(VARCHAR,@date,101) --convert the above date to format MM/DD/YYYY
	END
	IF @reportType=0--return table with total costs
	BEGIN
		IF @aggregatorType=2
		BEGIN
			SELECT ROUND(SUM(totalCost)-(SUM(totalCost)*@discount/100),2) AS 'Bill Amount', CONVERT(DATE,DATEADD(month, DATEDIFF(month, 0, month), 0)) AS 'Month', @discount AS 'Discount Percentage'
			FROM #PartnerBillTotals GROUP BY month
		END
		ELSE
		BEGIN
			SELECT CASE WHEN @requiredMinimum > ROUND(SUM(totalCost),2) THEN @requiredMinimum ELSE ROUND(SUM(totalCost),2) END AS 'Bill Amount', CONVERT(DATE,DATEADD(month, DATEDIFF(month, 0, month), 0)) AS 'Month', @requiredMinimum AS 'Minimum Fee'
			FROM #BillTotals GROUP BY month
		END
	END
	ELSE IF @reportType=1--return table with total cost by skus
	BEGIN
		--remove total rows
		DELETE FROM #SKUTotals WHERE sku='Total'
		SELECT SKU, ROUND(SUM(skuCost),2) AS 'Cost per SKU', CONVERT(DATE,DATEADD(month, DATEDIFF(month, 0, month), 0)) AS 'Month'
		FROM #SKUTotals
		GROUP BY SKU,month
	END
	ELSE IF @reportType=2--return table with total usage by capacity skus
	BEGIN
		--remove total rows
		DELETE FROM #SKUTotals WHERE sku='Total'
		SELECT SKU, countingType, ROUND(SUM(skuUsage),2) AS 'Usage per SKU', CONVERT(DATE,DATEADD(month, DATEDIFF(month, 0, month), 0)) AS 'Month'
		FROM #SKUTotals
		GROUP BY SKU,month,countingType
	END
	IF object_id('tempdb.dbo.#BillTotals') IS NOT NULL DROP TABLE #BillTotals
	IF object_id('tempdb.dbo.#SKUTotals') IS NOT NULL DROP TABLE #SKUTotals
	IF object_id('tempdb.dbo.#PartnerBillTotals') IS NOT NULL DROP TABLE #PartnerBillTotals
END TRY
BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
	SET @retValue=ERROR_NUMBER()
	SET @errMsg=ERROR_MESSAGE()
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CM_BillingHistory')
	delete from GxQscripts where name = 'CM_BillingHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_BillingHistory')
	delete from GXDBVersions where aliasname = 'CM_BillingHistory'
GO

insert into GXDBVersions values(2, 'CM_BillingHistory',  '00010001000400020000', 'CM_BillingHistory', '00010001000400020000')
GO

