

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Last7DaysClientBackupDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Last7DaysClientBackupDetails.sp,v $ $Id: Last7DaysClientBackupDetails.sp,v 1.1.2.1 2016/09/19 09:31:35 samrutkar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Last7DaysClientBackupDetails <<<'

IF EXISTS (select * from sysobjects where name='Last7DaysClientBackupDetails')
	drop procedure Last7DaysClientBackupDetails
IF EXISTS (select * from GxQscripts where name='Last7DaysClientBackupDetails')
	delete from GxQscripts where name = 'Last7DaysClientBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Last7DaysClientBackupDetails')
	delete from GXDBVersions where aliasname = 'Last7DaysClientBackupDetails'
GO
print '... Creating Procedure: Last7DaysClientBackupDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Last7DaysClientBackupDetails
  @i_UserId INT =-1,
  @i_GroupId INT =NULL,
  @i_CommServUniqueID INT = 0,
  @i_client NVARCHAR(max) = '',
  @i_Agent NVARCHAR(max) = '',
  @i_subclient NVARCHAR(max) = ''
AS
SET NOCOUNT ON
IF LEN(@i_client)=0 AND LEN(@i_Agent)=0 AND LEN(@i_subclient)=0
    RETURN
DECLARE @FromTime   INT
SET @FromTime =dbo.GetUnixTimeBig(GETDATE()-7)
DECLARE @ToTime     INT = 0x7FFFFFFF
DECLARE @i_QueryId BIGINT = 137
DECLARE @i_LatestSurvey INT = 1
SELECT
       CC.CommServName AS CommServName,
       SA.clientName AS Client,
       S.AgentName AS 'Agent',
       S.InstanceName AS 'Instance',
       S.SubclientName AS 'Subclient',
       DATEADD(second, StartDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
       DATEADD(second, EndDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
       CASE Status
                WHEN 0 THEN 'Running'
                WHEN 1 THEN 'Completed'
                WHEN 2 THEN 'Failed'
                WHEN 3 THEN 'Completed with errors'
                WHEN 4 THEN 'Killed'
                WHEN 5 THEN 'Suspended'
                WHEN 6 THEN 'Interrupted'
                WHEN 7 THEN 'Any Status'
                WHEN 8 THEN 'Skipped'
                WHEN 9 THEN 'Failed To Start'
                WHEN 10 THEN 'Synchronized'
                WHEN 11 THEN 'Not Synchronized'
                WHEN 12 THEN 'Not Attempted'
                WHEN 13 THEN 'Started'
                WHEN 14 THEN 'Completed with warnings'
                WHEN 15 THEN 'System Failed'
                WHEN 16 THEN 'Committed'
                ELSE 'Unknown'
       END AS 'Job Status',
       CONVERT(VARCHAR(20), DATEADD(SECOND, TransferTime, 0), 108) AS 'Transfer Time'
FROM
       cf_SurveyJobStats J WITH (NOLOCK)
	    INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
           ON resultView.CommservUniqueId = J.CommservUniqueId
			 AND ((J.EndDate BETWEEN @FromTime AND @ToTime) )
       INNER JOIN cf_SurveySubclients S WITH (NOLOCK)
            ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
            AND (S.ClientName LIKE @i_client OR LEN(@i_client)=0)
            AND (S.AgentName LIKE @i_Agent OR LEN(@i_Agent)=0)
            AND (S.SubclientName LIKE @i_subclient OR LEN(@i_subclient)=0)
       INNER JOIN cf_CommcellIdNameMap as CC WITH (NOLOCK)
            ON CC.ID = J.CommservUniqueId
              INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
              ON J.CommservUniqueId = SA.CommservUniqueId AND J.AppId = SA.AppId
			  ORDER BY CC.CommServName,SA.clientName,S.AgentName,S.InstanceName, S.SubclientName,StartDate, EndDate
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Last7DaysClientBackupDetails')
	delete from GxQscripts where name = 'Last7DaysClientBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Last7DaysClientBackupDetails')
	delete from GXDBVersions where aliasname = 'Last7DaysClientBackupDetails'
GO

insert into GXDBVersions values(2, 'Last7DaysClientBackupDetails',  '00010001000200010000', 'Last7DaysClientBackupDetails', '00010001000200010000')
GO

