

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ManageSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ManageSurvey.sp,v $ $Id: ManageSurvey.sp,v 1.2 2014/02/26 11:21:16 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ManageSurvey <<<'

IF EXISTS (select * from sysobjects where name='ManageSurvey')
	drop procedure ManageSurvey
IF EXISTS (select * from GxQscripts where name='ManageSurvey')
	delete from GxQscripts where name = 'ManageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ManageSurvey')
	delete from GXDBVersions where aliasname = 'ManageSurvey'
GO
print '... Creating Procedure: ManageSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ManageSurvey
  @Operation INTEGER = 0,
  @SurveyId INTEGER = 0,
  @Name nvarchar(200)	= '',
  @Description nvarchar(1024)	= '',
  @Details nvarchar(max)	= '',
  @DoneBy nvarchar(1024)	= '',
  @AssignedTo nvarchar(1024)	= '',
  @Status nvarchar(200)	= '',
  @CollectScript nvarchar(max)	= '',
  @CollectScriptName nvarchar(200)	= '',
  @CollectScriptURL nvarchar(1024)	= '',
  @CollectionEnabled INTEGER = 0,
  @ReportScriptName nvarchar(200)	= '',
  @ReportScript nvarchar(max)	= '',
  @ReportingEnabled INTEGER = 0 ,
  @flags INTEGER = 0 ,
  @ReportRetentionDays INTEGER =30
AS
BEGIN
SET NOCOUNT ON
DECLARE @tblFlag INTEGER = 0
IF @Operation = 1 --Add new
BEGIN
	DECLARE @QueryId INTEGER = -1
	SELECT @QueryId = ISNULL(MAX(QueryId), 1)+1 FROM cf_CommservSurveyQueries
	DECLARE @param_isPrivate INT = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	IF((@QueryId<10000)AND (@param_isPrivate = 1))
		SET @QueryId =10000
	INSERT INTO cf_CommservSurveyQueries(QueryId, Name, Description, Details, SubmittedBy, AssignedTo, LastUpdatedBy, ParserScriptName, Flags,DataRetentionDays)
		VALUES(@QueryId, @Name, @Description, @Details, @DoneBy, @AssignedTo, @DoneBy, 'RptSurveyResultsXML', @flags,@ReportRetentionDays )
END
ELSE IF @Operation = 2 --Update General Information
BEGIN
	IF (@SurveyId <= 1 OR LEN(@Name) <= 0 OR LEN(@Description) <= 0 OR LEN(@Details) <= 0 OR LEN(@DoneBy) <= 0 OR LEN(@AssignedTo) <= 0)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		Name = @Name,
		Description = @Description,
		Details = @Details,
		AssignedTo = @AssignedTo,
		LastUpdatedBy = @DoneBy,
		LastUpdatedTime = GETUTCDATE(),
		Flags = @flags , -- this will be allowed before review completed
		DataRetentionDays = @ReportRetentionDays
	WHERE QueryId = @SurveyId
END
ELSE IF @Operation = 3 --Update Collection Information
BEGIN
	IF (@SurveyId <= 1)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		Status = @Status,
		CollectScript = @CollectScript,
		--Flags = 3,
		CollectScriptName = @CollectScriptName,
		CollectScriptURL = @CollectScriptURL
	WHERE QueryId = @SurveyId
END
ELSE IF @Operation = 4 --Update Only Parser & Reporting Information
BEGIN
	IF (@SurveyId <= 1 )
		RETURN
	SELECT @tblFlag = Flags  FROM cf_CommservSurveyQueries WHERE QueryId = @SurveyId
	IF (LEN(@ReportScriptName) > 0 )
	BEGIN
	IF ((@tblFlag& 1)=0) -- TO UPDATE REPORTING SP ONLY
		SET @tblFlag = @tblFlag + 1
	UPDATE cf_CommservSurveyQueries SET
		ParserScriptName = @ReportScriptName,
		Flags = @tblFlag
	WHERE QueryId = @SurveyId
	END
	IF (LEN(@ReportScript) > 0 )
	BEGIN
	IF ((@tblFlag& 2)=0) -- TO UPDATE Parser SP ONLY
		SET @tblFlag = @tblFlag + 2
	UPDATE cf_CommservSurveyQueries SET
		ParserScript = @ReportScript,
		Flags = @tblFlag
	WHERE QueryId = @SurveyId
	END
END
ELSE IF @Operation = 5 --Change Survey Status
BEGIN
	IF (@SurveyId <= 1)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		Status = @Status,
		CollectScriptURL = @CollectScriptURL
	WHERE QueryId = @SurveyId
END
ELSE IF @Operation = 6 --Change Survey RetentionDays
BEGIN
	IF (@SurveyId <= 1)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		DataRetentionDays = @ReportRetentionDays
	WHERE QueryId = @SurveyId
END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'ManageSurvey')
	delete from GxQscripts where name = 'ManageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ManageSurvey')
	delete from GXDBVersions where aliasname = 'ManageSurvey'
GO

insert into GXDBVersions values(2, 'ManageSurvey',  '00010002000000000000', 'ManageSurvey', '00010002000000000000')
GO

