

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseArchiveGroupandCopyInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseArchiveGroupandCopyInfo.sp,v $ $Id: ParseArchiveGroupandCopyInfo.sp,v 1.5.60.6 2020/12/17 02:48:05 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseArchiveGroupandCopyInfo')
BEGIN
	print '>>> Drop Stored Procedure: ParseArchiveGroupandCopyInfo <<<'
	drop procedure ParseArchiveGroupandCopyInfo
END
IF EXISTS (select * from GxQscripts where name='ParseArchiveGroupandCopyInfo')
	delete from GxQscripts where name = 'ParseArchiveGroupandCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseArchiveGroupandCopyInfo')
	delete from GXDBVersions where aliasname = 'ParseArchiveGroupandCopyInfo'
GO
print '... Creating Procedure: ParseArchiveGroupandCopyInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseArchiveGroupandCopyInfo
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseArchiveGroupandCopyInfoTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyArchiveGroupInfo
	SELECT DISTINCT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@ID', 'int'),
		csInfo.n.value('@StoragePolicyName', 'nvarchar(256)'),
		csInfo.n.value('@NumberOfCopies', 'int'),
		csInfo.n.value('@NumberOfSnapCopies', 'int'),
		csInfo.n.value('@NumberofStreams', 'int'),
		csInfo.n.value('@StoragePolicytype', 'int'),
		csInfo.n.value('@StoragePolicyFlags', 'int'),
		csInfo.n.value('@IncrementalPolicyId', 'int'),
		csInfo.n.value('@SIBlockSizeKB', 'int'),
		csInfo.n.value('@AuxCopyAlertGB', 'int'),
		csInfo.n.value('@AuxCopyAlertDays', 'int'),
		csInfo.n.value('@TimeZoneType', 'int')
	FROM
		@ResultXml.nodes('/StoragePoliciesDetails/ArchiveGroupInfo') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyArchiveGroupCopyInfo
	SELECT DISTINCT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@ID', 'int'),
		csInfo.n.value('@CopyName', 'nvarchar(256)'),
		csInfo.n.value('@ArchGroupID', 'int'),
		csInfo.n.value('@IsSnapcopy', 'int'),
		csInfo.n.value('@Type', 'int'),
		csInfo.n.value('@MaxMultiplex', 'int'),
		csInfo.n.value('@Flags', 'int'),
		csInfo.n.value('@DedupeFlags', 'int'),
		csInfo.n.value('@ExtendedFlags', 'int'),
		csInfo.n.value('@WaitForIfOffline', 'int'),
		csInfo.n.value('@WaitForIfBusy', 'int'),
		csInfo.n.value('@SilosInCache', 'int'),
		csInfo.n.value('@DrivePoolType', 'int'),
		csInfo.n.value('@NewStorePeriodType', 'int'),
		csInfo.n.value('@NewStoreNumPeriod', 'int'),
		csInfo.n.value('@NewStoreSizeTB', 'int'),
		csInfo.n.value('@MaxCorruptPartitions', 'int'),
		csInfo.n.value('@SIDBStoreFlags', 'int'),
		csInfo.n.value('@DDBPartitions', 'int'),
		csInfo.n.value('@MRFlags', 'int'),
		csInfo.n.value('@MRDaysAfterWritten', 'int'),
		csInfo.n.value('@MRDaysBeforeAged', 'int'),
		csInfo.n.value('@MRPercentage', 'int'),
		csInfo.n.value('@RetentionDays', 'int'),
		csInfo.n.value('@RetentionCycles', 'int'),
		csInfo.n.value('@ArchiverRetentionDays', 'int'),
		csInfo.n.value('@RetentionJobs', 'int'),
		csInfo.n.value('@AgingFlags', 'int')
	FROM
		@ResultXml.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/ArchiveGroupCopy') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyExtendedRetention
	SELECT DISTINCT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@CopyID', 'int'),
		csInfo.n.value('@RetentionRule', 'int'),
		csInfo.n.value('@RetentionDays', 'int'),
		csInfo.n.value('@GraceDays', 'int')
	FROM
		@ResultXml.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/ExtendedRetention') AS csInfo(n)
	WHERE
		csInfo.n.value('@RetentionRule', 'int') > 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyBackupCopyInfo
	SELECT DISTINCT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@ArchGroupID', 'int'),
		csInfo.n.value('@Enabled', 'int'),
		csInfo.n.value('@Type', 'int'),
		csInfo.n.value('@Flags', 'int'),
		csInfo.n.value('@SourceCopyId', 'int'),
		csInfo.n.value('@DeferredDays', 'int'),
		csInfo.n.value('@NumberPeriod', 'int'),
		csInfo.n.value('@DayNumber', 'int')
	FROM
		@ResultXml.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/BackupCopyInfo') AS csInfo(n)
	WHERE
		csInfo.n.value('@Enabled', 'int') = 1
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyContentIndexing
	SELECT DISTINCT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@ArchGroupID', 'int'),
		csInfo.n.value('@Enabled', 'int'),
		csInfo.n.value('@Type', 'int'),
		csInfo.n.value('@Flags', 'int'),
		csInfo.n.value('@SubclientAssoc', 'int'),
		csInfo.n.value('@SourceCopyId', 'int'),
		csInfo.n.value('@DeferredDays', 'int'),
		csInfo.n.value('@RetentionDays', 'int'),
		csInfo.n.value('@NumberPeriod', 'int'),
		csInfo.n.value('@DayNumber', 'int'),
		csInfo.n.value('@MinDocSizeKB', 'int'),
		csInfo.n.value('@MaxDocSizeKB', 'int'),
		csInfo.n.value('@IncludeDocTypes', 'nvarchar(max)'),
		csInfo.n.value('@ExcludeDocTypes', 'nvarchar(max)'),
		csInfo.n.value('@EntityIds', 'nvarchar(max)'),
		csInfo.n.value('@FilterSelected', 'int')
	FROM
		@ResultXml.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/ContentIndexing') AS csInfo(n)
	WHERE
		csInfo.n.value('@Enabled', 'int') = 1
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseArchiveGroupandCopyInfoTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseArchiveGroupandCopyInfo')
	delete from GxQscripts where name = 'ParseArchiveGroupandCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseArchiveGroupandCopyInfo')
	delete from GXDBVersions where aliasname = 'ParseArchiveGroupandCopyInfo'
GO

insert into GXDBVersions values(2, 'ParseArchiveGroupandCopyInfo',  '00010005006000060000', 'ParseArchiveGroupandCopyInfo', '00010005006000060000')
GO

