

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBackupOffenders.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBackupOffenders.sp,v $ $Id: ParseBackupOffenders.sp,v 1.1.2.6 2020/12/17 02:53:38 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseBackupOffenders')
BEGIN
	print '>>> Drop Stored Procedure: ParseBackupOffenders <<<'
	drop procedure ParseBackupOffenders
END
IF EXISTS (select * from GxQscripts where name='ParseBackupOffenders')
	delete from GxQscripts where name = 'ParseBackupOffenders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBackupOffenders')
	delete from GXDBVersions where aliasname = 'ParseBackupOffenders'
GO
print '... Creating Procedure: ParseBackupOffenders'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseBackupOffenders
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseBackupOffendersTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #BackupOffenderClients (CommservUniqueId INT, Client INT, Subclient INT, Agent INT, JobCount INT, Status INT, CurrentMonth DATE, FailureReason NVARCHAR(MAX), ErrorCode NVARCHAR(1024))
DECLARE @CurrentMonth DATE
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #BackupOffenderClients (
		CommservUniqueId, Client, Subclient, Agent, JobCount, Status, CurrentMonth, FailureReason, ErrorCode)
	SELECT DISTINCT
		@CSUniqueId,
		csInfo.n.value('@Client', 'INT'),
		csInfo.n.value('@Subclient', 'INT'),
		csInfo.n.value('@Agent', 'INT'),
		csInfo.n.value('@JobCount', 'INT'),
		csInfo.n.value('@Status', 'INT'),
		csInfo.n.value('@Month', 'DATE'),
		csInfo.n.value('@FailureReason', 'NVARCHAR(MAX)'),
		csInfo.n.value('@ErrorCode', 'NVARCHAR(1024)')
	FROM
		@ResultXml.nodes('/BackupClientOffenders/BackupOffendersxml') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
	SET @CurrentMonth = (SELECT TOP 1 CurrentMonth FROM #BackupOffenderClients)
END
IF 	@ErrorCode = 0 AND @CurrentMonth IS NOT NULL
BEGIN
	DELETE cf_SurveyBackupOffenders WHERE CommServUniqueId = @CSUniqueId AND MonthStart = @CurrentMonth
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND @CurrentMonth IS NOT NULL
BEGIN
	INSERT	INTO cf_SurveyBackupOffenders (
			CommServUniqueId, Client, Subclient, Agent, JobCount, Status, MonthStart, FailureReason, ErrorCode)
	SELECT	CommServUniqueId, Client, Subclient, Agent, JobCount, Status, @CurrentMonth, FailureReason, ErrorCode
	FROM	#BackupOffenderClients
	SELECT @ErrorCode = @@ERROR
END
DROP TABLE #BackupOffenderClients
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseBackupOffendersTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBackupOffenders')
	delete from GxQscripts where name = 'ParseBackupOffenders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBackupOffenders')
	delete from GXDBVersions where aliasname = 'ParseBackupOffenders'
GO

insert into GXDBVersions values(2, 'ParseBackupOffenders',  '00010001000200060000', 'ParseBackupOffenders', '00010001000200060000')
GO

