

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCCRSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCCRSummary.sp,v $ $Id: ParseCCRSummary.sp,v 1.1.2.6 2018/12/27 18:55:53 vikashkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseCCRSummary')
BEGIN
	print '>>> Drop Stored Procedure: ParseCCRSummary <<<'
	drop procedure ParseCCRSummary
END
IF EXISTS (select * from GxQscripts where name='ParseCCRSummary')
	delete from GxQscripts where name = 'ParseCCRSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRSummary')
	delete from GXDBVersions where aliasname = 'ParseCCRSummary'
GO
print '... Creating Procedure: ParseCCRSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCCRSummary
  @CSUID INT,
  @UpdateTime DATETIME,
  @FullFileName VARCHAR(1024),
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
--   BULK INSERT from a csv file
-------------------------------------------------------------------------------
	SET NOCOUNT ON
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parsing CCRSummary'
	IF @isPrintOn = 1 PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	DECLARE @ProcessSurveyResultTran INT = 0
	IF OBJECT_ID('tempdb..#TempCCRSummary') IS NOT NULL DROP TABLE #TempCCRSummary
	CREATE TABLE #TempCCRSummary
	(
		Entity NVARCHAR(126),
		TotalCount int,
		OfflineCount int,
	)
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #TempCCRSummary FROM ''' + @FullFileName + ''' WITH (FIRSTROW = 2, FIELDTERMINATOR ='','', ROWTERMINATOR ='',\n'' )';
	BEGIN TRY
		EXEC(@sql);
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRSummary - BULK INSERT failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF @ErrorCode = 0
	BEGIN
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		DELETE FROM CCRSummary WHERE CommservUniqueId = @CSUID AND UpdateTime <= @UpdateTime
		IF EXISTS (SELECT * FROM #TempCCRSummary)
		BEGIN
			INSERT INTO CCRSummary (CommservUniqueId, UpdateTime, Entity, TotalCount, OfflineCount)
			SELECT	@CSUID, @UpdateTime, Entity, TotalCount, OfflineCount FROM #TempCCRSummary
		END
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			IF (@ProcessSurveyResultTran = 1)
			BEGIN
				ROLLBACK TRANSACTION ProcessSurveyResultTran
				SET @ProcessSurveyResultTran = 0
			END
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRSummary - INSERT INTO CCRSummary failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		IF @isPrintOn = 1 PRINT @ErrorString
			INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END
	DROP TABLE #TempCCRSummary
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCCRSummary')
	delete from GxQscripts where name = 'ParseCCRSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRSummary')
	delete from GXDBVersions where aliasname = 'ParseCCRSummary'
GO

insert into GXDBVersions values(2, 'ParseCCRSummary',  '00010001000200060000', 'ParseCCRSummary', '00010001000200060000')
GO

