

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCapacityLicenseSurvey.sp,v $ $Id: ParseCapacityLicenseSurvey.sp,v 1.4.12.14 2020/12/17 02:54:47 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCapacityLicenseSurvey')
BEGIN
	print '>>> Drop Stored Procedure: ParseCapacityLicenseSurvey <<<'
	drop procedure ParseCapacityLicenseSurvey
END
IF EXISTS (select * from GxQscripts where name='ParseCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseCapacityLicenseSurvey'
GO
print '... Creating Procedure: ParseCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCapacityLicenseSurvey
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCapacityLicenseSurveyTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @MonthStart DATETIME = DATEADD(MONTH, DATEDIFF(MONTH, 0, @LogDate), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCapacityLicenseUsage (
		SurveyResultId,
		TotalProtectedVMs, ProtectedVMs,
		TotalArchivedMailBoxes, ArchivedMailBoxes,
		TotalCIObjectsInMillion, CIObjects,
		TotalVMSockets, VMSockets,
		TotalEndpointUsers, EndpointUsers,
		TotalSharingUsers, SharingUsers,
		TotaleDiscoveryUsers, eDiscoveryUsers,
		TotalDiskSpaceMB, UsedDiskSpaceMB,
		TotalStoreSpaceMB, DedupDataSizeMB,
		TotalBackupSize, BackupSize,
		TotalArchiveSize, ArchiveSize,
		TotalSnapshotSize, SnapshotSize,
		TotalReplicationSize, ReplicationSize,
		EvalBackupSizeMB, EvalBackupExpiry,
		EvalArchiveSizeMB, EvalArchiveExpiry,
		EvalSnapshotSizeMB, EvalSnapshotExpiry,
		EvalReplicationSizeMB, EvalReplicationExpiry,
		TotalArchivedVMs, ArchivedVMs,
		TotalAppClassVMs, AppClassVMs,
		TotalMBArchivedUsers, MBArchivedUsers,
		TotalAppStoreSpaceMB, AppStoreSpaceMB
		)
	SELECT
		@ResultId,
		csInfo.n.value('SubscriptionUsageTotal[1]/@nProtectedVM','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@nProtectedVM','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@nArchivedMailBox','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@nArchivedMailBox','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@CIObjectsInMillion','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@CIObjects','BIGINT'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@VMSockets','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@VMSockets','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@EndpointUsers','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@EndpointUsers','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@SharingUsers','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@SharingUsers','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@eDiscoveryUsers','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@eDiscoveryUsers','INTEGER'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@DiskLibSpaceMB','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@DiskLibSpaceMB','BIGINT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@UsedDiskSpaceMB','BIGINT'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@DedupStoreSpaceMB','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@DedupStoreSpaceMB','BIGINT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@DedupDataSizeMB','BIGINT'),
		ISNULL(csInfo.n.value('LicenseUsageTotal[1]/@EnterpriseBackupSize','BIGINT'), 0) + ISNULL(csInfo.n.value('LicenseUsageTotal[1]/@CoreBackupSize','BIGINT'), 0),
		ISNULL(csInfo.n.value('LicenseUsageUsed[1]/@EnterpriseBackupSize','BIGINT'), 0)  + ISNULL(csInfo.n.value('LicenseUsageUsed[1]/@CoreBackupSize','BIGINT'), 0),
		ISNULL(csInfo.n.value('LicenseUsageTotal[1]/@EnterpriseArchiveSize','BIGINT'), 0)+ ISNULL(csInfo.n.value('LicenseUsageTotal[1]/@CoreArchiveSize','BIGINT'), 0),
		ISNULL(csInfo.n.value('LicenseUsageUsed[1]/@EnterpriseArchiveSize','BIGINT'), 0) + ISNULL(csInfo.n.value('LicenseUsageUsed[1]/@CoreArchiveSize','BIGINT'), 0),
		csInfo.n.value('LicenseUsageTotal[1]/@SnapshotSize','BIGINT'),
		csInfo.n.value('LicenseUsageUsed[1]/@SnapshotSize','BIGINT'),
		csInfo.n.value('LicenseUsageTotal[1]/@ReplicationSize','BIGINT'),
		csInfo.n.value('LicenseUsageUsed[1]/@ReplicationSize','BIGINT'),
		csInfo.n.value('LicenseUsageEval[1]/@BackupSizeMB','BIGINT'),
		csInfo.n.value('LicenseUsageEval[1]/@BackupExpiry','DATETIME'),
		csInfo.n.value('LicenseUsageEval[1]/@ArchiveSizeMB','BIGINT'),
		csInfo.n.value('LicenseUsageEval[1]/@ArchiveExpiry','DATETIME'),
		csInfo.n.value('LicenseUsageEval[1]/@SnapshotSizeMB','BIGINT'),
		csInfo.n.value('LicenseUsageEval[1]/@SnapshotExpiry','DATETIME'),
		csInfo.n.value('LicenseUsageEval[1]/@ReplicationSizeMB','BIGINT'),
		csInfo.n.value('LicenseUsageEval[1]/@ReplicationExpiry','DATETIME'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@nArchivedVM','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@nArchivedVM','INT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@nArchivedVM','INTEGER'),
 		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@VMWithACV','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@VMWithACV','INT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@VMWithACV','INTEGER'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@MSimUsers','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@MSimUsers','INT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@MSimUsers','INTEGER'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@AppStoreSpaceMB','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@AppStoreSpaceMB','BIGINT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@AppStoreSpaceMB','BIGINT')
	FROM
		@ResultXml.nodes('/CapacityLicenseUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyCapacityLicensePeakUsage
	SET	ProtectedVMs		= CASE WHEN ISNULL(U.ProtectedVMs,0) > ISNULL(P.ProtectedVMs,0) THEN U.ProtectedVMs ELSE P.ProtectedVMs END,
		ArchivedMailBoxes	= CASE WHEN ISNULL(U.ArchivedMailBoxes,0) > ISNULL(P.ArchivedMailBoxes,0) THEN U.ArchivedMailBoxes ELSE P.ArchivedMailBoxes END,
		CIObjects			= CASE WHEN ISNULL(U.CIObjects,0) > ISNULL(P.CIObjects,0) THEN U.CIObjects ELSE P.CIObjects END,
		VMSockets			= CASE WHEN ISNULL(U.VMSockets,0) > ISNULL(P.VMSockets,0) THEN U.VMSockets ELSE P.VMSockets END,
		EndpointUsers		= CASE WHEN ISNULL(U.EndpointUsers,0) > ISNULL(P.EndpointUsers,0) THEN U.EndpointUsers ELSE P.EndpointUsers END,
		SharingUsers		= CASE WHEN ISNULL(U.SharingUsers,0) > ISNULL(P.SharingUsers,0) THEN U.SharingUsers ELSE P.SharingUsers END,
		eDiscoveryUsers		= CASE WHEN ISNULL(U.eDiscoveryUsers,0) > ISNULL(P.eDiscoveryUsers,0) THEN U.eDiscoveryUsers ELSE P.eDiscoveryUsers END,
		UsedDiskSpaceMB		= CASE WHEN ISNULL(U.UsedDiskSpaceMB,0) > ISNULL(P.UsedDiskSpaceMB,0) THEN U.UsedDiskSpaceMB ELSE P.UsedDiskSpaceMB END,
		DedupDataSizeMB		= CASE WHEN ISNULL(U.DedupDataSizeMB,0) > ISNULL(P.DedupDataSizeMB,0) THEN U.DedupDataSizeMB ELSE P.DedupDataSizeMB END,
/*		BackupSize			= CASE WHEN ISNULL(U.BackupSize,0) > ISNULL(P.BackupSize,0) THEN U.BackupSize ELSE P.BackupSize END,
		ArchiveSize			= CASE WHEN ISNULL(U.ArchiveSize,0) > ISNULL(P.ArchiveSize,0) THEN U.ArchiveSize ELSE P.ArchiveSize END,
		SnapshotSize		= CASE WHEN ISNULL(U.SnapshotSize,0) > ISNULL(P.SnapshotSize,0) THEN U.SnapshotSize ELSE P.SnapshotSize END,
		ReplicationSize		= CASE WHEN ISNULL(U.ReplicationSize,0) > ISNULL(P.ReplicationSize,0) THEN U.ReplicationSize ELSE P.ReplicationSize END*/
		ArchivedVMs			= CASE WHEN ISNULL(U.ArchivedVMs,0) > ISNULL(P.ArchivedVMs,0) THEN U.ArchivedVMs ELSE P.ArchivedVMs END,
		AppClassVMs			= CASE WHEN ISNULL(U.AppClassVMs,0) > ISNULL(P.AppClassVMs,0) THEN U.AppClassVMs ELSE P.AppClassVMs END,
		MBArchivedUsers		= CASE WHEN ISNULL(U.MBArchivedUsers,0) > ISNULL(P.MBArchivedUsers,0) THEN U.MBArchivedUsers ELSE P.MBArchivedUsers END,
		AppStoreSpaceMB		= CASE WHEN ISNULL(U.AppStoreSpaceMB,0) > ISNULL(P.AppStoreSpaceMB,0) THEN U.AppStoreSpaceMB ELSE P.AppStoreSpaceMB END
	FROM
		cf_SurveyCapacityLicenseUsage U
		INNER JOIN cf_SurveyCapacityLicensePeakUsage P ON U.SurveyResultId = @ResultId AND P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart
	IF  NOT EXISTS (SELECT CommServUniqueId FROM cf_SurveyCapacityLicensePeakUsage WHERE CommServUniqueId = @CSUniqueId AND MonthStart = @MonthStart)
		INSERT INTO cf_SurveyCapacityLicensePeakUsage (
			CommServUniqueId, MonthStart, ProtectedVMs, ArchivedMailBoxes,
			CIObjects, VMSockets, EndpointUsers, SharingUsers, eDiscoveryUsers,
			UsedDiskSpaceMB, DedupDataSizeMB, BackupSize, ArchiveSize, SnapshotSize, ReplicationSize,
			ArchivedVMs, AppClassVMs, MBArchivedUsers, AppStoreSpaceMB
			)
		SELECT
			@CSUniqueId, @MonthStart, ProtectedVMs, ArchivedMailBoxes,
			CIObjects, VMSockets, EndpointUsers, SharingUsers, eDiscoveryUsers,
			UsedDiskSpaceMB, DedupDataSizeMB, BackupSize, ArchiveSize, SnapshotSize, ReplicationSize,
			ArchivedVMs, AppClassVMs, MBArchivedUsers, AppStoreSpaceMB
		FROM
			cf_SurveyCapacityLicenseUsage
		WHERE
			SurveyResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCapacityLicenseSurveyTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'ParseCapacityLicenseSurvey',  '00010004001200140000', 'ParseCapacityLicenseSurvey', '00010004001200140000')
GO

