

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCleanupSecurity.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCleanupSecurity.sp,v $ $Id: ParseCleanupSecurity.sp,v 1.1.2.10 2020/12/17 02:53:23 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCleanupSecurity')
BEGIN
	print '>>> Drop Stored Procedure: ParseCleanupSecurity <<<'
	drop procedure ParseCleanupSecurity
END
IF EXISTS (select * from GxQscripts where name='ParseCleanupSecurity')
	delete from GxQscripts where name = 'ParseCleanupSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCleanupSecurity')
	delete from GXDBVersions where aliasname = 'ParseCleanupSecurity'
GO
print '... Creating Procedure: ParseCleanupSecurity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCleanupSecurity
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCleanupSecurityTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @NewQuery INT --Used to identify data weather collected using new query or not. 1 is used for new collection
SET @NewQuery = (select ISNULL(csInfo.n.value('@flag','INT'),0) from @ResultXml.nodes('/SecurityCleanup') AS csInfo(n))
IF (@NewQuery = 0)
BEGIN
IF OBJECT_ID('tempdb.#tempSurveyAlertAndSecurityCleanup') IS NOT NULL DROP TABLE #tempSurveyAlertAndSecurityCleanup
CREATE TABLE #tempSurveyAlertAndSecurityCleanup(CommservUniqueId INT, ResultId BIGINT,QueryID INT, Query XML)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #tempSurveyAlertAndSecurityCleanup
    SELECT
		@CSUniqueId,
		@ResultId,
		csInfo.n.value('@QueryId', 'INT'),
		csInfo.n.value('@Query', 'NVARCHAR(MAX)')
	FROM
        @ResultXml.nodes('/SecurityCleanup/SecurityCleanupXML') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUserNotLoggedIn
	select
        @ResultId,
		csInfo.n.value('@Id','INT') ,
		csInfo.n.value('@UserName','NVARCHAR(MAX)'),
		csInfo.n.value('@lastLogInTime','datetime')
	from #tempSurveyAlertAndSecurityCleanup T
		CROSS APPLY Query .nodes('UserNotLoggedInDetails/UserNotLoggedIn') AS csInfo(n)
	where
		T.QueryId = 1 AND T.CommservUniqueId = @CSUniqueId AND T.ResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCleanupUserGroup
	select
        @ResultId,
        csInfo.n.value('@UserGroupId','INT') ,
		ISNULL(csInfo.n.value('@UserGroupName','NVARCHAR(MAX)'),''),
		csInfo.n.value('@Flags','INT')
	from #tempSurveyAlertAndSecurityCleanup T
		CROSS APPLY Query .nodes('UserGroupWithoutAssocUser/UserGroupWithoutUser') AS csInfo(n)
	where
		T.QueryId = 2  AND T.CommservUniqueId = @CSUniqueId AND  T.ResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAlertsWithoutUsers
	select
        @ResultId,
        csInfo.n.value('@AlertId','INT') ,
	    csInfo.n.value('@AlertName','NVARCHAR(MAX)')
	from #tempSurveyAlertAndSecurityCleanup T
		CROSS APPLY Query .nodes('AlertsWithoutUserDetails/AlertsWithoutUser') AS csInfo(n)
	where
		T.QueryId = 3 AND T.CommservUniqueId = @CSUniqueId AND  T.ResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
	END
END
ELSE
IF (@NewQuery = 1)
BEGIN
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyUserNotLoggedIn
		select
			@ResultId,
			csInfo.n.value('@Id','INT') ,
			csInfo.n.value('@UserName','NVARCHAR(MAX)'),
			csInfo.n.value('@lastLogInTime','datetime')
		from
			@ResultXml.nodes('/SecurityCleanup/UserNotLoggedInDetails/UserNotLoggedIn') AS csInfo(n)
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyCleanupUserGroup
		select
			@ResultId,
			csInfo.n.value('@UserGroupId','INT') ,
			ISNULL(csInfo.n.value('@UserGroupName','NVARCHAR(MAX)'),''),
			csInfo.n.value('@Flags','INT')
		from
			@ResultXml.nodes('/SecurityCleanup/UserGroupWithoutAssocUser/UserGroupWithoutUser') AS csInfo(n)
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyAlertsWithoutUsers
		select
			@ResultId,
			csInfo.n.value('@AlertId','INT') ,
			csInfo.n.value('@AlertName','NVARCHAR(MAX)')
		from
			@ResultXml.nodes('/SecurityCleanup/AlertsWithoutUserDetails/AlertsWithoutUser') AS csInfo(n)
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCleanupSecurityTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCleanupSecurity')
	delete from GxQscripts where name = 'ParseCleanupSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCleanupSecurity')
	delete from GXDBVersions where aliasname = 'ParseCleanupSecurity'
GO

insert into GXDBVersions values(2, 'ParseCleanupSecurity',  '00010001000200100000', 'ParseCleanupSecurity', '00010001000200100000')
GO

