

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClients.sp,v $ $Id: ParseClients.sp,v 1.1.2.12.4.1 2021/02/04 05:49:11 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseClients')
BEGIN
	print '>>> Drop Stored Procedure: ParseClients <<<'
	drop procedure ParseClients
END
IF EXISTS (select * from GxQscripts where name='ParseClients')
	delete from GxQscripts where name = 'ParseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClients')
	delete from GXDBVersions where aliasname = 'ParseClients'
GO
print '... Creating Procedure: ParseClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseClients
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseClientTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
CREATE TABLE #SurveyClient
(
    ClientId					INT NOT NULL,
	ClientName					NVARCHAR (MAX) NULL,
    PhysicalClientName  		NVARCHAR (MAX) NULL,
    OperatingSystem				NVARCHAR (MAX) NULL,
Timezone					VARCHAR  (255) NULL,
    Type						INT NULL,
    InstallStatus				INT NULL,
    InstallDate					DATETIME NULL,
	UninstallTime				DATETIME NULL,
ServicePack					NVARCHAR (255) NULL,
    StoragePolicy				NVARCHAR (MAX) NULL,
    LatestDataProtection		DATETIME NULL,
	ClientHostName				NVARCHAR (MAX) NULL,
	ClientDisplayName			NVARCHAR (MAX) NULL,
	Latitude					DECIMAL(16,13) NULL,
	Longitude					DECIMAL(16,13) NULL,
	CountryCode					NVARCHAR(3) NOT NULL DEFAULT '',
	ExceptionType				INT NULL,
	LastOnlineTime				DATETIME NULL,
	LastOfflineTime				DATETIME NULL
)
DECLARE @FileName NVARCHAR(1024)
DECLARE @sql      NVARCHAR(2000)
IF 	@ErrorCode = 0
BEGIN
	SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
	FROM	cf_CommservSurveyResults WITH (NOLOCK)
	WHERE 	CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	BEGIN TRY
		SET @sql = 'BULK INSERT #SurveyClient FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
	END TRY
	BEGIN CATCH
		ALTER TABLE #SurveyClient
		DROP COLUMN LastOnlineTime, LastOfflineTime
		--Adding UPNumber and UPFriendlyName columns as the backlog data would have data for these columns
		ALTER TABLE #SurveyClient
		ADD UPNumber INT NULL, UPFriendlyName NVARCHAR(512) NULL
		SET @sql = 'BULK INSERT #SurveyClient FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		ALTER TABLE #SurveyClient
		DROP COLUMN UPNumber, UPFriendlyName
		ALTER TABLE #SurveyClient
		ADD LastOnlineTime DATETIME NULL, LastOfflineTime DATETIME NULL
	END CATCH
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE #SurveyClient
	SET		ClientId = -ClientId,
			ClientName			= REPLACE(ClientName, '<COMMA>', ','),
			PhysicalClientName	= REPLACE(PhysicalClientName, '<COMMA>', ','),
			OperatingSystem		= REPLACE(OperatingSystem, '<COMMA>', ','),
			StoragePolicy		= REPLACE(StoragePolicy, '<COMMA>', ','),
			ClientHostName		= REPLACE(ClientHostName, '<COMMA>', ','),
			ClientDisplayName	= REPLACE(ClientDisplayName, '<COMMA>', ',')
	WHERE	ClientId < 0
	SELECT @ErrorCode = @@ERROR
END
ALTER TABLE #SurveyClient Add clientGroups NVARCHAR(MAX) null
IF @ErrorCode = 0 AND EXISTS (SELECT TOP 1 1 FROM #SurveyClient)
BEGIN
	UPDATE T SET T.clientGroups = C.clientGroups
	FROM #SurveyClient T
		INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON C.CommServUniqueId = @CSUniqueId AND T.ClientId = C.ClientId AND C.ClientGroups is not NULL
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT TOP 1 1 FROM #SurveyClient WHERE Type&256 > 0 AND CountryCode = '')
BEGIN
	UPDATE T SET Latitude = C.latitude, Longitude = C.longitude, CountryCode = C.CountryCode
	FROM	#SurveyClient T
			INNER JOIN (
				SELECT	ClientId, Latitude, Longitude, CountryCode
				FROM	cf_SurveyClient WITH (NOLOCK)
				WHERE	CommServUniqueId = @CSUniqueId AND Type&256 > 0 AND CountryCode <> ''
			) C ON T.ClientId = C.ClientId AND T.CountryCode = ''
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE C FROM cf_SurveyClient C INNER JOIN #SurveyClient T ON C.CommServUniqueId = @CSUniqueId AND C.ClientId = T.clientId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyClient SET Deleted = 1 WHERE CommServUniqueId = @CSUniqueId AND Deleted = 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyClient (
		CommServUniqueId, ClientId, ClientName, PhysicalClientName, OperatingSystem, Timezone, Type,
		InstallStatus, Installdate, UninstallTime, ServicePack, StoragePolicy, LatestDataProtection, Deleted,
		ClientHostName, ClientDisplayName, Latitude, Longitude, CountryCode, ExceptionType, LastOnlineTime, LastOfflineTime, clientGroups)
	SELECT
		@CSUniqueId, ClientId, ClientName, PhysicalClientName, OperatingSystem, Timezone, Type,
		InstallStatus, CASE WHEN Installdate = '1970-01-01' THEN NULL ELSE Installdate END, CASE WHEN UninstallTime = '1970-01-01' THEN NULL ELSE UninstallTime END,
		ServicePack, StoragePolicy, CASE WHEN LatestDataProtection = '1970-01-01' THEN NULL ELSE LatestDataProtection END, 0,
		ClientHostName, ClientDisplayName, Latitude, Longitude, CountryCode, ExceptionType, CASE WHEN LastOnlineTime = '1970-01-01' THEN NULL ELSE LastOnlineTime END,
			CASE WHEN LastOfflineTime = '1970-01-01' THEN NULL ELSE LastOfflineTime END, clientGroups
	FROM #SurveyClient
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseClientsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClients')
	delete from GxQscripts where name = 'ParseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClients')
	delete from GXDBVersions where aliasname = 'ParseClients'
GO

insert into GXDBVersions values(2, 'ParseClients',  'v1.1.2.12.4.1', 'ParseClients', 'v1.1.2.12.4.1')
GO

