

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCommcellThresholdInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCommcellThresholdInfo.sp,v $ $Id: ParseCommcellThresholdInfo.sp,v 1.1.2.8 2020/12/17 02:55:23 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCommcellThresholdInfo')
BEGIN
	print '>>> Drop Stored Procedure: ParseCommcellThresholdInfo <<<'
	drop procedure ParseCommcellThresholdInfo
END
IF EXISTS (select * from GxQscripts where name='ParseCommcellThresholdInfo')
	delete from GxQscripts where name = 'ParseCommcellThresholdInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommcellThresholdInfo')
	delete from GXDBVersions where aliasname = 'ParseCommcellThresholdInfo'
GO
print '... Creating Procedure: ParseCommcellThresholdInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCommcellThresholdInfo
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCommcellThresholdInfoTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF object_id('tempdb.dbo.#SurveyThresholdInfo') is not null DROP TABLE #SurveyThresholdInfo
CREATE TABLE #SurveyThresholdInfo (
	CommservUniqueId INT, entityId INT, entityName NVARCHAR(1024), attrName NVARCHAR(1024), attrType INT, attrVal NVARCHAR(1024)	)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyThresholdInfo (
		CommservUniqueId, entityId, entityName, attrName, attrType, attrVal)
	SELECT DISTINCT
		@CSUniqueId,
		csInfo.n.value('@entityId', 'INT'),
		csInfo.n.value('@entityName', 'NVARCHAR(1024)'),
		csInfo.n.value('@attrName', 'NVARCHAR(1024)'),
		csInfo.n.value('@attrType', 'INT'),
		csInfo.n.value('@attrVal', 'NVARCHAR(1024)')
	FROM
		@ResultXml.nodes('/CommcellThresholdInfoXML/CommcellThresholdInfo') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE  T
	FROM	#SurveyThresholdInfo T
			INNER JOIN cf_SurveyCommcellThresholdInfo S
			ON T.CommservUniqueId = S.CommservUniqueId AND T.entityId = S.entityId AND T.attrName = S.attrName
	WHERE	T.entityName = S.entityName AND T.attrType = S.attrType AND T.attrVal = S.attrVal
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	cf_SurveyCommcellThresholdInfo
	SET		entityName = B.entityName,  attrType = B.attrType,
			attrVal = B.attrVal
	FROM	cf_SurveyCommcellThresholdInfo A
			INNER JOIN #SurveyThresholdInfo B
			ON A.CommservUniqueId = B.CommservUniqueId AND A.entityId = B.entityId AND A.attrName = B.attrName
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE  #SurveyThresholdInfo
	FROM	cf_SurveyCommcellThresholdInfo S
	WHERE	#SurveyThresholdInfo.CommservUniqueId = S.CommservUniqueId AND #SurveyThresholdInfo.entityId = S.entityId AND #SurveyThresholdInfo.attrName = S.attrName
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCommcellThresholdInfo (
			CommservUniqueId, entityId, entityName, attrName, attrType, attrVal)
	SELECT	CommservUniqueId, entityId, entityName, attrName, attrType, attrVal
	FROM	#SurveyThresholdInfo
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCommcellThresholdInfoTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCommcellThresholdInfo')
	delete from GxQscripts where name = 'ParseCommcellThresholdInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommcellThresholdInfo')
	delete from GXDBVersions where aliasname = 'ParseCommcellThresholdInfo'
GO

insert into GXDBVersions values(2, 'ParseCommcellThresholdInfo',  '00010001000200080000', 'ParseCommcellThresholdInfo', '00010001000200080000')
GO

