

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDedupeSavingTrend.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDedupeSavingTrend.sp,v $ $Id: ParseDedupeSavingTrend.sp,v 1.1.2.6 2020/12/17 02:52:32 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDedupeSavingTrend')
BEGIN
	print '>>> Drop Stored Procedure: ParseDedupeSavingTrend <<<'
	drop procedure ParseDedupeSavingTrend
END
IF EXISTS (select * from GxQscripts where name='ParseDedupeSavingTrend')
	delete from GxQscripts where name = 'ParseDedupeSavingTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDedupeSavingTrend')
	delete from GXDBVersions where aliasname = 'ParseDedupeSavingTrend'
GO
print '... Creating Procedure: ParseDedupeSavingTrend'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDedupeSavingTrend
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDedupeSavingTrendTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#tmpDedupedBackupSize') IS NOT null DROP TABLE #tmpDedupedBackupSize
CREATE TABLE #tmpDedupedBackupSize
(
	CommServUniqueId		INT,
	RangeBegin				DATETIME,
	AppId					INT,
	IsFullBackup 			INT,
	PrimaryCopyId 			INT,
	BackupSize				BIGINT,
	DataWritten				BIGINT
)
IF object_id('tempdb.dbo.#tmpMonthlyDedupeSaving') IS NOT null DROP TABLE #tmpMonthlyDedupeSaving
CREATE TABLE #tmpMonthlyDedupeSaving
(
	CommServUniqueId		INT,
	MonthStart				DATETIME,
	AppId					INT,
	IsFullBackup 			INT,
	PrimaryCopyId 			INT,
	BackupSize				BIGINT,
	DataWritten				BIGINT
)
DECLARE @LastDate DATETIME
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #tmpDedupedBackupSize
	SELECT
		CommcellIdNameMap_ID,
		csInfo.n.value('@RangeBegin', 'DATE'),
		csInfo.n.value('@AppId', 'INT'),
		csInfo.n.value('@IsFullBackup', 'INT'),
		csInfo.n.value('@PrimaryCopyId', 'INT'),
		csInfo.n.value('@BackupSize', 'BIGINT'),
		csInfo.n.value('@DataWritten', 'BIGINT')
	FROM
		cf_CommservSurveyResults
		CROSS APPLY CollectedResults.nodes('/DedupedBackupSize') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	SET @LastDate = (SELECT MAX(JobEndDate) FROM cf_SurveyDailyDedupeSaving WHERE CommServUniqueId = @CSUniqueId)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	#tmpDedupedBackupSize WHERE RangeBegin < @LastDate
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	#tmpDedupedBackupSize
	SET		BackupSize -= S.BackupSize, DataWritten -= S.DataWritten
	FROM	#tmpDedupedBackupSize T INNER JOIN cf_SurveyDailyDedupeSaving S
		ON  T.CommServUniqueId = S. CommServUniqueId AND T.RangeBegin = S.JobEndDate AND T.AppId = S.AppId
			AND T.IsFullBackup = S.IsFullBackup AND T.PrimaryCopyId = S.PrimaryCopyId
	WHERE	T.RangeBegin = @LastDate
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE	cf_SurveyDailyDedupeSaving S
	USING	#tmpDedupedBackupSize T
		 ON T.CommServUniqueId = S. CommServUniqueId AND T.RangeBegin = S.JobEndDate AND T.AppId = S.AppId
			AND T.IsFullBackup = S.IsFullBackup AND T.PrimaryCopyId = S.PrimaryCopyId
	WHEN MATCHED THEN
		UPDATE SET BackupSize += T.BackupSize, DataWritten += T.DataWritten
	WHEN NOT MATCHED THEN
		INSERT (CommServUniqueId, JobEndDate, AppId, IsFullBackup, PrimaryCopyId, BackupSize, DataWritten)
		VALUES (T.CommServUniqueId, T.RangeBegin, T.AppId, T.IsFullBackup, T.PrimaryCopyId, T.BackupSize, T.DataWritten);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #tmpMonthlyDedupeSaving
	SELECT	CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, RangeBegin), 0), AppId, IsFullBackup, PrimaryCopyId, SUM(BackupSize), SUM(DataWritten)
	FROM	#tmpDedupedBackupSize
	GROUP BY CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, RangeBegin), 0), AppId, IsFullBackup, PrimaryCopyId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE	cf_SurveyMonthlyDedupeSaving S
	USING	#tmpMonthlyDedupeSaving T
		 ON T.CommServUniqueId = S. CommServUniqueId AND T.MonthStart = S.MonthStart AND T.AppId = S.AppId
			AND T.IsFullBackup = S.IsFullBackup AND T.PrimaryCopyId = S.PrimaryCopyId
	WHEN MATCHED THEN
		UPDATE SET BackupSize += T.BackupSize, DataWritten += T.DataWritten
	WHEN NOT MATCHED THEN
		INSERT (CommServUniqueId, MonthStart, AppId, IsFullBackup, PrimaryCopyId, BackupSize, DataWritten)
		VALUES (T.CommServUniqueId, T.MonthStart, T.AppId, T.IsFullBackup, T.PrimaryCopyId, T.BackupSize, T.DataWritten);
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDedupeSavingTrendTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDedupeSavingTrend')
	delete from GxQscripts where name = 'ParseDedupeSavingTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDedupeSavingTrend')
	delete from GXDBVersions where aliasname = 'ParseDedupeSavingTrend'
GO

insert into GXDBVersions values(2, 'ParseDedupeSavingTrend',  '00010001000200060000', 'ParseDedupeSavingTrend', '00010001000200060000')
GO

