

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseHardwareEncryption.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseHardwareEncryption.sp,v $ $Id: ParseHardwareEncryption.sp,v 1.1.4.8 2020/12/17 02:47:14 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseHardwareEncryption')
BEGIN
	print '>>> Drop Stored Procedure: ParseHardwareEncryption <<<'
	drop procedure ParseHardwareEncryption
END
IF EXISTS (select * from GxQscripts where name='ParseHardwareEncryption')
	delete from GxQscripts where name = 'ParseHardwareEncryption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseHardwareEncryption')
	delete from GXDBVersions where aliasname = 'ParseHardwareEncryption'
GO
print '... Creating Procedure: ParseHardwareEncryption'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseHardwareEncryption
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseHardwareEncryptionTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyHardwareEncryption (SurveyResultId,
		PolicyId, PolicyName, CopyId, CopyName, MediaAgentId, MediaAgentName, LibraryId, LibraryName, UseHwEncryption)
	SELECT
		@ResultId,
		csInfo.n.value('@PolicyId', 'INT'),
		csInfo.n.value('@PolicyName', 'NVARCHAR(144)'),
		csInfo.n.value('@CopyId', 'INT'),
		csInfo.n.value('@CopyName', 'NVARCHAR(64)'),
		csInfo.n.value('@MediaAgentId', 'INT'),
		csInfo.n.value('@MediaAgentName', 'NVARCHAR(256)'),
		csInfo.n.value('@LibraryId', 'INT'),
		csInfo.n.value('@LibraryName', 'NVARCHAR(128)'),
		csInfo.n.value('@UseHwEncryption', 'INT')
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/HardwareEncryption') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyTapesNotEncrypted (SurveyResultId,
		PolicyId, PolicyName, CopyId, CopyName, MediaId, Barcode, MediaTypeName,
		MediaLocation, LocationName, SizeOnMedia, IsAged, JobIDs, MinJobStart, MaxJobEnd, Encrypted)
	SELECT
		@ResultId,
		csInfo.n.value('@PolicyId', 'INT'),
		csInfo.n.value('@PolicyName', 'NVARCHAR(144)'),
		csInfo.n.value('@CopyId', 'INT'),
		csInfo.n.value('@CopyName', 'NVARCHAR(64)'),
		csInfo.n.value('@MediaId', 'INT'),
		csInfo.n.value('@Barcode', 'NVARCHAR(256)'),
		csInfo.n.value('@MediaTypeName', 'VARCHAR(32)'),
		csInfo.n.value('@MediaLocation', 'INT'),
		csInfo.n.value('@LocationName', 'NVARCHAR(1024)'),
		csInfo.n.value('@SizeOnMedia', 'BIGINT'),
		csInfo.n.value('@IsAged', 'INT'),
		ISNULL(csInfo.n.value('@JobIDs', 'VARCHAR(MAX)'), ''),
		csInfo.n.value('@MinJobStart', 'DATETIME'),
		csInfo.n.value('@MaxJobEnd', 'DATETIME'),
		ISNULL(csInfo.n.value('@Encrypted', 'INT'), 0)
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/TapesNotEncrypted') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseHardwareEncryptionTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseHardwareEncryption')
	delete from GxQscripts where name = 'ParseHardwareEncryption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseHardwareEncryption')
	delete from GXDBVersions where aliasname = 'ParseHardwareEncryption'
GO

insert into GXDBVersions values(2, 'ParseHardwareEncryption',  '00010001000400080000', 'ParseHardwareEncryption', '00010001000400080000')
GO

