

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseIndexBackupStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseIndexBackupStatus.sp,v $ $Id: ParseIndexBackupStatus.sp,v 1.1.2.21 2020/12/22 19:57:12 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseIndexBackupStatus')
BEGIN
	print '>>> Drop Stored Procedure: ParseIndexBackupStatus <<<'
	drop procedure ParseIndexBackupStatus
END
IF EXISTS (select * from GxQscripts where name='ParseIndexBackupStatus')
	delete from GxQscripts where name = 'ParseIndexBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexBackupStatus')
	delete from GXDBVersions where aliasname = 'ParseIndexBackupStatus'
GO
print '... Creating Procedure: ParseIndexBackupStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseIndexBackupStatus
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseIndexBackupStatusTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF 	@ErrorCode = 0
BEGIN
	DECLARE @val nvarchar(max) = (SELECT CAST(CollectedResults AS nvarchar(max)) FROM cf_CommservSurveyResults WHERE CommservSurveyResults_ID = @ResultId)
	IF charindex('<IndexBackupxml',@val,0) <> 0 OR @val = ''
	BEGIN
		DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
		INSERT INTO cf_SurveyIndexBackupStatus(SurveyResultId,ClientId,client,AppType,Backupset,subclientName,IndexServer,dbName,dbuptodate,lastTimeDbUptodate,lastPlayedJobTime,lastCompactionTime,errorLevel,errorDesc,LastBackupTime,LastBackupForDb,IndexType,LastIdxErrorTime,FirstBackupForDb,ScIdxConversionTime, DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason)
		SELECT
			@ResultId,
			csInfo.n.value('@ClientId'					 ,'[INT]'),
			csInfo.n.value('@Client'					 ,'[NVARCHAR](MAX)'),
			csInfo.n.value('@AppType'					 ,'[NVARCHAR](MAX)'),
			csInfo.n.value('@Backupset'					 ,'[NVARCHAR](MAX)'),
			csInfo.n.value('@subclientName'				 ,'[NVARCHAR](MAX)'),
			csInfo.n.value('@IndexServer'				 ,'[NVARCHAR](MAX)'),
			csInfo.n.value('@dbName'					 ,'[NVARCHAR](MAX)'),
			ISNULL(csInfo.n.value('@uptodate'			 ,'[INT]'),0),
			ISNULL(csInfo.n.value('@lastTimeDbUptodate'	 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@lastPlayedJobTime'	 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@lastCompactionTime'	 ,'[BIGINT]'),0),
			ISNULL(csInfo.n.value('@errorLvl'			 ,'[INT]'),-1),
			ISNULL(csInfo.n.value('@errorDesc'			 ,'[NVARCHAR](MAX)'),''),
			ISNULL(csInfo.n.value('@LastBackupTime'		 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@LastBackupForDb'     ,'[BIGINT]'),-1),
			csInfo.n.value('@IndexType'					 ,'[NVARCHAR](MAX)'),
			ISNULL(csInfo.n.value('@LastIdxErrorTime'	 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@FirstBackupForDb'    ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@ScIdxConversionTime' ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@DatabaseSize' 		 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@LogsSize' 			 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@ReportsSize'		 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@MaintenanceSize'	 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@IndexedItems'		 ,'[BIGINT]'),-1),
			ISNULL(csInfo.n.value('@ApplicationSize'	 ,'[BIGINT]'),-1),
			csInfo.n.value('@LastIndexServer'			 ,'[NVARCHAR](MAX)'),
			ISNULL(csInfo.n.value('@MigrationReason'	 ,'[INT]'),-1)
		FROM
			@ResultXml.nodes('/IndexBackupxml/IndexBackupInfo') AS csInfo(n)
		SELECT @ErrorCode = @@ERROR
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb..#IndexBackupStatus') IS NOT NULL
			DROP TABLE #IndexBackupStatus
		CREATE TABLE #IndexBackupStatus
		(
			[ClientId] [int] NOT NULL,
			[client] [nvarchar](288) NULL,
			[AppType] [nvarchar](255) NULL,
			[Backupset] [nvarchar](255) NULL,
			[subclientName] [nvarchar](255) NULL,
			[dbName] [nvarchar](255) NULL,
			[IndexServer] [nvarchar](288) NULL,
			[dbuptodate] [int] NOT NULL,
			[lastTimeDbUptodate] [bigint] NOT NULL,
			[lastPlayedJobTime] [bigint] NOT NULL,
			[lastCompactionTime] [bigint] NOT NULL,
			[errorLevel] [int] NOT NULL,
			[errorDesc] [nvarchar](max) NULL,
			[LastBackupTime] [bigint] NOT NULL,
			[LastBackupForDb] [BIGINT] NOT NULL,
			[IndexType] [nvarchar](255) NULL,
			[LastIdxErrorTime] [BIGINT] NOT NULL,
			[FirstBackupForDb] [BIGINT] NOT NULL,
			[ScIdxConversionTime] [BIGINT] NOT NULL,
			[DatabaseSize] [BIGINT] NOT NULL,
			[LogsSize] [BIGINT] NOT NULL,
			[ReportsSize] [BIGINT] NOT NULL,
			[MaintenanceSize] [BIGINT] NOT NULL,
			[IndexedItems] [BIGINT] NOT NULL,
			[ApplicationSize] [BIGINT] NOT NULL,
			[LastIndexServer] [NVARCHAR](255) NULL,
			[MigrationReason] [INT] NOT NULL
		)
		DECLARE @FileName NVARCHAR(1024)
		SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
		FROM    cf_CommservSurveyResults WITH (NOLOCK)
		WHERE   CommservSurveyResults_ID = @ResultId
		DECLARE @sql NVARCHAR(2000) = ''
		DECLARE @columnCount INT = 0
		IF OBJECT_ID('tempdb..#ColumnCheck') IS NOT NULL DROP TABLE #ColumnCheck
  	    CREATE TABLE #ColumnCheck (rowValue NVARCHAR(MAX))
		IF  @ErrorCode = 0
		BEGIN
			SET @sql = 'BULK INSERT #ColumnCheck FROM ''' + @FileName + ''' WITH ( ROWTERMINATOR =''\n'', KEEPNULLS, LASTROW = 1 )'
			EXEC(@sql)
			DECLARE @firstRow NVARCHAR(MAX) = (SELECT TOP 1 rowValue FROM #ColumnCheck)
			-- we also need to consider blank columns, and ',' in values is replaced by '&comma&' in collection script
			SET @columnCount = (LEN(@firstRow) - LEN(REPLACE(@firstRow, ',', ''))) + 1
			SELECT @ErrorCode = @@ERROR
		END
		-- Decide which columns exist in CSV based on column count
		IF  @ErrorCode = 0
		BEGIN
			IF @columnCount = 19
			BEGIN
				ALTER TABLE #IndexBackupStatus DROP COLUMN DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason
			END
			IF @columnCount = 16
			BEGIN
				ALTER TABLE #IndexBackupStatus DROP COLUMN LastIdxErrorTime, FirstBackupForDb, ScIdxConversionTime, DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason
			END
			ELSE IF @columnCount = 15
			BEGIN
				ALTER TABLE #IndexBackupStatus DROP COLUMN LastBackupForDb, LastIdxErrorTime, FirstBackupForDb, ScIdxConversionTime, DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason
			END
			ELSE IF @columnCount = 14
			BEGIN
				ALTER TABLE #IndexBackupStatus DROP COLUMN subclientName, lastCompactionTime, LastIdxErrorTime, FirstBackupForDb, ScIdxConversionTime, DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason
			END
			ELSE IF @columnCount = 13
			BEGIN
				ALTER TABLE #IndexBackupStatus DROP COLUMN subclientName, lastCompactionTime, LastBackupForDb, LastIdxErrorTime, FirstBackupForDb, ScIdxConversionTime, DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason
			END
		END
		IF  @ErrorCode = 0
		BEGIN
			SET @sql = 'BULK INSERT #IndexBackupStatus FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )'
			EXEC(@sql)
			SELECT @ErrorCode = @@ERROR
		END
		IF  @ErrorCode = 0
		BEGIN
			UPDATE #IndexBackupStatus
			SET	[client]     = REPLACE([client], '&comma&', ','),
				[Backupset]  = REPLACE([Backupset], '&comma&', ','),
				[IndexServer]= REPLACE([IndexServer], '&comma&', ','),
				[errorDesc]  = CASE WHEN [errorDesc] IS NULL THEN '' ELSE REPLACE([errorDesc], '&comma&', ',') END,
				[IndexType]  = REPLACE([IndexType], '&comma&', ',')
			SELECT @ErrorCode = @@ERROR
		END
		IF  @ErrorCode = 0 AND @columnCount > 14
		BEGIN
			UPDATE #IndexBackupStatus
			SET	[subclientName] = REPLACE(ISNULL([subclientName], ''), '&comma&', ',')
			SELECT @ErrorCode = @@ERROR
		END
		IF  @ErrorCode = 0
		BEGIN
			DECLARE @InsertQuery NVARCHAR(MAX) =
				'INSERT INTO cf_SurveyIndexBackupStatus(SurveyResultId,ClientId,client,AppType,Backupset,IndexServer,dbName,dbuptodate,lastTimeDbUptodate,lastPlayedJobTime,errorLevel,errorDesc,LastBackupTime,IndexType,subclientName,lastCompactionTime,LastBackupForDb,LastIdxErrorTime,FirstBackupForDb,ScIdxConversionTime, DatabaseSize, LogsSize, ReportsSize, MaintenanceSize, IndexedItems, ApplicationSize, LastIndexServer, MigrationReason)
					SELECT ' + STR(@ResultId) + '
					,[ClientId]
					,[client]
					,[AppType]
					,[Backupset]
					,[IndexServer]
					,[dbName]
					,[dbuptodate]
					,[lastTimeDbUptodate]
					,[lastPlayedJobTime]
				    ,[errorLevel]
					,[errorDesc]
					,[LastBackupTime]
					,[IndexType]'
					+ (CASE WHEN @columnCount > 14 THEN ',[subclientName]' ELSE ',''''' END) +
					+ (CASE WHEN @columnCount > 14 THEN ',[lastCompactionTime]' ELSE ',0' END) +
					+ (CASE WHEN (@columnCount > 15 OR @columnCount = 14) THEN ',[LastBackupForDb]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 16 THEN ',[LastIdxErrorTime]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 16 THEN ',[FirstBackupForDb]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 16 THEN ',[ScIdxConversionTime]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[DatabaseSize]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[LogsSize]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[ReportsSize]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[MaintenanceSize]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[IndexedItems]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[ApplicationSize]' ELSE ',-1' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[LastIndexServer]' ELSE ',''''' END) +
					+ (CASE WHEN @columnCount > 19 THEN ',[MigrationReason]' ELSE ',-1' END) +
				'FROM #IndexBackupStatus;'
			EXEC(@InsertQuery)
			SELECT @ErrorCode = @@ERROR
		END
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseIndexBackupStatusTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseIndexBackupStatus')
	delete from GxQscripts where name = 'ParseIndexBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexBackupStatus')
	delete from GXDBVersions where aliasname = 'ParseIndexBackupStatus'
GO

insert into GXDBVersions values(2, 'ParseIndexBackupStatus',  '00010001000200210000', 'ParseIndexBackupStatus', '00010001000200210000')
GO

