

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseIndexCacheUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseIndexCacheUsage.sp,v $ $Id: ParseIndexCacheUsage.sp,v 1.4.60.17 2020/12/17 02:49:17 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseIndexCacheUsage')
BEGIN
	print '>>> Drop Stored Procedure: ParseIndexCacheUsage <<<'
	drop procedure ParseIndexCacheUsage
END
IF EXISTS (select * from GxQscripts where name='ParseIndexCacheUsage')
	delete from GxQscripts where name = 'ParseIndexCacheUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexCacheUsage')
	delete from GXDBVersions where aliasname = 'ParseIndexCacheUsage'
GO
print '... Creating Procedure: ParseIndexCacheUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseIndexCacheUsage
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseIndexCacheUsageTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @WeekStart DATETIME = DATEADD(WEEK, DATEDIFF(WEEK, 0, @LogDate), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyIndexCacheUsage
	SELECT DISTINCT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MAId', 'BIGINT'),
		csInfo.n.value('@MAName','NVARCHAR(MAX)'),
		csInfo.n.value('@IndexCachePath','NVARCHAR(MAX)'),
		csInfo.n.value('@IntermediateCachePath','NVARCHAR(MAX)'),
		csInfo.n.value('@IsShared','INT'),
		csInfo.n.value('@IsUNC','INT'),
		csInfo.n.value('@TotalCapacityMB','BIGINT'),
		csInfo.n.value('@DiskUsageMB','BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB','BIGINT'),
		ISNULL(csInfo.n.value('@IndexAccessPathEnabled','INT'),-1),
		ISNULL(csInfo.n.value('@DbSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@LogsSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@ReportsSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@LegacySizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@OtherSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@LocationTableSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@CacheType', 'INT'), 0),
		ISNULL(csInfo.n.value('@NumberOfHostedIndices', 'INT'), 0),
		ISNULL(csInfo.n.value('@NumberOfOutdatedIndices', 'INT'), 0),
		ISNULL(csInfo.n.value('@NumberOfErrorIndices', 'INT'), 0),
		ISNULL(csInfo.n.value('@ServerStatus', 'TINYINT'), 0),
		ISNULL(csInfo.n.value('@CacheDisabledReason', 'INT'), 0)
	FROM
		@ResultXml.nodes('/MediaAgentIndexCacheInfo') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    UPDATE cf_SurveyIndexCacheUsagePeakSize
    SET DiskUsageMB = CASE WHEN ISNULL(S.DiskUsageMB,0) > ISNULL(P.DiskUsageMB,0) THEN ISNULL(S.DiskUsageMB,0) ELSE ISNULL(P.DiskUsageMB,0) END,
        FreeDiskSpaceMB = CASE WHEN (ISNULL(S.FreeDiskSpaceMB,0) < ISNULL(P.FreeDiskSpaceMB,0)) OR ISNULL(P.FreeDiskSpaceMB,0) <= 0 THEN ISNULL(S.FreeDiskSpaceMB,0) ELSE ISNULL(P.FreeDiskSpaceMB,0) END
    FROM cf_SurveyIndexCacheUsage S
        INNER JOIN cf_SurveyIndexCacheUsagePeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.WeekStart = @WeekStart AND P.MAId = S.MAId AND ISNULL(P.IndexCachePath, '') = ISNULL(S.IndexCachePath, '')
    WHERE S.TotalCapacityMB > 0 AND S.FreeDiskSpaceMB > 0 and S.SurveyResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO cf_SurveyIndexCacheUsagePeakSize (
        CommServUniqueId, WeekStart, MAId, IndexCachePath, DiskUsageMB, FreeDiskSpaceMB)
    SELECT
        @CSUniqueId, @WeekStart, S.MAId, ISNULL(S.IndexCachePath, ''),
        ISNULL(MAX(S.DiskUsageMB),0), ISNULL(MIN(S.FreeDiskSpaceMB),0)
    FROM cf_SurveyIndexCacheUsage S
        LEFT OUTER JOIN cf_SurveyIndexCacheUsagePeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.WeekStart = @WeekStart AND P.MAId = S.MAId AND ISNULL(P.IndexCachePath, '') = ISNULL(S.IndexCachePath, '')
    WHERE P.CommServUniqueId IS NULL and S.SurveyResultId = @ResultId
    GROUP BY S.MAId, S.IndexCachePath
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseIndexCacheUsageTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseIndexCacheUsage')
	delete from GxQscripts where name = 'ParseIndexCacheUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexCacheUsage')
	delete from GXDBVersions where aliasname = 'ParseIndexCacheUsage'
GO

insert into GXDBVersions values(2, 'ParseIndexCacheUsage',  '00010004006000170000', 'ParseIndexCacheUsage', '00010004006000170000')
GO

