

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicCurrentSummaryV2.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicCurrentSummaryV2.sp,v $ $Id: ParseLicCurrentSummaryV2.sp,v 1.1.2.2 2018/08/30 22:24:12 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseLicCurrentSummaryV2')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicCurrentSummaryV2 <<<'
	drop procedure ParseLicCurrentSummaryV2
END
IF EXISTS (select * from GxQscripts where name='ParseLicCurrentSummaryV2')
	delete from GxQscripts where name = 'ParseLicCurrentSummaryV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicCurrentSummaryV2')
	delete from GXDBVersions where aliasname = 'ParseLicCurrentSummaryV2'
GO
print '... Creating Procedure: ParseLicCurrentSummaryV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLicCurrentSummaryV2
  @QueryId INTEGER,
  @ResultId INTEGER,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicCurrentSummaryV2Tran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#CurrentSummary') IS NOT NULL
    DROP TABLE #CurrentSummary
CREATE TABLE #CurrentSummary
(
	Date						DATETIME,
	nJobType					INT,
	LicType						INT,
	PermTotal					BIGINT,
	PermUsed					BIGINT,
	EvalTotal					BIGINT,
	EvalUsed					BIGINT,
	TermDate					VARCHAR(128),
	ClientId					INT,
	AppTypeId					INT,
	InstallDate					VARCHAR(128),
	ExpiryDate					VARCHAR(128)
)
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(256) = 'BULK INSERT #CurrentSummary FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT 1 FROM #CurrentSummary)
BEGIN
	--for each CommCell, remove existing data from the cloud tables for storing latest usage summary. Only the latest usages are required always
	DELETE FROM cf_SurveyLicCurrentUsageSummary WHERE CommServUniqueId=@CSUniqueId
	DELETE FROM cf_SurveyLicCurrentLicenseInfo WHERE CommServUniqueId=@CSUniqueId
	--insert newly uploaded current usages into cloud tables
	INSERT cf_SurveyLicCurrentUsageSummary
	SELECT @CSUniqueId,Date,nJobType,LicType,AppTypeId,PermUsed,PermTotal,EvalTotal
	FROM #CurrentSummary
	WHERE nJobType<>-2
	SELECT @ErrorCode = @@ERROR
	IF 	@ErrorCode = 0
	BEGIN
		INSERT cf_SurveyLicCurrentLicenseInfo
		SELECT @CSUniqueId,Date,LicType,PermTotal,PermUsed,EvalTotal,EvalUsed,TermDate,ClientId,AppTypeId,InstallDate,ExpiryDate
		FROM #CurrentSummary
		WHERE nJobType=-2
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId INT, Flags INT) 
  		DECLARE	@LatestParsedResultId INT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicCurrentSummaryV2Tran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicCurrentSummaryV2')
	delete from GxQscripts where name = 'ParseLicCurrentSummaryV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicCurrentSummaryV2')
	delete from GXDBVersions where aliasname = 'ParseLicCurrentSummaryV2'
GO

insert into GXDBVersions values(2, 'ParseLicCurrentSummaryV2',  '00010001000200020000', 'ParseLicCurrentSummaryV2', '00010001000200020000')
GO

