

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicLicenseInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicLicenseInfo.sp,v $ $Id: ParseLicLicenseInfo.sp,v 1.1.2.8 2020/12/17 02:55:11 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseLicLicenseInfo')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicLicenseInfo <<<'
	drop procedure ParseLicLicenseInfo
END
IF EXISTS (select * from GxQscripts where name='ParseLicLicenseInfo')
	delete from GxQscripts where name = 'ParseLicLicenseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicLicenseInfo')
	delete from GXDBVersions where aliasname = 'ParseLicLicenseInfo'
GO
print '... Creating Procedure: ParseLicLicenseInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseLicLicenseInfo
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicLicenseInfoTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#Lic_LicenseInfo') IS NOT NULL
    DROP TABLE #Lic_LicenseInfo
CREATE TABLE #Lic_LicenseInfo
(
	LicType                     INT,
	PermTotal                   BIGINT,
	PermUsed                    BIGINT,
	EvalTotal                   BIGINT,
	EvalUsed                    BIGINT,
	TermDate                    DATETIME,
	ClientId                    INT,
	AppTypeId                   INT,
	InstallDate                 DATETIME,
	ExpiryDate                  DATETIME
)
IF OBJECT_ID('tempdb..#ColumnCheck') IS NOT NULL
    DROP TABLE #ColumnCheck
CREATE TABLE #ColumnCheck (rowValue NVARCHAR(MAX))
DECLARE @sql NVARCHAR(256) = ''
DECLARE @columnCount INT = 0
IF 	@ErrorCode = 0
BEGIN
	--first check how many columns are in the csv coming from CS
	--1) if uploaded using SP19 query, it will have 10 columns
	--2) if uploaded using SP15 query, it will have 11 columns
	SET @sql = 'BULK INSERT #ColumnCheck FROM ''' + @FileName + ''' WITH ( ROWTERMINATOR =''\n'', KEEPNULLS, LASTROW = 1 )';
	EXEC(@sql);
	SELECT @columnCount=count(_ID) FROM dbo.SplitStringByDelimiter((select rowValue from #ColumnCheck),',')
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	IF @columnCount=10
	BEGIN
		--uploaded using latest SP19 queries. Insert them as it is.
		SET @sql = 'BULK INSERT #Lic_LicenseInfo FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		SELECT @ErrorCode = @@ERROR
	END
	ELSE IF @columnCount=11
	BEGIN
		IF OBJECT_ID('tempdb..#oldLic_LicenseInfo') IS NOT NULL
		DROP TABLE #oldLic_LicenseInfo
		CREATE TABLE #oldLic_LicenseInfo
		(
			LicType                     INT,
			PermTotal                   BIGINT,
			PermUsed                    BIGINT,
			EvalTotal                   BIGINT,
			EvalUsed                    BIGINT,
			TermDate                    DATETIME,
			ClientId                    INT,
			ClientName                  NVARCHAR(255),
			AppTypeId                   INT,
			InstallDate                 DATETIME,
			ExpiryDate                  DATETIME
		)
		SET @sql = 'BULK INSERT #oldLic_LicenseInfo FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		SELECT @ErrorCode = @@ERROR
		IF @ErrorCode = 0
		BEGIN
			INSERT #Lic_LicenseInfo
			SELECT DISTINCT LicType, PermTotal, PermUsed, EvalTotal, EvalUsed, TermDate, ClientId, AppTypeId, InstallDate, ExpiryDate
			FROM #oldLic_LicenseInfo
			SELECT @ErrorCode = @@ERROR
		END
		IF OBJECT_ID('tempdb..#oldLic_CurrentUsage') IS NOT NULL DROP TABLE #oldLic_CurrentUsage
	END
	ELSE
		GOTO LIC_END
END
IF @ErrorCode = 0 AND EXISTS (SELECT 1 FROM #Lic_LicenseInfo)
BEGIN
	--for each CommCell, remove existing data from the cloud table for storing latest license info. Only the latest info is required always
	DELETE FROM Lic_LicenseInfo WHERE CommServUniqueId=@CSUniqueId
	--insert newly uploaded license info into cloud table
	INSERT INTO Lic_LicenseInfo (CommServUniqueId,LicType,PermTotal,PermUsed,EvalTotal,EvalUsed,TermDate,ClientId,AppTypeId,InstallDate,ExpiryDate)
	SELECT DISTINCT @CSUniqueId,LicType,PermTotal,PermUsed,EvalTotal,EvalUsed,TermDate,ClientId,AppTypeId,InstallDate,ExpiryDate
	FROM #Lic_LicenseInfo
	SELECT @ErrorCode = @@ERROR
END
LIC_END:
IF OBJECT_ID('tempdb..#Lic_LicenseInfo') IS NOT NULL DROP TABLE #Lic_LicenseInfo
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicLicenseInfoTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicLicenseInfo')
	delete from GxQscripts where name = 'ParseLicLicenseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicLicenseInfo')
	delete from GXDBVersions where aliasname = 'ParseLicLicenseInfo'
GO

insert into GXDBVersions values(2, 'ParseLicLicenseInfo',  '00010001000200080000', 'ParseLicLicenseInfo', '00010001000200080000')
GO

