

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicPeakSummaryV2.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicPeakSummaryV2.sp,v $ $Id: ParseLicPeakSummaryV2.sp,v 1.1.2.1 2018/07/16 02:56:53 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseLicPeakSummaryV2')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicPeakSummaryV2 <<<'
	drop procedure ParseLicPeakSummaryV2
END
IF EXISTS (select * from GxQscripts where name='ParseLicPeakSummaryV2')
	delete from GxQscripts where name = 'ParseLicPeakSummaryV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicPeakSummaryV2')
	delete from GXDBVersions where aliasname = 'ParseLicPeakSummaryV2'
GO
print '... Creating Procedure: ParseLicPeakSummaryV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLicPeakSummaryV2
  @QueryId INTEGER,
  @ResultId INTEGER,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicPeakSummaryV2Tran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETDATE()), 0)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#PeakSummary') IS NOT NULL
    DROP TABLE #PeakSummary
CREATE TABLE #PeakSummary
(
	Date						INT NOT NULL,	--Unix timestamp of the day on which the peak is collected
	CCLProtectedClient			INT,
	CCLArchivedClient			INT,
	CCLArchivedVM				INT,
	CCLACV						INT,
	CCLVMOnly					INT,
	CCLVMWithApp				INT,
	CCLVMSocket					INT,
	CCLArchivedMailBox			INT,
	CCLMSimUsers				INT,
	CCLSearchMailBox			INT,
	CCLSRMClient				INT,
	CCLCIServer					INT,
	CCLContentIndexedObject		BIGINT,
	CCLAdvSearchNodes			INT,
	CCLEpUsers					INT,
	CCLEpSharingUsers			INT,
	CCLEpEdiscoveryUsers		INT,
	CCLFSOnlyServer				INT,
	CCLDLO						INT,
	CCLApplicationServer		INT,
	CCLAppStoreCapacityMB		BIGINT,
	CCLUsedDiskSpaceMB			BIGINT,
	CCLAvailDiskSpaceMB			BIGINT,
	CCLDedupDataSizeMB			BIGINT,
	CCLDedupDataOnTapeMB		BIGINT,
	CCLAvailDedupSpaceMB		BIGINT,
	SCLProtectedClient			INT,
	SCLArchivedClient			INT,
	SCLArchivedVM				INT,
	SCLACV						INT,
	SCLVMOnly					INT,
	SCLVMWithApp				INT,
	SCLVMSocket					INT,
	SCLArchivedMailBox			INT,
	SCLMSimUsers				INT,
	SCLSearchMailBox			INT,
	SCLSRMClient				INT,
	SCLCIServer					INT,
	SCLContentIndexedObject		BIGINT,
	SCLAdvSearchNodes			INT,
	SCLEpUsers					INT,
	SCLEpSharingUsers			INT,
	SCLEpEdiscoveryUsers		INT,
	SCLFSOnlyServer				INT,
	SCLDLO						INT,
	SCLApplicationServer		INT,
	SCLAppStoreCapacityMB		BIGINT,
	SCLUsedDiskSpaceMB			BIGINT,
	SCLAvailDiskSpaceMB			BIGINT,
	SCLDedupDataSizeMB			BIGINT,
	SCLDedupDataOnTapeMB		BIGINT,
	SCLAvailDedupSpaceMB		BIGINT
)
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(256) = 'BULK INSERT #PeakSummary FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT 1 FROM #PeakSummary)
BEGIN
	MERGE cf_SurveyLicPeakUsageHistory AS T
	USING (SELECT Date, CCLAppStoreCapacityMB,	CCLUsedDiskSpaceMB, CCLAvailDiskSpaceMB, CCLDedupDataSizeMB, SCLAppStoreCapacityMB,	SCLUsedDiskSpaceMB, SCLAvailDiskSpaceMB, SCLDedupDataSizeMB
			FROM #PeakSummary WHERE CCLProtectedClient=-1 ) AS S
	ON T.Date = S.Date AND CommServUniqueId = @CSUniqueId
	WHEN MATCHED
		THEN UPDATE SET T.CCLPeakEnterpriseBackupSize = S.CCLAppStoreCapacityMB, T.CCLPeakEnterpriseArchiveSize = S.CCLUsedDiskSpaceMB, T.CCLPeakSnapSize = S.CCLAvailDiskSpaceMB, T.CCLPeakReplicationSize = S.CCLDedupDataSizeMB, T.SCLPeakEnterpriseBackupSize = S.SCLAppStoreCapacityMB, T.SCLPeakEnterpriseArchiveSize = S.SCLUsedDiskSpaceMB, T.SCLPeakSnapSize = S.SCLAvailDiskSpaceMB, T.SCLPeakReplicationSize = S.SCLDedupDataSizeMB
	WHEN NOT MATCHED BY TARGET
		THEN INSERT (CommServUniqueId, Date, CCLPeakEnterpriseBackupSize, CCLPeakEnterpriseArchiveSize, CCLPeakSnapSize, CCLPeakReplicationSize, SCLPeakEnterpriseBackupSize, SCLPeakEnterpriseArchiveSize, SCLPeakSnapSize, SCLPeakReplicationSize)
		VALUES(@CSUniqueId, S.Date, S.CCLAppStoreCapacityMB, S.CCLUsedDiskSpaceMB, S.CCLAvailDiskSpaceMB, S.CCLDedupDataSizeMB, S.SCLAppStoreCapacityMB, S.SCLUsedDiskSpaceMB, S.SCLAvailDiskSpaceMB, S.SCLDedupDataSizeMB)
	;
	IF 	@ErrorCode = 0
	BEGIN
		MERGE cf_SurveyLicPeakCALClientCountHistory AS T
		USING (SELECT Date, CCLProtectedClient, CCLArchivedClient, CCLArchivedVM, CCLACV, CCLVMOnly, CCLVMWithApp, CCLVMSocket, CCLArchivedMailBox, CCLMSimUsers, CCLSearchMailBox, CCLSRMClient, CCLCIServer, CCLContentIndexedObject, CCLAdvSearchNodes, CCLEpUsers, CCLEpSharingUsers, CCLEpEdiscoveryUsers, CCLFSOnlyServer, CCLDLO, CCLApplicationServer, CCLAppStoreCapacityMB, CCLUsedDiskSpaceMB, CCLAvailDiskSpaceMB, CCLDedupDataSizeMB, CCLDedupDataOnTapeMB, CCLAvailDedupSpaceMB, SCLProtectedClient, SCLArchivedClient, SCLArchivedVM, SCLACV, SCLVMOnly, SCLVMWithApp, SCLVMSocket, SCLArchivedMailBox, SCLMSimUsers, SCLSearchMailBox, SCLSRMClient, SCLCIServer, SCLContentIndexedObject, SCLAdvSearchNodes, SCLEpUsers, SCLEpSharingUsers, SCLEpEdiscoveryUsers, SCLFSOnlyServer, SCLDLO, SCLApplicationServer, SCLAppStoreCapacityMB, SCLUsedDiskSpaceMB, SCLAvailDiskSpaceMB, SCLDedupDataSizeMB, SCLDedupDataOnTapeMB, SCLAvailDedupSpaceMB
				FROM #PeakSummary WHERE CCLProtectedClient<>-1) AS S
		ON T.Date = S.Date AND CommServUniqueId = @CSUniqueId
		WHEN MATCHED
			THEN UPDATE SET T.CCLProtectedClient=S.CCLProtectedClient, T.CCLArchivedClient=S.CCLArchivedClient, T.CCLArchivedVM=S.CCLArchivedVM, T.CCLACV=S.CCLACV, T.CCLVMOnly=S.CCLVMOnly, T.CCLVMWithApp=S.CCLVMWithApp, T.CCLVMSocket=S.CCLVMSocket, T.CCLArchivedMailBox=S.CCLArchivedMailBox, T.CCLMSimUsers=S.CCLMSimUsers, T.CCLSearchMailBox=S.CCLSearchMailBox, T.CCLSRMClient=S.CCLSRMClient, T.CCLCIServer=S.CCLCIServer, T.CCLContentIndexedObject=S.CCLContentIndexedObject, T.CCLAdvSearchNodes=S.CCLAdvSearchNodes, T.CCLEpUsers=S.CCLEpUsers, T.CCLEpSharingUsers=S.CCLEpSharingUsers, T.CCLEpEdiscoveryUsers=S.CCLEpEdiscoveryUsers, T.CCLFSOnlyServer=S.CCLFSOnlyServer, T.CCLDLO=S.CCLDLO, T.CCLApplicationServer=S.CCLApplicationServer, T.CCLAppStoreCapacityMB=S.CCLAppStoreCapacityMB, T.CCLUsedDiskSpaceMB=S.CCLUsedDiskSpaceMB, T.CCLAvailDiskSpaceMB=S.CCLAvailDiskSpaceMB, T.CCLDedupDataSizeMB=S.CCLDedupDataSizeMB, T.CCLDedupDataOnTapeMB=S.CCLDedupDataOnTapeMB, T.CCLAvailDedupSpaceMB=S.CCLAvailDedupSpaceMB, T.SCLProtectedClient=S.SCLProtectedClient, T.SCLArchivedClient=S.SCLArchivedClient, T.SCLArchivedVM=S.SCLArchivedVM, T.SCLACV=S.SCLACV, T.SCLVMOnly=S.SCLVMOnly, T.SCLVMWithApp=S.SCLVMWithApp, T.SCLVMSocket=S.SCLVMSocket, T.SCLArchivedMailBox=S.SCLArchivedMailBox, T.SCLMSimUsers=S.SCLMSimUsers, T.SCLSearchMailBox=S.SCLSearchMailBox, T.SCLSRMClient=S.SCLSRMClient, T.SCLCIServer=S.SCLCIServer, T.SCLContentIndexedObject=S.SCLContentIndexedObject, T.SCLAdvSearchNodes=S.SCLAdvSearchNodes, T.SCLEpUsers=S.SCLEpUsers, T.SCLEpSharingUsers=S.SCLEpSharingUsers, T.SCLEpEdiscoveryUsers=S.SCLEpEdiscoveryUsers, T.SCLFSOnlyServer=S.SCLFSOnlyServer, T.SCLDLO=S.SCLDLO, T.SCLApplicationServer=S.SCLApplicationServer, T.SCLAppStoreCapacityMB=S.SCLAppStoreCapacityMB, T.SCLUsedDiskSpaceMB=S.SCLUsedDiskSpaceMB, T.SCLAvailDiskSpaceMB=S.SCLAvailDiskSpaceMB, T.SCLDedupDataSizeMB=S.SCLDedupDataSizeMB, T.SCLDedupDataOnTapeMB=S.SCLDedupDataOnTapeMB, T.SCLAvailDedupSpaceMB=S.SCLAvailDedupSpaceMB
		WHEN NOT MATCHED BY TARGET
			THEN INSERT (CommServUniqueId, Date, CCLProtectedClient, CCLArchivedClient, CCLArchivedVM, CCLACV, CCLVMOnly, CCLVMWithApp, CCLVMSocket, CCLArchivedMailBox, CCLMSimUsers, CCLSearchMailBox, CCLSRMClient, CCLCIServer, CCLContentIndexedObject, CCLAdvSearchNodes, CCLEpUsers, CCLEpSharingUsers, CCLEpEdiscoveryUsers, CCLFSOnlyServer, CCLDLO, CCLApplicationServer, CCLAppStoreCapacityMB, CCLUsedDiskSpaceMB, CCLAvailDiskSpaceMB, CCLDedupDataSizeMB, CCLDedupDataOnTapeMB, CCLAvailDedupSpaceMB, SCLProtectedClient, SCLArchivedClient, SCLArchivedVM, SCLACV, SCLVMOnly, SCLVMWithApp, SCLVMSocket, SCLArchivedMailBox, SCLMSimUsers, SCLSearchMailBox, SCLSRMClient, SCLCIServer, SCLContentIndexedObject, SCLAdvSearchNodes, SCLEpUsers, SCLEpSharingUsers, SCLEpEdiscoveryUsers, SCLFSOnlyServer, SCLDLO, SCLApplicationServer, SCLAppStoreCapacityMB, SCLUsedDiskSpaceMB, SCLAvailDiskSpaceMB, SCLDedupDataSizeMB, SCLDedupDataOnTapeMB, SCLAvailDedupSpaceMB)
			VALUES(@CSUniqueId, S.Date, S.CCLProtectedClient, S.CCLArchivedClient, S.CCLArchivedVM, S.CCLACV, S.CCLVMOnly, S.CCLVMWithApp, S.CCLVMSocket, S.CCLArchivedMailBox, S.CCLMSimUsers, S.CCLSearchMailBox, S.CCLSRMClient, S.CCLCIServer, S.CCLContentIndexedObject, S.CCLAdvSearchNodes, S.CCLEpUsers, S.CCLEpSharingUsers, S.CCLEpEdiscoveryUsers, S.CCLFSOnlyServer, S.CCLDLO, S.CCLApplicationServer, S.CCLAppStoreCapacityMB, S.CCLUsedDiskSpaceMB, S.CCLAvailDiskSpaceMB, S.CCLDedupDataSizeMB, S.CCLDedupDataOnTapeMB, S.CCLAvailDedupSpaceMB, S.SCLProtectedClient, S.SCLArchivedClient, S.SCLArchivedVM, S.SCLACV, S.SCLVMOnly, S.SCLVMWithApp, S.SCLVMSocket, S.SCLArchivedMailBox, S.SCLMSimUsers, S.SCLSearchMailBox, S.SCLSRMClient, S.SCLCIServer, S.SCLContentIndexedObject, S.SCLAdvSearchNodes, S.SCLEpUsers, S.SCLEpSharingUsers, S.SCLEpEdiscoveryUsers, S.SCLFSOnlyServer, S.SCLDLO, S.SCLApplicationServer, S.SCLAppStoreCapacityMB, S.SCLUsedDiskSpaceMB, S.SCLAvailDiskSpaceMB, S.SCLDedupDataSizeMB, S.SCLDedupDataOnTapeMB, S.SCLAvailDedupSpaceMB)
		;
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId INT, Flags INT) 
  		DECLARE	@LatestParsedResultId INT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicPeakSummaryV2Tran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicPeakSummaryV2')
	delete from GxQscripts where name = 'ParseLicPeakSummaryV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicPeakSummaryV2')
	delete from GXDBVersions where aliasname = 'ParseLicPeakSummaryV2'
GO

insert into GXDBVersions values(2, 'ParseLicPeakSummaryV2',  '00010001000200010000', 'ParseLicPeakSummaryV2', '00010001000200010000')
GO

