

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicPeakUsageDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicPeakUsageDetails.sp,v $ $Id: ParseLicPeakUsageDetails.sp,v 1.1.2.13 2020/12/17 02:51:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseLicPeakUsageDetails')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicPeakUsageDetails <<<'
	drop procedure ParseLicPeakUsageDetails
END
IF EXISTS (select * from GxQscripts where name='ParseLicPeakUsageDetails')
	delete from GxQscripts where name = 'ParseLicPeakUsageDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicPeakUsageDetails')
	delete from GXDBVersions where aliasname = 'ParseLicPeakUsageDetails'
GO
print '... Creating Procedure: ParseLicPeakUsageDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseLicPeakUsageDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicPeakUsageDetailsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETDATE()), 0)
IF OBJECT_ID('tempdb..#PeakUsageDetails') IS NOT NULL
    DROP TABLE #PeakUsageDetails
CREATE TABLE #PeakUsageDetails
(
	MonthStart					DATETIME NOT NULL,	--One Date for each Month.
	PeakDate					DATETIME NOT NULL,	--PeakDate can be different for different nJobType.
	nJobType					INT NOT NULL,	--0 - Backup, 1- Archive, 2- Snap, 3- Replication
	JobId						INT NOT NULL,
	SPId						INT NOT NULL,
	ClientId					INT NOT NULL,
	AppTypeId					INT NOT NULL,
	AppId						INT NOT NULL,
	AppSizeMB					BIGINT NOT NULL,
	LicType						INT NOT NULL,
	IsVM						INT NOT NULL,
	CapacityFlag				INT NOT NULL,
	Organization				NVARCHAR(1024) NULL,
	OrgGUID						VARCHAR(40) NULL,
	VMClientId					INT NULL
)
IF 	@ErrorCode = 0
BEGIN
	SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
	FROM	cf_CommservSurveyResults
	WHERE 	CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #PeakUsageDetails FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Remove duplicated rows coming from LicPeakUsageDetails
	;WITH Usage_CTE
	AS (SELECT ROW_NUMBER() OVER (PARTITION BY monthstart,nJobType,clientid,appid ORDER BY AppSizeMB DESC, jobid DESC,peakdate DESC) RN
	FROM   #PeakUsageDetails WHERE nJobType > -1)
	DELETE FROM Usage_CTE
	WHERE  RN > 1
	--Remove duplicated rows coming from LicPeakCLALicClientCount
	;WITH ClientCount_CTE
	AS (SELECT ROW_NUMBER() OVER (PARTITION BY MonthStart,LicType,AppTypeId,VMClientId ORDER BY jobid DESC,PeakDate DESC) RN
	FROM   #PeakUsageDetails WHERE nJobType < 0)
	DELETE FROM ClientCount_CTE
	WHERE  RN > 1
	Update #PeakUsageDetails
	Set Organization = Replace (Organization,'<COMMA>',',')
	Where Organization is not NULL and CHARINDEX('<COMMA>', Organization)>0
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT * FROM #PeakUsageDetails)
BEGIN
	MERGE cf_SurveyLicPeakUsageDetails AS T
	USING (SELECT MonthStart, PeakDate,	nJobType, JobId, SPId, ClientId, AppTypeId, AppId, AppSizeMB, LicType, IsVM, CapacityFlag, Organization, OrgGUID
			FROM #PeakUsageDetails WHERE nJobType > -1 ) AS S
	ON T.AppId = S.AppId AND T.nJobtype = S.nJobtype AND T.MonthStart = S.MonthStart AND CommServUniqueId = @CSUniqueId
	WHEN MATCHED AND S.AppSizeMB >= T.AppSizeMB
		THEN UPDATE SET T.AppSizeMB = S.AppSizeMB, T.PeakDate = S.PeakDate, T.jobID = S.jobID, T.SPId = S.SPId, T.LicType = S.LicType, T.IsVM = S.IsVM, T.CapacityFlag = S.CapacityFlag, T.Organization = S.Organization, T.OrgGUID = S.OrgGUID
	WHEN NOT MATCHED BY TARGET
		THEN INSERT (CommServUniqueId, MonthStart, PeakDate, nJobType, jobID, SPId, ClientId, AppTypeId , appId, AppSizeMB, LicType, IsVM, CapacityFlag, Organization, OrgGUID)
		VALUES(@CSUniqueId, S.MonthStart, S.PeakDate, S.nJobType, S.jobID, S.SPId, S.ClientId, S.AppTypeId ,S.appId, S.AppSizeMB, S.LicType, S.IsVM, S.CapacityFlag, S.Organization, S.OrgGUID)
	;
	IF 	@ErrorCode = 0
	BEGIN
		MERGE cf_SurveyLicPeakCLALicClientCount AS T
		USING (SELECT MonthStart, PeakDate, ClientId, VMClientId, AppTypeId , LicType, jobID, Organization, OrgGUID
				FROM #PeakUsageDetails WHERE nJobType < 0 AND LicType = 100019) AS S
		ON T.VMClientId = S.VMClientId AND T.MonthStart = S.MonthStart AND CommServUniqueId = @CSUniqueId
		WHEN MATCHED AND S.JobId <> T.JobId
			THEN UPDATE SET T.JobId = S.JobId, T.PeakDate = S.PeakDate
		WHEN NOT MATCHED BY TARGET
			THEN INSERT (CommServUniqueId, MonthStart, PeakDate, ClientId, VMClientId, AppTypeId , LicType, jobID, Organization, OrgGUID)
			VALUES(@CSUniqueId, S.MonthStart, S.PeakDate, S.ClientId, S.VMClientId, S.AppTypeId, S.LicType, S.jobID, S.Organization, S.OrgGUID)
		;
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		MERGE cf_SurveyLicPeakCLALicClientCount AS T
		USING (SELECT MonthStart, PeakDate, ClientId, VMClientId, AppTypeId , LicType, jobID, Organization, OrgGUID
				FROM #PeakUsageDetails WHERE nJobType < 0 AND LicType = 100027) AS S
		ON T.VMClientId = S.VMClientId AND T.AppTypeId = S.AppTypeId AND T.MonthStart = S.MonthStart AND CommServUniqueId = @CSUniqueId
		WHEN NOT MATCHED BY TARGET
			THEN INSERT (CommServUniqueId, MonthStart, PeakDate, ClientId, VMClientId, AppTypeId , LicType, jobID, Organization, OrgGUID)
			VALUES(@CSUniqueId, S.MonthStart, S.PeakDate, S.ClientId, S.VMClientId, S.AppTypeId, S.LicType, S.jobID, S.Organization, S.OrgGUID)
		;
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicPeakUsageDetailsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicPeakUsageDetails')
	delete from GxQscripts where name = 'ParseLicPeakUsageDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicPeakUsageDetails')
	delete from GXDBVersions where aliasname = 'ParseLicPeakUsageDetails'
GO

insert into GXDBVersions values(2, 'ParseLicPeakUsageDetails',  '00010001000200130000', 'ParseLicPeakUsageDetails', '00010001000200130000')
GO

