

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicSCLPeakUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicSCLPeakUsage.sp,v $ $Id: ParseLicSCLPeakUsage.sp,v 1.1.2.16 2020/12/17 02:55:35 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseLicSCLPeakUsage')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicSCLPeakUsage <<<'
	drop procedure ParseLicSCLPeakUsage
END
IF EXISTS (select * from GxQscripts where name='ParseLicSCLPeakUsage')
	delete from GxQscripts where name = 'ParseLicSCLPeakUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicSCLPeakUsage')
	delete from GXDBVersions where aliasname = 'ParseLicSCLPeakUsage'
GO
print '... Creating Procedure: ParseLicSCLPeakUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseLicSCLPeakUsage
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicSCLPeakUsageTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
--do not process billing peak details for non-utility customers
IF NOT EXISTS(	SELECT 1 FROM cf_CommCellGroupAssoc CGA WITH (NOLOCK)
				INNER JOIN cm_ClientGroupToContractMap CGC WITH (NOLOCK) ON CGA.CommCellGroupId=CGC.clientGroupId
				WHERE CGA.CommcellIdNameMap_ID=@CSUniqueId	)
	GOTO EXIT_PROCESSING
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#Lic_SCLPeakUsage') IS NOT NULL
    DROP TABLE #Lic_SCLPeakUsage
CREATE TABLE #Lic_SCLPeakUsage
(
	MonthStart           DATETIME,
    CreationDate         DATETIME,
    UsageType            integer,
    PeakType             integer,
    ClientId             integer,
    ClientName           NVARCHAR(255),
    SubclientId          integer,
	AppTypeId			 integer,
    LicType              integer,
    JobId                integer,
    AppSizeMB            BIGINT,
    CapacityFlag         integer,
    VMFlag               integer,
    ObjectName           NVARCHAR(1024),
    ObjectId             integer,
	OrgGUID              NVARCHAR(40),
	PlanName             NVARCHAR(1024),
	BasePlanName         NVARCHAR(1024)
)
IF OBJECT_ID('tempdb..#ColumnCheck') IS NOT NULL
    DROP TABLE #ColumnCheck
CREATE TABLE #ColumnCheck (rowValue NVARCHAR(MAX))
DECLARE @sql NVARCHAR(256) = ''
DECLARE @columnCount INT = 0
IF 	@ErrorCode = 0
BEGIN
	--first check how many columns are in the csv coming from CS
	--1) if uploaded using SP19 query, it will have 18 columns
	--2) if uploaded using SP16 query, it will have 26 columns
	--3) if uploaded using SP15 query, it will have 25 columns
	SET @sql = 'BULK INSERT #ColumnCheck FROM ''' + @FileName + ''' WITH ( ROWTERMINATOR =''\n'', KEEPNULLS, LASTROW = 1 )';
	EXEC(@sql);
	SELECT @columnCount=count(_ID) FROM dbo.SplitStringByDelimiter((select rowValue from #ColumnCheck),',')
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	IF @columnCount=18
	BEGIN
		--uploaded using latest SP19 queries. Insert them as it is.
		SET @sql = 'BULK INSERT #Lic_SCLPeakUsage FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		SELECT @ErrorCode = @@ERROR
	END
	ELSE IF (@columnCount=25 OR @columnCount=26)
	BEGIN
		IF OBJECT_ID('tempdb..#oldLic_SCLPeakUsage') IS NOT NULL
			DROP TABLE #oldLic_SCLPeakUsage
		CREATE TABLE #oldLic_SCLPeakUsage
		(
			MonthStart           DATETIME,
			CreationDate         DATETIME,
			UsageType            integer,
			PeakType             integer,
			ClientId             integer,
			ClientName           NVARCHAR(255),
			SubclientId          integer,
			SubclientName        NVARCHAR(255),
			AppTypeId            integer,
			LicType              integer,
			BackupSetId          integer,
			BackupSetName        NVARCHAR(1024),
			InstanceId           integer,
			InstanceName         NVARCHAR(1024),
			SPId                 integer,
			SPName               NVARCHAR(1024),
			JobId                integer,
			AppSizeMB            BIGINT,
			CapacityFlag         integer,
			VMFlag               integer,
			ObjectName           NVARCHAR(1024),
			ObjectId             integer,
			Organization         nvarchar(1024),
			OrgGUID              NVARCHAR(40),
			PlanName             NVARCHAR(1024),
			BasePlanName         NVARCHAR(1024)
		)
		IF @columnCount=25
		BEGIN
			--baseplan column will be missing in the csv generated by SP15 survey query. Parsing script will fail during bulk insert in such cases
			--baseline is the 26th column. If it is not present, drop that column from temp table before bulk insert
			ALTER TABLE #oldLic_SCLPeakUsage DROP COLUMN BasePlanName
		END
		SET @sql = 'BULK INSERT #oldLic_SCLPeakUsage FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		SELECT @ErrorCode = @@ERROR
		--re-add the dropped baseplan column for further processing
		IF @columnCount=25
		BEGIN
			ALTER TABLE #oldLic_SCLPeakUsage ADD BasePlanName NVARCHAR(1024)
			UPDATE #oldLic_SCLPeakUsage SET BasePlanName='N/A'
		END
		IF @ErrorCode = 0
		BEGIN
			INSERT #Lic_SCLPeakUsage
			SELECT DISTINCT MonthStart, CreationDate, UsageType, 1, ClientId, ClientName, SubclientId, AppTypeId, LicType,
			JobId, AppSizeMB, CapacityFlag, VMFlag, ObjectName, ObjectId, OrgGUID, PlanName, BasePlanName
			FROM #oldLic_SCLPeakUsage
			SELECT @ErrorCode = @@ERROR
		END
		IF OBJECT_ID('tempdb..#oldLic_SCLPeakUsage') IS NOT NULL DROP TABLE #oldLic_SCLPeakUsage
	END
	ELSE
		GOTO LIC_END
END
IF 	@ErrorCode = 0
BEGIN
	--handle comma in the column values
	UPDATE #Lic_SCLPeakUsage SET
	ClientName = CASE WHEN ClientName IS NOT NULL AND CHARINDEX('<COMMA>', ClientName) > 0 THEN REPLACE (ClientName,'<COMMA>',',')
						ELSE ClientName
					END,
	ObjectName = CASE WHEN ObjectName IS NOT NULL AND CHARINDEX('<COMMA>', ObjectName) > 0 THEN REPLACE (ObjectName,'<COMMA>',',')
					  ELSE ObjectName
					END,
	PlanName = CASE WHEN PlanName IS NOT NULL AND CHARINDEX('<COMMA>', PlanName) > 0 THEN REPLACE (PlanName,'<COMMA>',',')
					   ELSE PlanName
					END,
	OrgGUID = CASE WHEN OrgGUID='NULL' THEN NULL
						ELSE OrgGUID
					END,
	BasePlanName = CASE WHEN BasePlanName IS NOT NULL AND CHARINDEX('<COMMA>', BasePlanName) > 0 THEN REPLACE (BasePlanName,'<COMMA>',',')
					   ELSE BasePlanName
					END
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT 1 FROM #Lic_SCLPeakUsage)
BEGIN
	--insert license types other than hyperscale
	DECLARE @usageType INT = 33
	--for each CommCell, remove existing SCL peak data from the cloud table. Deletion should be done for all the months for which the new data has been uploaded from CS
	DELETE FROM Lic_PeakUsage
	WHERE CommServUniqueId = @CSUniqueId AND PeakType=1 AND UsageType<>@usageType
	AND MonthStart IN (SELECT DISTINCT MonthStart FROM #Lic_SCLPeakUsage)
	--insert newly uploaded SCL peak data into cloud table
	INSERT INTO Lic_PeakUsage (CommServUniqueId, MonthStart, CreationDate, UsageType, PeakType, ClientId, ClientName, SubclientId,
	AppTypeId, LicType, JobId, AppSizeMB, CapacityFlag, VMFlag, ObjectName, ObjectId, OrgGUID, PlanName, BasePlanName)
	SELECT DISTINCT @CSUniqueId, MonthStart, CreationDate, UsageType, 1, ClientId, ClientName, SubclientId,
	AppTypeId, LicType, JobId, AppSizeMB, CapacityFlag, VMFlag, ObjectName, ObjectId, OrgGUID, PlanName, BasePlanName
	FROM #Lic_SCLPeakUsage
	WHERE UsageType<>@usageType
	SELECT @ErrorCode = @@ERROR
	--do special handling for hyperscale
	IF @ErrorCode = 0
	BEGIN
		IF EXISTS (SELECT 1 FROM #Lic_SCLPeakUsage WHERE UsageType=@usageType)
		BEGIN
			--if newly uploaded data has any hyperscale usage, delete existing usage
			DELETE FROM Lic_PeakUsage
			WHERE CommServUniqueId = @CSUniqueId AND PeakType=1 AND UsageType=@usageType
			AND MonthStart IN (SELECT DISTINCT MonthStart FROM #Lic_SCLPeakUsage WHERE UsageType=@usageType)
			--insert new hyperscale usage instead of the deleted rows
			INSERT INTO Lic_PeakUsage (CommServUniqueId, MonthStart, CreationDate, UsageType, PeakType, ClientId, ClientName, SubclientId,
			AppTypeId, LicType, JobId, AppSizeMB, CapacityFlag, VMFlag, ObjectName, ObjectId, OrgGUID, PlanName, BasePlanName)
			SELECT DISTINCT @CSUniqueId, MonthStart, CreationDate, UsageType, 1, ClientId, ClientName, SubclientId,
			AppTypeId, LicType, JobId, AppSizeMB, CapacityFlag, VMFlag, ObjectName, ObjectId, OrgGUID, PlanName, BasePlanName
			FROM #Lic_SCLPeakUsage
			WHERE UsageType=@usageType
			SELECT @ErrorCode = @@ERROR
		END
		ELSE
		BEGIN
			--get hyperscale usage for billing for the current month from query117, if it is not present in Lic_PeakUsage table
			DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
			DECLARE @peakType INT = 1
			DECLARE @capacityFlag INT = 117 --to identify this row is inserted from results of surveyQuery 117
			--if already usage was uploaded by licensing query238, do not insert from query117
			IF NOT EXISTS (SELECT 1 FROM Lic_PeakUsage WITH (NOLOCK) WHERE UsageType=@usageType AND PeakType=@peakType AND MonthStart=@monthStart AND CommServUniqueId=@CSUniqueId AND CapacityFlag<>117)
			BEGIN
				MERGE Lic_PeakUsage AS T
				USING
				(
					SELECT R.CommServUniqueId,PL.StoragePoolId,PL.StoragePoolName,M.TotalSpaceMB,(M.TotalSpaceMB-M.FreeSpaceMB) AS UsedSpaceMB,PL.ApplianceType,R.SurverResultId AS SurveyResultId
					FROM cf_SurveyStoragePoolSummary AS PL WITH (NOLOCK)
					INNER JOIN dbo.cf_SurveyResultFuncV1(117, @CSUniqueId, 1, NULL, NULL, 1, -1) R ON PL.SurveyResultId = R.SurverResultId
					INNER JOIN cf_SurveyMountPathSummary M ON PL.SurveyResultId = M.SurveyResultId AND M.LibraryId IN (SELECT * FROM dbo.SplitIDs(PL.LibraryIds))
					WHERE PL.StoragePoolType = 4
				) AS S
				ON T.CommServUniqueId=@CSUniqueId AND T.MonthStart = @monthStart AND T.UsageType = @usageType AND T.PeakType = @peakType AND T.ClientId = S.StoragePoolId AND T.VMFlag = S.ApplianceType AND T.CapacityFlag = @capacityFlag
				WHEN MATCHED AND T.AppSizeMB <= S.UsedSpaceMB
					THEN UPDATE
						SET T.CreationDate=GETUTCDATE(), T.ClientId=S.StoragePoolId, T.ClientName=S.StoragePoolName,
						T.AppSizeMB=S.UsedSpaceMB, T.ObjectId=S.SurveyResultId, T.ObjectName=CONVERT(NVARCHAR(1024),ISNULL(S.TotalSpaceMB,-1))
				WHEN NOT MATCHED BY TARGET
					THEN INSERT (CommServUniqueId,MonthStart,CreationDate,UsageType,PeakType,ClientId,ClientName,AppSizeMB,CapacityFlag,VMFlag,ObjectId,ObjectName)
						VALUES(@CSUniqueId,@monthStart,GETUTCDATE(),@usageType,@peakType,S.StoragePoolId,S.StoragePoolName,S.UsedSpaceMB,@capacityFlag,S.ApplianceType,S.SurveyResultId,CONVERT(NVARCHAR(1024),ISNULL(S.TotalSpaceMB,-1)))
				;
			END
			SELECT @ErrorCode = @@ERROR
		END
	END
END
LIC_END:
IF OBJECT_ID('tempdb..#Lic_SCLPeakUsage') IS NOT NULL DROP TABLE #Lic_SCLPeakUsage
IF OBJECT_ID('tempdb..#ColumnCheck') IS NOT NULL DROP TABLE #ColumnCheck
EXIT_PROCESSING:
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicSCLPeakUsageTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicSCLPeakUsage')
	delete from GxQscripts where name = 'ParseLicSCLPeakUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicSCLPeakUsage')
	delete from GXDBVersions where aliasname = 'ParseLicSCLPeakUsage'
GO

insert into GXDBVersions values(2, 'ParseLicSCLPeakUsage',  '00010001000200160000', 'ParseLicSCLPeakUsage', '00010001000200160000')
GO

