

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMonthlyStorageUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMonthlyStorageUsage.sp,v $ $Id: ParseMonthlyStorageUsage.sp,v 1.10.12.7 2020/12/17 02:51:11 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseMonthlyStorageUsage')
BEGIN
	print '>>> Drop Stored Procedure: ParseMonthlyStorageUsage <<<'
	drop procedure ParseMonthlyStorageUsage
END
IF EXISTS (select * from GxQscripts where name='ParseMonthlyStorageUsage')
	delete from GxQscripts where name = 'ParseMonthlyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMonthlyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseMonthlyStorageUsage'
GO
print '... Creating Procedure: ParseMonthlyStorageUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseMonthlyStorageUsage
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseMonthlyStorageUsageTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #MonthlyChargeback
(
	CommservUniqueId	INT,
	SurveyResultId		BIGINT,
	StartDate			DATETIME,
	Type				TINYINT,
	ClientId			INT,
	AppId				INT,
	CopyId				INT,
	FrontEndSize		BIGINT,
	DataProtected		BIGINT,
	DataWritten			BIGINT,
	TotalProtectedApp	BIGINT,
	TotalDataOnMedia	BIGINT,
	FrontEndSizeType	INT NULL
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MonthlyChargeback (
		CommservUniqueId, SurveyResultId, StartDate, Type, ClientId, AppId, CopyId,
		FrontEndSize, DataProtected, DataWritten, TotalProtectedApp, TotalDataOnMedia, FrontEndSizeType)
	SELECT
		@CSUniqueId,
		@ResultId,
		ISNULL(csInfo.n.value('@StartDate','DATETIME'), csInfo.n.value('@Month','DATETIME')),
		ISNULL(csInfo.n.value('@Type','INT'), 1),
		csInfo.n.value('@ClientId','INT'),
		csInfo.n.value('@AppId','INT'),
		csInfo.n.value('@CopyId','INT'),
		csInfo.n.value('@FrontEndSize','BIGINT'),
		csInfo.n.value('@DataProtected','BIGINT'),
		csInfo.n.value('@DataWritten','BIGINT'),
		ISNULL(csInfo.n.value('@TotalProtectedApp','BIGINT'), 0),
		ISNULL(csInfo.n.value('@TotalDataOnMedia','BIGINT'), 0),
		csInfo.n.value('@FrontEndSizeType','INT')
	FROM
		@ResultXml.nodes('MonthlyStorageUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyMonthlyChargeback (
			CommservUniqueId, SurveyResultId, StartDate, Type, ClientId, AppId, CopyId,
			FrontEndSize, DataProtected, DataWritten, TotalProtectedApp, TotalDataOnMedia, FrontEndSizeType)
	SELECT	CommservUniqueId, SurveyResultId, StartDate, Type, ClientId, AppId, CopyId,
			FrontEndSize, DataProtected, DataWritten, TotalProtectedApp, TotalDataOnMedia, FrontEndSizeType
	FROM	#MonthlyChargeback
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT * FROM cf_SurveyMonthlyChargeback WHERE SurveyResultId = @ResultId AND FrontEndSizeType IS NULL)
BEGIN
	UPDATE cf_SurveyMonthlyChargeback
	SET    FrontEndSizeType = CASE WHEN S.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90,124) THEN 1 ELSE 0 END
	FROM   cf_SurveyMonthlyChargeback M INNER JOIN cf_SurveySubclientAssociation S
		ON M.CommservUniqueId = S.CommservUniqueId AND M.appId = S.AppId
		AND M.SurveyResultId = @ResultId AND M.FrontEndSizeType IS NULL
	SELECT @ErrorCode = @@ERROR
	IF 	@ErrorCode = 0
	BEGIN
		UPDATE cf_SurveyMonthlyChargeback
		SET    FrontEndSizeType = 0
		WHERE  SurveyResultId = @ResultId AND FrontEndSizeType IS NULL
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseMonthlyStorageUsageTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMonthlyStorageUsage')
	delete from GxQscripts where name = 'ParseMonthlyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMonthlyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseMonthlyStorageUsage'
GO

insert into GXDBVersions values(2, 'ParseMonthlyStorageUsage',  '00010010001200070000', 'ParseMonthlyStorageUsage', '00010010001200070000')
GO

