

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseRecoverabilitySLA.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseRecoverabilitySLA.sp,v $ $Id: ParseRecoverabilitySLA.sp,v 1.1.2.11 2020/12/17 02:49:08 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseRecoverabilitySLA')
BEGIN
	print '>>> Drop Stored Procedure: ParseRecoverabilitySLA <<<'
	drop procedure ParseRecoverabilitySLA
END
IF EXISTS (select * from GxQscripts where name='ParseRecoverabilitySLA')
	delete from GxQscripts where name = 'ParseRecoverabilitySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRecoverabilitySLA')
	delete from GXDBVersions where aliasname = 'ParseRecoverabilitySLA'
GO
print '... Creating Procedure: ParseRecoverabilitySLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseRecoverabilitySLA
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseRecoverabilitySLATran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF OBJECT_ID('tempdb..#RecoverabilitySLA') IS NOT NULL
	DROP TABLE #RecoverabilitySLA
CREATE TABLE #RecoverabilitySLA
(
--	SurveyResultId		BIGINT,
	ClientId			INT NOT NULL,
	AppId				INT NOT NULL,
	LastJobId			INT NULL,
	OpType				INT NULL,
	LastJobStart		DATETIME NULL,
	nAuxCopies			INT NULL,
	DaysBehind			INT NULL,
	AppSizeMB			BIGINT NULL,
	RstThruputMbps		FLOAT NULL,
	TapeExported		INT NULL,
	CopyRedundancy		INT NULL,
	MinRedundancy		INT NULL,
	CopyBehindDays		INT NULL,
	MaxBehindDays		INT NULL,
	RPOMinutes			INT NULL,
	RPAMinutes			INT NULL,
	RTOMinutes			INT NULL,
	RTAMinutes			INT NULL,
	RTASizeMB			BIGINT NULL,
	ClientSLACategory	INT NULL,
	AsOfDate			DATETIME NULL
)
IF OBJECT_ID('tempdb..#ClientGroupSLAHistory') IS NOT NULL
	DROP TABLE #ClientGroupSLAHistory
CREATE TABLE #ClientGroupSLAHistory
(
	CommservUniqueId	INT NOT NULL,
	ClientGroupId		INT NOT NULL,
	AsOfDate			DATETIME NOT NULL,
	TotalClients		INT	NOT NULL,
	MetBackupSLAClients	INT	NOT NULL,
	MetRecoverabilitySLAClients	INT	NOT NULL,
	MetCopyRedundancySLAClients	INT	NOT NULL
)
IF OBJECT_ID('tempdb..#RecoverabilitySLAClient') IS NOT NULL DROP TABLE #RecoverabilitySLAClient
CREATE TABLE #RecoverabilitySLAClient (ClientId INT, Flags INT)
IF OBJECT_ID('tempdb..#ClientGroupAssociation') IS NOT NULL DROP TABLE #ClientGroupAssociation
CREATE TABLE #ClientGroupAssociation (ClientId INT, ClientGroupId INT)
DECLARE @FileName NVARCHAR(1024)
IF 	@ErrorCode = 0
BEGIN
	SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
	FROM	cf_CommservSurveyResults WITH (NOLOCK)
	WHERE 	CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #RecoverabilitySLA FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
DECLARE @AsOfDate DATETIME = NULL
DECLARE @TotalClients INT = 0
DECLARE @ClientsMetBackupSLA INT = 0
DECLARE @ClientsMetRecoverabilitySLA INT = 0
DECLARE @ClientsMetCopyRedundancySLA INT = 0
IF  @ErrorCode = 0 AND EXISTS (SELECT TOP 1 0 FROM #RecoverabilitySLA)
BEGIN
	SET @AsOfDate = ISNULL((SELECT TOP 1 AsOfDate FROM #RecoverabilitySLA), @LogDate)
	INSERT	INTO #RecoverabilitySLAClient
	SELECT	ClientId,
			MIN(CASE WHEN ClientSLACategory = 1 THEN 1 ELSE 0 END)
			+ MIN(CASE WHEN RTAMinutes <= RTOMinutes THEN 2 ELSE 0 END)
			+ MIN(CASE WHEN MinRedundancy >= CopyRedundancy AND MaxBehindDays <= CopyBehindDays THEN 4 ELSE 0 END)
	FROM	#RecoverabilitySLA
	GROUP BY ClientId
	SELECT @ErrorCode = @@ERROR, @TotalClients = @@ROWCOUNT
END
IF  @ErrorCode = 0 AND @TotalClients > 0
BEGIN
	CREATE CLUSTERED INDEX #RecoverabilitySLAClient_Flags_ClientId_idx ON #RecoverabilitySLAClient (Flags, ClientId)
	SET @ClientsMetBackupSLA         = (SELECT COUNT(ClientId) FROM #RecoverabilitySLAClient WHERE Flags&1 = 1)
	SET @ClientsMetRecoverabilitySLA = (SELECT COUNT(ClientId) FROM #RecoverabilitySLAClient WHERE Flags&3 = 3)
	SET @ClientsMetCopyRedundancySLA = (SELECT COUNT(ClientId) FROM #RecoverabilitySLAClient WHERE Flags&5 = 5)
	INSERT	INTO #ClientGroupSLAHistory (CommservUniqueId, ClientGroupId, AsOfDate,
			TotalClients, MetBackupSLAClients, MetRecoverabilitySLAClients, MetCopyRedundancySLAClients)
	SELECT	@CSUniqueId, 0, @AsOfDate,
			@TotalClients, @ClientsMetBackupSLA, @ClientsMetRecoverabilitySLA, @ClientsMetCopyRedundancySLA
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0 AND @TotalClients > 0
BEGIN
	INSERT	INTO #ClientGroupAssociation (ClientId, ClientGroupId)
	SELECT	ClientId, ClientGroupId
	FROM	cf_SurveyClientGroupAssociation WITH (NOLOCK)
	WHERE	CommservUniqueId = @CSUniqueId AND DeletedDate IS NULL
	SELECT @ErrorCode = @@ERROR
	CREATE CLUSTERED INDEX #ClientGroupAssociation_ClientId_ClientGroupId_idx ON #ClientGroupAssociation (ClientId, ClientGroupId)
END
IF  @ErrorCode = 0 AND @TotalClients > 0
BEGIN
	INSERT	INTO #ClientGroupSLAHistory (CommservUniqueId, ClientGroupId, AsOfDate,
			TotalClients, MetBackupSLAClients, MetRecoverabilitySLAClients, MetCopyRedundancySLAClients)
	SELECT	@CSUniqueId, S.ClientGroupId, @AsOfDate,
			COUNT(S.ClientId), SUM(R.Flags&1), SUM((R.Flags&3)/3), SUM((R.Flags&5)/5)
	FROM	#RecoverabilitySLAClient R
			INNER JOIN #ClientGroupAssociation S ON S.ClientId = R.ClientId
	GROUP BY S.ClientGroupId
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0 AND EXISTS (SELECT TOP 1 0 FROM #RecoverabilitySLA)
BEGIN
	INSERT INTO cf_SurveyRecoverabilitySLA (
			SurveyResultId, ClientId, AppId, LastJobId, OpType, LastJobStart, nAuxCopies, DaysBehind, AppSizeMB, RstThruputMbps, TapeExported,
			CopyRedundancy, MinRedundancy, CopyBehindDays, MaxBehindDays, RPOMinutes, RPAMinutes, RTOMinutes, RTAMinutes, RTASizeMB, ClientSLACategory, AsOfDate)
	SELECT	@ResultId, ClientId, AppId, LastJobId, OpType, LastJobStart, nAuxCopies, DaysBehind, AppSizeMB, RstThruputMbps, TapeExported,
			CopyRedundancy, MinRedundancy, CopyBehindDays, MaxBehindDays, RPOMinutes, RPAMinutes, RTOMinutes, RTAMinutes, RTASizeMB, ClientSLACategory, AsOfDate
	FROM	#RecoverabilitySLA
	SELECT @ErrorCode = @@ERROR
END
SET @AsOfDate = CAST(@AsOfDate AS DATE)
IF  @ErrorCode = 0 AND EXISTS (SELECT TOP 1 0 FROM #ClientGroupSLAHistory)
BEGIN
	DELETE	cf_SurveyClientGroupSLAHistory
	WHERE	CommservUniqueId = @CSUniqueId AND AsOfDate >= @AsOfDate
	INSERT	INTO cf_SurveyClientGroupSLAHistory (
			CommservUniqueId, ClientGroupId, AsOfDate, TotalClients, MetBackupSLAClients, MetRecoverabilitySLAClients, MetCopyRedundancySLAClients)
	SELECT	CommservUniqueId, ClientGroupId, AsOfDate, TotalClients, MetBackupSLAClients, MetRecoverabilitySLAClients, MetCopyRedundancySLAClients
	FROM	#ClientGroupSLAHistory
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseRecoverabilitySLATran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseRecoverabilitySLA')
	delete from GxQscripts where name = 'ParseRecoverabilitySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRecoverabilitySLA')
	delete from GXDBVersions where aliasname = 'ParseRecoverabilitySLA'
GO

insert into GXDBVersions values(2, 'ParseRecoverabilitySLA',  '00010001000200110000', 'ParseRecoverabilitySLA', '00010001000200110000')
GO

