

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseRestoreJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseRestoreJobDetails.sp,v $ $Id: ParseRestoreJobDetails.sp,v 1.4.42.10 2020/12/17 02:55:56 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseRestoreJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: ParseRestoreJobDetails <<<'
	drop procedure ParseRestoreJobDetails
END
IF EXISTS (select * from GxQscripts where name='ParseRestoreJobDetails')
	delete from GxQscripts where name = 'ParseRestoreJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRestoreJobDetails')
	delete from GXDBVersions where aliasname = 'ParseRestoreJobDetails'
GO
print '... Creating Procedure: ParseRestoreJobDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseRestoreJobDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseRestoreJobDetailsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @CSTimeDiff BIGINT = (SELECT DATEDIFF(S, GETUTCDATE(), dbo.UTCToLocalDateTimeConversion(GETUTCDATE(), C.CommServTZ)) FROM cf_CommcellIdNameMap C WITH (NOLOCK) WHERE ID = @CSUniqueId)
IF 	@ErrorCode = 0
BEGIN
IF object_id('tempdb.dbo.#SurveyRestJobDetails') is not null DROP TABLE #SurveyRestJobDetails
	create table #SurveyRestJobDetails (
		CommservUniqueId INT,
		Jobid INT,
		JobStatus INT,
		SrcClientId INT,
		SrcClientName NVARCHAR(512),
		DestClientId INT,
		DestClientName NVARCHAR(512),
		AppTypeId INT,
		AppType NVARCHAR(512),
		InstanceId INT,
		Instance NVARCHAR(512),
		BkpsetId INT,
		Bkpset NVARCHAR(512),
		StartTime INT,
		EndTime INT,
		Duration INT,
		TotFiles2xfer BIGINT,
		TotSuccess BIGINT,
		SkippedObjects BIGINT,
		FailedObjects BIGINT,
		TotCompMB BIGINT,
		TotUnCompMB BIGINT,
		ErrorCode VARCHAR(32),
		FailedReason NVARCHAR(512),
		UserName NVARCHAR(255),
		JobDescription	NVARCHAR(MAX),
		SrcPhysicalClientName NVARCHAR(512),
		DestPhysicalClientName NVARCHAR(512),
		BackupTime DATETIME,
		OpType INT,
		SubOpType INT,
		RstAttributes BIGINT,
		InitFrom INT,
		inCSTimeZone INT
	)
IF object_id('tempdb.dbo.#tmpFailureClients') is not null DROP TABLE #tmpFailureClients
	CREATE TABLE #tmpFailureClients(
		CommServUniqueId		INT NOT NULL,
		MonthStart				DATETIME NOT NULL,
		SrcClientId             INT,
		AppTypeID				INT NOT NULL,
		Status                  INT,
		JobCount 				INT NULL,
		ErrorCode               NVARCHAR(32),
		FailureReason           NVARCHAR(512)
	)
IF object_id('tempdb.dbo.#tmpClientsErrors') is not null DROP TABLE #tmpClientsErrors
	CREATE TABLE #tmpClientsErrors(
		CommservUniqueId INT,
		MonthStart DATETIME,
		SrcClientId INT,
		AppTypeId INT,
		JobStatus INT,
		ErrorCode NVARCHAR(32),
		FailureReason NVARCHAR(512)
	)
IF object_id('tempdb.dbo.#tmpDailyJobs') is not null DROP TABLE #tmpDailyJobs
	CREATE TABLE #tmpDailyJobs(
		CommServUniqueId		 INT,
		JobEndDate				DATETIME,
		AppTypeId				INT,
		TotalJobs				INT NULL,
		CompletedJobs			INT NULL,
		CWEJobs					INT NULL,
		CWWJobs					INT NULL,
		FailedJobs				INT NULL,
		KilledJobs				INT NULL,
		SkippedJobs				INT NULL,
		TotCompMB				BIGINT,
		TotUnCompMB				BIGINT,
		CommittedJobs			INT NULL,
		TotFiles2xfer			BIGINT,
		TotSuccess				BIGINT,
		SkippedObjects			BIGINT,
		FailedObjects			BIGINT
	)
IF object_id('tempdb.dbo.#tmpAggregateJobs') is not null DROP TABLE #tmpAggregateJobs
	CREATE TABLE #tmpAggregateJobs
	(
		CommServUniqueId		INT,
		MonthStart				DATETIME,
		AppTypeId				INT,
		TotalJobs				INT NULL,
		CompletedJobs			INT NULL,
		CWEJobs					INT NULL,
		CWWJobs					INT NULL,
		FailedJobs				INT NULL,
		KilledJobs				INT NULL,
		SkippedJobs				INT NULL,
		TotCompMB				BIGINT,
		TotUnCompMB				BIGINT,
		CommittedJobs			INT NULL,
		TotFiles2xfer			BIGINT,
		TotSuccess				BIGINT,
		SkippedObjects			BIGINT,
		FailedObjects			BIGINT
	)
	INSERT INTO #SurveyRestJobDetails (
		CommservUniqueId,
		Jobid,
		JobStatus,
		SrcClientId,
		SrcClientName,
		DestClientId,
		DestClientName,
		AppTypeId,
		AppType,
		InstanceId,
		Instance,
		BkpsetId,
		Bkpset,
		StartTime,
		EndTime,
		Duration,
		TotFiles2xfer,
		TotSuccess,
		SkippedObjects,
		FailedObjects,
		TotCompMB,
		TotUnCompMB,
		ErrorCode,
		FailedReason,
		UserName,
		JobDescription,
		SrcPhysicalClientName,
		DestPhysicalClientName,
		BackupTime,
		OpType,
		SubOpType,
		RstAttributes,
		InitFrom,
		inCSTimeZone
		)
	SELECT DISTINCT
		results.CommcellIdNameMap_ID,
		csInfo.n.value('@Jobid', 'INT'),
		csInfo.n.value('@JobStatus', 'INT'),
		csInfo.n.value('@SrcClientId', 'INT'),
		csInfo.n.value('@SrcClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@DestClientId', 'INT'),
		csInfo.n.value('@DestClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@AppTypeId', 'INT'),
		csInfo.n.value('@AppType', 'NVARCHAR(512)'),
		csInfo.n.value('@InstanceId', 'INT'),
		csInfo.n.value('@Instance', 'NVARCHAR(512)'),
		csInfo.n.value('@BkpsetId', 'BIGINT'),
		csInfo.n.value('@Bkpset', 'NVARCHAR(512)'),
		csInfo.n.value('@StartTime', 'INT'),
		csInfo.n.value('@EndTime', 'INT'),
		csInfo.n.value('@Duration', 'INT'),
		csInfo.n.value('@TotFiles2xfer', 'BIGINT'),
		csInfo.n.value('@TotSuccess', 'BIGINT'),
		csInfo.n.value('@SkippedObjects', 'BIGINT'),
		csInfo.n.value('@FailedObjects', 'BIGINT'),
		csInfo.n.value('@TotCompMB', 'BIGINT'),
		csInfo.n.value('@TotUnCompMB', 'BIGINT'),
		csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
		csInfo.n.value('@FailedReason', 'NVARCHAR(512)'),
		csInfo.n.value('@UserName', 'NVARCHAR(255)'),
		csInfo.n.value('@JobDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@SrcPhysicalClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@DestPhysicalClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@BackupTime', 'DATETIME'),
		csInfo.n.value('@OpType', 'INT'),
		csInfo.n.value('@SubOpType', 'INT'),
		csInfo.n.value('@RstAttributes', 'BIGINT'),
		csInfo.n.value('@InitFrom', 'INT'),
		ISNULL(csInfo.n.value('@inCSTimeZone', 'INT'), 0)
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/RestoreJobStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
		UPDATE #SurveyRestJobDetails
		SET StartTime = startTime + @CSTimeDiff,
			EndTime = EndTime + @CSTimeDiff
		WHERE inCSTimeZone = 0
END
IF 	@ErrorCode = 0
BEGIN
	DELETE  #SurveyRestJobDetails
	FROM	cf_SurveyRestoreJobStats S
	WHERE	#SurveyRestJobDetails.CommservUniqueId = S.CommservUniqueId AND #SurveyRestJobDetails.JobId = S.JobId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyRestoreJobStats (
		CommservUniqueId,
		Jobid,
		JobStatus,
		SrcClientId,
		SrcClientName,
		DestClientId,
		DestClientName,
		AppTypeId,
		AppType,
		InstanceId,
		Instance,
		BkpsetId,
		Bkpset,
		StartTime,
		EndTime,
		Duration,
		TotFiles2xfer,
		TotSuccess,
		SkippedObjects,
		FailedObjects,
		TotCompMB,
		TotUnCompMB,
		ErrorCode,
		FailedReason,
		UserName,
		JobDescription,
		SrcPhysicalClientName,
		DestPhysicalClientName,
		BackupTime,
		OpType,
		SubOpType,
		RstAttributes,
		InitFrom
		)
	SELECT
		CommservUniqueId,
		Jobid,
		JobStatus,
		SrcClientId,
		SrcClientName,
		DestClientId,
		DestClientName,
		AppTypeId,
		AppType,
		InstanceId,
		Instance,
		BkpsetId,
		Bkpset,
		StartTime,
		EndTime,
		Duration,
		TotFiles2xfer,
		TotSuccess,
		SkippedObjects,
		FailedObjects,
		TotCompMB,
		TotUnCompMB,
		ErrorCode,
		FailedReason,
		UserName,
		JobDescription,
		SrcPhysicalClientName,
		DestPhysicalClientName,
		BackupTime,
		OpType,
		SubOpType,
		RstAttributes,
		InitFrom
	FROM	#SurveyRestJobDetails
	SELECT @ErrorCode = @@ERROR
END
DECLARE @LastDate DATETIME
DECLARE @LastDay  DATETIME
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NoLOCK) WHERE Name = 'isPrivate'
IF(@isPrivate = 0)
BEGIN
	IF 	@ErrorCode = 0
	BEGIN
		SET @LastDate =  ISNULL((SELECT MAX(JobEndDate) FROM cf_SurveyIDADailyRSTJobStats WITH (NOLOCK) where CommServUniqueId = @CSUniqueId),0)
		SET @LastDay  =  ISNULL((SELECT MAX(MonthStart) FROM cf_SurveyIDAMonthlyRSTJobFailurePerClient WITH (NOLOCK) where CommServUniqueId = @CSUniqueId),0)
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO #tmpDailyJobs(CommServUniqueId, JobEndDate, AppTypeId, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotUnCompMB, TotCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)
		SELECT  B.CommservUniqueId ,
				CAST(DBO.GETDATETIME(B.EndTime) AS DATE),
				B.AppTypeId as AppTypeId,
				SUM(CASE WHEN (B.jobstatus) IN (1,2,3,4,9,14,16) THEN 1 ELSE 0 END) as TotalJobs,
				SUM(CASE WHEN B.jobstatus = 1  THEN 1 ELSE 0 END) AS CompletedJobs,
				SUM(CASE WHEN B.jobstatus = 3  THEN 1 ELSE 0 END) as CWEJobs,
				SUM(CASE WHEN B.jobstatus = 14 THEN 1 ELSE 0 END) as CWWJobs,
				SUM(CASE WHEN B.jobstatus = 2  OR (B.jobstatus = 9 AND B.errorcode = '8') THEN 1 ELSE 0 END) as FailedJobs,
				SUM(CASE WHEN B.jobstatus = 4 THEN 1 ELSE 0 END) as KilledJobs,
				SUM(CASE WHEN (B.jobstatus = 9 AND B.errorcode <> '8') THEN 1 ELSE 0 END) as SkippedJobs,
				SUM(CASE WHEN B.jobstatus IN (1,3,14) THEN TotUnCompMB ELSE 0 END) AS TotUnCompMB,
				SUM(TotCompMB) AS TotCompMB,
				SUM(CASE WHEN B.jobstatus = 16 THEN 1 ELSE 0 END) as CommittedJobs,
				SUM(TotFiles2xfer) AS TotFiles2xfer,
				SUM(TotSuccess) AS TotSuccess,
				SUM(SkippedObjects) AS SkippedObjects,
				SUM(FailedObjects) AS FailedObjects
			FROM
				 cf_SurveyRestoreJobStats B WITH (NOLOCK)
				WHERE CAST(DBO.GETDATETIME(ENDTIME) AS DATE) >= @LastDate AND @CSUniqueId =B.CommservUniqueId
				GROUP BY CAST(DBO.GETDATETIME(ENDTIME) AS DATE),B.CommservUniqueId,B.AppTypeId
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		DELETE T
		FROM	#tmpDailyJobs T INNER JOIN cf_SurveyIDADailyRSTJobStats S
			ON T.CommServUniqueId = S.CommServUniqueId AND T.JobEndDate = S.JobEndDate AND T.AppTypeID = S.AppTypeID
		WHERE	T.JobEndDate = @LastDate AND T.TotalJobs<=S.TotalJobs
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		UPDATE	T
		SET		TotalJobs -= S.TotalJobs, CompletedJobs -= S.CompletedJobs, CWEJobs -= S.CWEJobs, CWWJobs -= S.CWWJobs,
				FailedJobs -= S.FailedJobs, KilledJobs -= S.KilledJobs, SkippedJobs -= S.SkippedJobs, CommittedJobs -= S.CommittedJobs, TotCompMB -= S.TotCompMB, TotUnCompMB -= S.TotUnCompMB,
				TotFiles2xfer -= S.TotFiles2xfer, TotSuccess -= S.TotSuccess, SkippedObjects -= S.SkippedObjects, FailedObjects -= S.FailedObjects
		FROM	#tmpDailyJobs T INNER JOIN cf_SurveyIDADailyRSTJobStats S
			ON T.CommServUniqueId = S.CommServUniqueId AND T.JobEndDate = S.JobEndDate AND T.AppTypeID = S.AppTypeID
		WHERE	T.JobEndDate = @LastDate
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		MERGE cf_SurveyIDADailyRSTJobStats AS T
			USING #tmpDailyJobs S
				ON T.CommServUniqueId = S.CommServUniqueId AND T.JobEndDate = S.JobEndDate AND T.AppTypeID = S.AppTypeID and S.JobEndDate>= @LastDate
			WHEN MATCHED THEN
				UPDATE SET TotalJobs += S.TotalJobs, CompletedJobs += S.CompletedJobs, CWEJobs += S.CWEJobs, CWWJobs += S.CWWJobs,
					FailedJobs += S.FailedJobs, KilledJobs += S.KilledJobs, SkippedJobs += S.SkippedJobs, CommittedJobs += S.CommittedJobs, TotCompMB += S.TotCompMB, TotUnCompMB += S.TotUnCompMB,
					TotFiles2xfer += S.TotFiles2xfer, TotSuccess += S.TotSuccess, SkippedObjects += S.SkippedObjects, FailedObjects += S.FailedObjects
			WHEN NOT MATCHED AND S.TotalJobs > 0 THEN
				INSERT (CommServUniqueId, JobEndDate, AppTypeId, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotCompMB, TotUnCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)
				VALUES (S.CommServUniqueId, S.JobEndDate,S.AppTypeID , S.TotalJobs, S.CompletedJobs, S.CWEJobs, S.CWWJobs, S.FailedJobs, S.KilledJobs, S.SkippedJobs, S.TotCompMB, S.TotUnCompMB, S.CommittedJobs,S.TotFiles2xfer,S.TotSuccess,S.SkippedObjects,S.FailedObjects);
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO #tmpAggregateJobs (CommServUniqueId, MonthStart, AppTypeId,TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotCompMB, TotUnCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)
		SELECT  CommServUniqueId, CAST( DATEADD(MONTH, DATEDIFF(MONTH, 0, JobEndDate), 0) AS DATE),  AppTypeId,
				SUM(TotalJobs), SUM(CompletedJobs), SUM(CWEJobs), SUM(CWWJobs), SUM(FailedJobs), SUM(KilledJobs), SUM(SkippedJobs), SUM(TotCompMB), SUM(TotUnCompMB), SUM(CommittedJobs),SUM(TotFiles2xfer),SUM(TotSuccess),SUM(SkippedObjects),SUM(FailedObjects)
		FROM    #tmpDailyJobs
		GROUP BY CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, JobEndDate), 0), AppTypeId
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		MERGE cf_SurveyIDAMonthlyRSTJobStats AS T
		USING #tmpAggregateJobs S
			ON T.CommServUniqueId = S.CommServUniqueId AND T.MonthStart = S.MonthStart  AND T.AppTypeID = S.AppTypeID
		WHEN MATCHED THEN
			UPDATE SET TotalJobs += S.TotalJobs, CompletedJobs += S.CompletedJobs, CWEJobs += S.CWEJobs, CWWJobs += S.CWWJobs,
				FailedJobs += S.FailedJobs, KilledJobs += S.KilledJobs, SkippedJobs += S.SkippedJobs, TotCompMB += S.TotCompMB, TotUnCompMB += S.TotUnCompMB, CommittedJobs += S.CommittedJobs,
				TotFiles2xfer += S.TotFiles2xfer, TotSuccess += S.TotSuccess, SkippedObjects += S.SkippedObjects, FailedObjects += S.FailedObjects
		WHEN NOT MATCHED AND (S.TotalJobs > 0) THEN
			INSERT (CommServUniqueId, MonthStart, TotalJobs,AppTypeId, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotCompMB, TotUnCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)
			VALUES (S.CommServUniqueId, S.MonthStart,S.TotalJobs, S.AppTypeID ,S.CompletedJobs, S.CWEJobs, S.CWWJobs, S.FailedJobs, S.KilledJobs, S.SkippedJobs, S.TotCompMB, S.TotUnCompMB, S.CommittedJobs,S.TotFiles2xfer,S.TotSuccess,S.SkippedObjects,S.FailedObjects);
		SELECT @ErrorCode = @@ERROR
	END
	IF @ErrorCode = 0
	BEGIN
		INSERT INTO #tmpFailureClients
		SELECT T.CommservUniqueId, T.MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, T.JobCount, '', ''
		FROM (
			SELECT T.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(T.EndTime)), 0) AS DATE) AS MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, COUNT(T.jobid) AS JobCount,
			ROW_NUMBER() OVER (PARTITION BY T.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(T.EndTime)), 0) AS DATE), T.JobStatus ORDER BY COUNT(T.jobid) DESC) as rn
			FROM cf_SurveyRestoreJobStats as T WITH (NOLOCK)
			WHERE T.JobStatus in (2,4) AND CAST(DBO.GETDATETIME(T.ENDTIME) AS DATE) >= @LastDay AND @CSUniqueId = T.CommservUniqueId
			GROUP BY T.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(T.EndTime)), 0) AS DATE), T.SrcClientId, T.AppTypeId, T.JobStatus
		) as T
		WHERE T.rn <= 5
		UPDATE	T
		SET	JobCount -= S.JobCount
		FROM	#tmpFailureClients T INNER JOIN cf_SurveyIDAMonthlyRSTJobFailurePerClient S
			ON T.CommServUniqueId = S.CommServUniqueId AND T.MonthStart = S.MonthStart AND T.SrcClientId = S.SrcClientId AND T.Status = S.Status AND T.AppTypeID = S.AppTypeID
		WHERE	T.MonthStart = @LastDay
		INSERT INTO #tmpClientsErrors
		SELECT T.CommservUniqueId, T.MonthStart, T.SrcClientId, T.AppTypeId, T.JobStatus, T.ErrorCode, T.FailureReason
		FROM (
		SELECT R.CommservUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, dbo.GETDATETIME(R.EndTime)), 0) AS MonthStart,
				   COUNT(jobid) AS JobCount,
				   jobstatus,
				   SrcClientId,
				   AppTypeId,
				   errorcode,
				   MAX(FailedReason) AS FailureReason,
				   ROW_NUMBER() OVER (PARTITION BY R.CommservUniqueId, CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(R.EndTime)), 0) AS DATE), R.SrcClientId, R.errorcode, R.JobStatus ORDER BY COUNT(R.jobid) DESC) as rn
			FROM cf_SurveyRestoreJobStats R WITH (NOLOCK)
				INNER JOIN cf_CommcellIdNameMap CC WITH (NOLOCK) ON R.CommServUniqueId = CC.id AND R.JobStatus IN (2,4)
			WHERE CAST(DBO.GETDATETIME(R.ENDTIME) AS DATE) >= @LastDay AND @CSUniqueId = R.CommservUniqueId
			GROUP BY R.CommservUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, dbo.GETDATETIME(R.EndTime)), 0) , SrcClientId, AppTypeId, jobstatus, errorcode
			having len(errorcode)>0 ) as T
			WHERE T.rn <= 1
		UPDATE #tmpFailureClients
		SET #tmpFailureClients.ErrorCode = T.ErrorCode, #tmpFailureClients.FailureReason = T.FailureReason
		FROM #tmpClientsErrors T
		WHERE T.CommservUniqueId = #tmpFailureClients.CommservUniqueId AND T.MonthStart = #tmpFailureClients.MonthStart AND T.SrcClientId = #tmpFailureClients.SrcClientId AND T.AppTypeId = #tmpFailureClients.AppTypeId AND T.JobStatus = #tmpFailureClients.Status
		SELECT @ErrorCode = @@ERROR
	END
	IF @ErrorCode = 0
	BEGIN
		MERGE cf_SurveyIDAMonthlyRSTJobFailurePerClient AS T
			USING #tmpFailureClients S
				ON T.CommServUniqueId = S.CommServUniqueId AND T.MonthStart = S.MonthStart AND T.SrcClientId = S.SrcClientId AND T.AppTypeID = S.AppTypeID AND T.Status = S.Status
			WHEN MATCHED THEN
				UPDATE SET JobCount += S.JobCount, ErrorCode = S.ErrorCode, FailureReason = S.FailureReason
			WHEN NOT MATCHED THEN
				INSERT (CommServUniqueId, MonthStart, SrcClientId, AppTypeId, Status, JobCount, ErrorCode, FailureReason)
				VALUES (S.CommServUniqueId, S.MonthStart, S.SrcClientId, S.AppTypeID , S.Status, S.JobCount, S.ErrorCode, S.FailureReason);
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseRestoreJobDetailsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseRestoreJobDetails')
	delete from GxQscripts where name = 'ParseRestoreJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRestoreJobDetails')
	delete from GXDBVersions where aliasname = 'ParseRestoreJobDetails'
GO

insert into GXDBVersions values(2, 'ParseRestoreJobDetails',  '00010004004200100000', 'ParseRestoreJobDetails', '00010004004200100000')
GO

