

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSubclients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSubclients.sp,v $ $Id: ParseSubclients.sp,v 1.1.2.9.4.1 2021/02/04 05:49:13 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseSubclients')
BEGIN
	print '>>> Drop Stored Procedure: ParseSubclients <<<'
	drop procedure ParseSubclients
END
IF EXISTS (select * from GxQscripts where name='ParseSubclients')
	delete from GxQscripts where name = 'ParseSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclients')
	delete from GXDBVersions where aliasname = 'ParseSubclients'
GO
print '... Creating Procedure: ParseSubclients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseSubclients
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseSubclientsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF OBJECT_ID('tempdb.dbo.#SubclientAssociation') IS NOT NULL DROP TABLE #SubclientAssociation
CREATE TABLE #SubclientAssociation
(
	ClientId			INT,
	ClientName			NVARCHAR(MAX),
	PhysicalClientName  NVARCHAR(MAX),
	AppTypeId			INT,
	AgentName			VARCHAR(256),
	InstanceId			INT,
	InstanceName		NVARCHAR(MAX),
	BackupsetId			INT,
	BackupsetName		NVARCHAR(MAX),
	AppId				INT,
	SubclientName		NVARCHAR(MAX),
	SubclientStatus		INT,
	CreationTime		DATETIME,
	DeconfiguredTime	DATETIME,
	DataPolicyId		INT,
	LogPolicyId			INT,
	SubclientPolicyAppId INT,
	BackupDisabled		INT,
	FilterFlags			INT,
	Archive1PassFlags	INT,
	RestoreDisabled		INT,
	ReaderInfo			VARCHAR(10),
	EncryptionInfo		VARCHAR(25),
	GlobalFilter		INT,
	SpecialTypeFlags	INT
)
IF OBJECT_ID('tempdb.dbo.#NeedToUpdateNames') IS NOT NULL DROP TABLE #NeedToUpdateNames
CREATE TABLE #NeedToUpdateNames
(
	ClientId			INT,
	AppId				INT,
	ClientName			NVARCHAR(256),
	InstanceName		NVARCHAR(512),
	BackupsetName		NVARCHAR(128)
)
DECLARE @FileName NVARCHAR(1024)
IF 	@ErrorCode = 0
BEGIN
	SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
	FROM	cf_CommservSurveyResults WITH (NOLOCK)
	WHERE 	CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #SubclientAssociation FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
CREATE CLUSTERED INDEX #SubclientAssociation_ClientId_AppId_idx ON #SubclientAssociation (ClientId, AppId)
IF 	@ErrorCode = 0
BEGIN
	UPDATE	#SubclientAssociation
	SET		ClientId = -ClientId,
			ClientName = REPLACE(ClientName, '&comma&', ','),
			InstanceName = REPLACE(InstanceName, '&comma&', ','),
			BackupsetName = REPLACE(BackupsetName, '&comma&', ','),
			SubclientName = REPLACE(SubclientName, '&comma&', ','),
			PhysicalClientName = REPLACE(PhysicalClientName, '&comma&', ',')
	WHERE	ClientId < 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	S
	FROM	cf_SurveySubclientAssociation S INNER JOIN #SubclientAssociation T
			ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId AND S.AppId = T.AppId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO #NeedToUpdateNames
	SELECT	S.ClientId, S.AppId, T.ClientName, ISNULL(T.InstanceName,''), ISNULL(T.BackupsetName,'')
	FROM	cf_SurveySubclientAssociation S INNER JOIN #SubclientAssociation T
			ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId
		AND (S.ClientName <> T.ClientName OR
				S.AppTypeId = T.AppTypeId AND S.InstanceId = T.InstanceId
				AND (S.InstanceName <> ISNULL(T.InstanceName,'') OR
						S.BackupsetId = T.BackupsetId AND S.BackupsetName <> ISNULL(T.BackupsetName,'')
					)
			)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	S SET ClientName = T.ClientName, InstanceName = T.InstanceName, BackupsetName = T.BackupsetName
	FROM	cf_SurveySubclientAssociation S INNER JOIN #NeedToUpdateNames T
			ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId AND S.AppId = T.AppId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	cf_SurveySubclientAssociation SET Deleted = 1
	WHERE	CommservUniqueId = @CSUniqueId AND Deleted = 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveySubclientAssociation (
			CommservUniqueId, ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
			SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, Deleted, PhysicalClientName,
			BackupDisabled, FilterFlags, Archive1PassFlags, CreationTime, DeconfiguredTime,RestoreDisabled,ReaderInfo,EncryptionInfo,GlobalFilter,SpecialTypeFlags)
	SELECT	@CSUniqueId, ClientId, ClientName, AppTypeId, AgentName, InstanceId, ISNULL(InstanceName,''), BackupsetId, ISNULL(BackupsetName,''), AppId, ISNULL(SubclientName,''),
			SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, 0, ISNULL(PhysicalClientName,''),
			BackupDisabled, FilterFlags, Archive1PassFlags, CreationTime, DeconfiguredTime,ISNULL(RestoreDisabled,0),ISNULL(ReaderInfo,''),ISNULL(EncryptionInfo,''),ISNULL(GlobalFilter,0),ISNULL(SpecialTypeFlags,0)
	FROM	#SubclientAssociation
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseSubclientsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSubclients')
	delete from GxQscripts where name = 'ParseSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclients')
	delete from GXDBVersions where aliasname = 'ParseSubclients'
GO

insert into GXDBVersions values(2, 'ParseSubclients',  'v1.1.2.9.4.1', 'ParseSubclients', 'v1.1.2.9.4.1')
GO

