

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTenantEntityAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTenantEntityAssociation.sp,v $ $Id: ParseTenantEntityAssociation.sp,v 1.1.2.1 2020/04/03 06:59:48 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseTenantEntityAssociation')
BEGIN
	print '>>> Drop Stored Procedure: ParseTenantEntityAssociation <<<'
	drop procedure ParseTenantEntityAssociation
END
IF EXISTS (select * from GxQscripts where name='ParseTenantEntityAssociation')
	delete from GxQscripts where name = 'ParseTenantEntityAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTenantEntityAssociation')
	delete from GXDBVersions where aliasname = 'ParseTenantEntityAssociation'
GO
print '... Creating Procedure: ParseTenantEntityAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseTenantEntityAssociation
  @QueryId INTEGER,
  @ResultId INTEGER,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseTenantEntityAssociationTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @isprivate INT = (SELECT value from cf_surveyConfig WITH (NOLOCK) where name like 'isPrivate')
IF  @ErrorCode = 0
BEGIN
    IF object_id('tempdb.dbo.#SurveyTenantAssociations') is not null DROP TABLE #SurveyTenantAssociations
    create table #SurveyTenantAssociations (
        userId			int,
		companyId		int,
		isUser	        int,-- 1 is for User and 0 is for company
		entityType1		int,
		entityId1   	int,
		entityType2		int,
		entityId2   	int,
		entityType3		int,
		entityId3   	int,
		entityType4		int,
		entityId4   	int,
		entityType5		int,
		entityId5   	int
    )
END
DECLARE @FileName NVARCHAR(1024)
IF  @ErrorCode = 0
BEGIN
    SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
    FROM    cf_CommservSurveyResults WITH (NOLOCK)
    WHERE   CommservSurveyResults_ID = @ResultId
    SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0
BEGIN
    DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #SurveyTenantAssociations FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
    EXEC(@sql);
END
IF  @ErrorCode = 0
BEGIN
	DELETE FROM cf_SurveyTenantEntityAssociation WHERE commServUniqueId = @CSUniqueId
	IF @isprivate = 1
	BEGIN
		INSERT INTO cf_SurveyTenantEntityAssociation
		SELECT @CSUniqueId,* FROM #SurveyTenantAssociations
	END
	ELSE
	BEGIN
		INSERT INTO cf_SurveyTenantEntityAssociation
		SELECT @CSUniqueId,* FROM #SurveyTenantAssociations WHERE isUser = 0
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId INT, Flags INT) 
  		DECLARE	@LatestParsedResultId INT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseTenantEntityAssociationTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTenantEntityAssociation')
	delete from GxQscripts where name = 'ParseTenantEntityAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTenantEntityAssociation')
	delete from GXDBVersions where aliasname = 'ParseTenantEntityAssociation'
GO

insert into GXDBVersions values(2, 'ParseTenantEntityAssociation',  '00010001000200010000', 'ParseTenantEntityAssociation', '00010001000200010000')
GO

