

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseValidJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseValidJobDetails.sp,v $ $Id: ParseValidJobDetails.sp,v 1.1.2.4 2020/12/17 02:55:32 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseValidJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: ParseValidJobDetails <<<'
	drop procedure ParseValidJobDetails
END
IF EXISTS (select * from GxQscripts where name='ParseValidJobDetails')
	delete from GxQscripts where name = 'ParseValidJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseValidJobDetails')
	delete from GXDBVersions where aliasname = 'ParseValidJobDetails'
GO
print '... Creating Procedure: ParseValidJobDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseValidJobDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseValidJobDetails 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#SurveyValidJobDetails') is not null DROP TABLE #SurveyValidJobDetails
CREATE TABLE #SurveyValidJobDetails (JobId INT, DataStatus INT, CollectionTime INT)
DECLARE @FileName NVARCHAR(1024)
DECLARE @fromUTCTIME INT
SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM	cf_CommservSurveyResults
WHERE	CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF 	@ErrorCode = 0
BEGIN
    DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #SurveyValidJobDetails FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
    EXEC(@sql);
    SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	SET @fromUTCTIME = 0
	SELECT @fromUTCTIME = CollectionTime FROM #SurveyValidJobDetails WHERE JobId = 0
	IF (@fromUTCTIME > 0)
		UPDATE J SET DataStatus = ISNULL(VJ.DataStatus, 2) -- DATA_STATUS_MEDIADELETED = 2,
		FROM cf_SurveyJobStats J
			LEFT OUTER JOIN #SurveyValidJobDetails VJ
				ON J.JobId = VJ.JobId
				AND VJ.JobId > 0
		WHERE J.EndDate <= @fromUTCTIME  AND J.CommservUniqueId = @CSUniqueId
	SELECT @ErrorCode = @@ERROR
	IF object_id('tempdb.dbo.#SurveyValidJobDetails') is not null DROP TABLE #SurveyValidJobDetails
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseValidJobDetails 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'ParseValidJobDetails')
	delete from GxQscripts where name = 'ParseValidJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseValidJobDetails')
	delete from GXDBVersions where aliasname = 'ParseValidJobDetails'
GO

insert into GXDBVersions values(2, 'ParseValidJobDetails',  '00010001000200040000', 'ParseValidJobDetails', '00010001000200040000')
GO

