

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_77ClientDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_77ClientDetails.sp,v $ $Id: Parse_77ClientDetails.sp,v 1.12.2.21 2020/12/17 02:51:59 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Parse_77ClientDetails')
BEGIN
	print '>>> Drop Stored Procedure: Parse_77ClientDetails <<<'
	drop procedure Parse_77ClientDetails
END
IF EXISTS (select * from GxQscripts where name='Parse_77ClientDetails')
	delete from GxQscripts where name = 'Parse_77ClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_77ClientDetails')
	delete from GXDBVersions where aliasname = 'Parse_77ClientDetails'
GO
print '... Creating Procedure: Parse_77ClientDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Parse_77ClientDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseClientDetailsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
CREATE TABLE #SurveyClient
(
	CommServUniqueId			INT NOT NULL,
    ClientId					INT NOT NULL,
ClientName					NVARCHAR (255) NULL,
PhysicalClientName  		NVARCHAR (255) NULL,
OperatingSystem				NVARCHAR (255) NULL,
Timezone					VARCHAR  (255) NULL,
    Type						INT NULL,
    InstallStatus				INT NULL,
    InstallDate					DATETIME NULL,
	UninstallTime				DATETIME NULL,
ServicePack					NVARCHAR (255) NULL,
StoragePolicy				NVARCHAR (255) NULL,
    LatestDataProtection		DATETIME NULL,
	ClientHostName				NVARCHAR(510) NULL,
ClientDisplayName			NVARCHAR (255) NULL,
	Latitude					DECIMAL(16,13) NULL,
	Longitude					DECIMAL(16,13) NULL,
	CountryCode					NVARCHAR(3) NOT NULL DEFAULT '',
	ExceptionType				INT NULL
)
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO #SurveyClient (
		CommServUniqueId, ClientId, ClientName, PhysicalClientName, OperatingSystem, Timezone, Type,
		InstallStatus, InstallDate, UninstallTime, ServicePack, StoragePolicy, LatestDataProtection,
		ClientHostName, ClientDisplayName, Latitude, Longitude, CountryCode, ExceptionType)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@clientId' , '[INT]'),
		csInfo.n.value('@clientName' , '[NVARCHAR](255)'),
		csInfo.n.value('@physicalClientName' , '[NVARCHAR](255)'),
		csInfo.n.value('@operatingSystem' , '[NVARCHAR](255)'),
		csInfo.n.value('@timezone' , '[NVARCHAR](255)'),
		csInfo.n.value('@type' , '[INT]'),
		csInfo.n.value('@lastbkp' , '[INT]'),
		CASE
			WHEN csInfo.n.value('@installdate' , '[DATETIME]')<'1970-01-02' THEN NULL
			ELSE csInfo.n.value('@installdate' , '[DATETIME]') END,
		CASE
			WHEN csInfo.n.value('@uninstallTime' , '[DATETIME]')<'1970-01-02' THEN NULL
			ELSE csInfo.n.value('@uninstallTime' , '[DATETIME]') END,
		csInfo.n.value('@servicePack' , '[NVARCHAR](255)'),
		csInfo.n.value('@StoragePolicy' , '[NVARCHAR](255)'),
		csInfo.n.value('@latestDataProtection' , '[DATETIME]'),
		csInfo.n.value('@ClientHostName' , '[NVARCHAR](510)'),
		csInfo.n.value('@displayName' , '[NVARCHAR](255)'),
		csInfo.n.value('@latitude', '[DECIMAL](16,13)'),
		csInfo.n.value('@longitude', '[DECIMAL](16,13)'),
		ISNULL(csInfo.n.value('@countryCode', '[NVARCHAR](3)'), ''),
		csInfo.n.value('@exceptionType' , '[INT]')
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('ClientDetails/Client') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
ALTER TABLE #SurveyClient Add clientGroups NVARCHAR(MAX) null
IF @ErrorCode = 0 AND EXISTS (SELECT TOP 1 1 FROM #SurveyClient)
BEGIN
	UPDATE T SET T.clientGroups = C.clientGroups
	FROM #SurveyClient T
		INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON C.CommServUniqueId = @CSUniqueId AND T.ClientId = C.ClientId AND C.ClientGroups is not NULL
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT TOP 1 1 FROM #SurveyClient WHERE Type&256 > 0 AND CountryCode = '')
BEGIN
	UPDATE T SET Latitude = C.latitude, Longitude = C.longitude, CountryCode = C.CountryCode
	FROM	#SurveyClient T
			INNER JOIN (
				SELECT	CommServUniqueId, ClientId, Latitude, Longitude, CountryCode
				FROM	cf_SurveyClient
				WHERE	CommServUniqueId = @CSUniqueId AND Type&256 > 0 AND CountryCode <> ''
			) C ON T.CommServUniqueId = C.CommServUniqueId AND T.ClientId = C.ClientId AND T.CountryCode = ''
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE C FROM cf_SurveyClient C WITH (PAGLOCK) INNER JOIN #SurveyClient T ON C.CommServUniqueId = T.CommServUniqueId AND C.ClientId = T.clientId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyClient SET Deleted = 1 WHERE CommServUniqueId = @CSUniqueId AND Deleted = 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyClient (
		CommServUniqueId, ClientId, ClientName, PhysicalClientName, OperatingSystem, Timezone, Type,
		InstallStatus, Installdate, UninstallTime, ServicePack, StoragePolicy, LatestDataProtection, Deleted,
		ClientHostName, ClientDisplayName, Latitude, Longitude, CountryCode, ExceptionType, ClientGroups)
	SELECT
		CommServUniqueId, ClientId, ClientName, PhysicalClientName, OperatingSystem, Timezone, Type,
		InstallStatus, Installdate, UninstallTime, ServicePack, StoragePolicy, LatestDataProtection, 0,
		ClientHostName, ClientDisplayName, Latitude, Longitude, CountryCode, ExceptionType, ClientGroups
	FROM #SurveyClient
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseClientDetailsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_77ClientDetails')
	delete from GxQscripts where name = 'Parse_77ClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_77ClientDetails')
	delete from GXDBVersions where aliasname = 'Parse_77ClientDetails'
GO

insert into GXDBVersions values(2, 'Parse_77ClientDetails',  '00010012000200210000', 'Parse_77ClientDetails', '00010012000200210000')
GO

