

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_96DiskLibDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_96DiskLibDetails.sp,v $ $Id: Parse_96DiskLibDetails.sp,v 1.5.2.20 2020/12/17 02:51:26 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Parse_96DiskLibDetails')
BEGIN
	print '>>> Drop Stored Procedure: Parse_96DiskLibDetails <<<'
	drop procedure Parse_96DiskLibDetails
END
IF EXISTS (select * from GxQscripts where name='Parse_96DiskLibDetails')
	delete from GxQscripts where name = 'Parse_96DiskLibDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_96DiskLibDetails')
	delete from GXDBVersions where aliasname = 'Parse_96DiskLibDetails'
GO
print '... Creating Procedure: Parse_96DiskLibDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Parse_96DiskLibDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDiskLibDetailsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #Details
(
	CommServUniqueId			INT NOT NULL,
	SurveyResultId				BIGINT NOT NULL,
	LogDateUTC					DATETIME NOT NULL,
	LogDate						DATETIME NOT NULL,
    LibraryId					BIGINT NOT NULL,
LibraryName					NVARCHAR (255) NULL,
    totalValidDataGB			FLOAT NULL,
    totalDataWrittenGB			FLOAT NULL,
    totalAppSizeGB				FLOAT NULL,
    totalFreeSpaceGB			FLOAT NULL,
    totalReserveSpaceMB			BIGINT NULL,
    totalSpaceGB				FLOAT NULL,
	lowWatermark                INT NULL,
	warningWatermark            INT NULL,
    macroPrunableGB				BIGINT NULL,
	avgConsumedMBPerDay         BIGINT NULL,
	avgFreedMBPerDay            BIGINT NULL,
    usedSpaceGB					FLOAT NULL
)
DECLARE	@MonthStart	DATETIME = DATEADD(MONTH, DATEDIFF(MONTH, 0, @LogDate), 0)
DECLARE	@WeekStart	DATETIME = DATEADD(WEEK, DATEDIFF(WEEK, 0, @LogDate), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #Details
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@LibraryId'					, 'BIGINT'),
		csInfo.n.value('@LibraryName'				, '[NVARCHAR](MAX)'),
		ISNULL(csInfo.n.value('@totalValidDataGB'	, 'FLOAT'), 0),
		ISNULL(csInfo.n.value('@totalDataWrittenGB'	, 'FLOAT'), 0),
		ISNULL(csInfo.n.value('@totalAppSizeGB'		, 'FLOAT'), 0),
		ISNULL(csInfo.n.value('@totalFreeSpaceGB'	, 'FLOAT'), -1),
		ISNULL(csInfo.n.value('@totalReserveSpaceMB', 'BIGINT'), -1),
		ISNULL(csInfo.n.value('@totalSpaceGB'		, 'FLOAT'), -1),
		csInfo.n.value('@lowWatermark'				, 'INT'),
		csInfo.n.value('@warningWatermark'			, 'INT'),
		ISNULL(csInfo.n.value('@macroPrunableGB'	, 'FLOAT'), 0),
		ISNULL(csInfo.n.value('@avgConsumedMBPerDay', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@avgFreedMBPerDay'   , 'BIGINT'), 0),
		0
	FROM
		@ResultXml.nodes('DiskLibDetails/DiskLib') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE #Details SET usedSpaceGB = (totalSpaceGB - totalFreeSpaceGB)
	WHERE  totalSpaceGB > 0 AND totalFreeSpaceGB > 0 AND (totalSpaceGB - totalFreeSpaceGB) >= 0
	INSERT INTO cf_Survey96DiskLibDetails (
		CommServUniqueId, SurveyResultId, LogDateUTC, LogDate, LibraryId, LibraryName,
		totalValidDataGB, totalDataWrittenGB, totalAppSizeGB, totalFreeSpaceGB, totalReserveSpaceMB, totalSpaceGB,
		lowWatermark, warningWatermark, macroPrunableGB, avgConsumedMBPerDay, avgFreedMBPerDay
	)
	SELECT
		CommServUniqueId, SurveyResultId, LogDateUTC, LogDate, LibraryId, LibraryName,
		totalValidDataGB, totalDataWrittenGB, totalAppSizeGB, totalFreeSpaceGB, totalReserveSpaceMB, totalSpaceGB,
		 lowWatermark, warningWatermark, macroPrunableGB, avgConsumedMBPerDay, avgFreedMBPerDay
	FROM #Details
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyDiskLibraryPeakSize
	SET	UsedSpaceMB   = CASE WHEN S.usedSpaceGB*1024 > P.UsedSpaceMB THEN S.usedSpaceGB*1024 ELSE P.UsedSpaceMB END,
		FreeSpaceMB   = CASE WHEN (S.totalFreeSpaceGB*1024 < P.FreeSpaceMB) OR P.FreeSpaceMB <= 0 THEN S.totalFreeSpaceGB*1024 ELSE P.FreeSpaceMB END,
		AppSizeMB     = CASE WHEN S.totalAppSizeGB*1024 > P.AppSizeMB THEN S.totalAppSizeGB*1024 ELSE P.AppSizeMB END,
		DataWrittenMB = CASE WHEN S.totalDataWrittenGB*1024 > P.DataWrittenMB THEN S.totalDataWrittenGB*1024 ELSE P.DataWrittenMB END
	FROM #Details S
		INNER JOIN cf_SurveyDiskLibraryPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.LibraryId = S.LibraryId
	WHERE S.totalSpaceGB > 0 AND S.totalFreeSpaceGB > 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDiskLibraryPeakSize (
		CommServUniqueId, MonthStart, LibraryId, LibraryName, UsedSpaceMB, FreeSpaceMB, AppSizeMB, DataWrittenMB)
	SELECT
		@CSUniqueId, @MonthStart, S.LibraryId, S.LibraryName,
		MAX(S.usedSpaceGB)*1024, MIN(S.totalFreeSpaceGB)*1024,
		MAX(S.totalAppSizeGB)*1024, MAX(S.totalDataWrittenGB)*1024
	FROM #Details S
		LEFT OUTER JOIN cf_SurveyDiskLibraryPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.LibraryId = S.LibraryId
	WHERE P.CommServUniqueId IS NULL
	GROUP BY S.LibraryId, S.LibraryName
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyDiskLibraryWeeklyPeakSize
	SET	UsedSpaceMB   = CASE WHEN S.usedSpaceGB*1024 > P.UsedSpaceMB THEN S.usedSpaceGB*1024 ELSE P.UsedSpaceMB END,
		FreeSpaceMB   = CASE WHEN (S.totalFreeSpaceGB*1024 < P.FreeSpaceMB) OR P.FreeSpaceMB <= 0 THEN S.totalFreeSpaceGB*1024 ELSE P.FreeSpaceMB END,
		AppSizeMB     = CASE WHEN S.totalAppSizeGB*1024 > P.AppSizeMB THEN S.totalAppSizeGB*1024 ELSE P.AppSizeMB END,
		DataWrittenMB = CASE WHEN S.totalDataWrittenGB*1024 > P.DataWrittenMB THEN S.totalDataWrittenGB*1024 ELSE P.DataWrittenMB END
	FROM #Details S
		INNER JOIN cf_SurveyDiskLibraryWeeklyPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.WeekStart = @WeekStart AND P.LibraryId = S.LibraryId
	WHERE S.totalSpaceGB > 0 AND S.totalFreeSpaceGB > 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDiskLibraryWeeklyPeakSize (
		CommServUniqueId, WeekStart, LibraryId, UsedSpaceMB, FreeSpaceMB, AppSizeMB, DataWrittenMB)
	SELECT
		@CSUniqueId, @WeekStart, S.LibraryId,
		MAX(S.usedSpaceGB)*1024, MIN(S.totalFreeSpaceGB)*1024,
		MAX(S.totalAppSizeGB)*1024, MAX(S.totalDataWrittenGB)*1024
	FROM #Details S
		LEFT OUTER JOIN cf_SurveyDiskLibraryWeeklyPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.WeekStart = @WeekStart AND P.LibraryId = S.LibraryId
	WHERE P.CommServUniqueId IS NULL
	GROUP BY S.LibraryId
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDiskLibDetailsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_96DiskLibDetails')
	delete from GxQscripts where name = 'Parse_96DiskLibDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_96DiskLibDetails')
	delete from GXDBVersions where aliasname = 'Parse_96DiskLibDetails'
GO

insert into GXDBVersions values(2, 'Parse_96DiskLibDetails',  '00010005000200200000', 'Parse_96DiskLibDetails', '00010005000200200000')
GO

