

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/PruneSurveyResults.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/PruneSurveyResults.sp,v $ $Id: PruneSurveyResults.sp,v 1.15.2.53 2020/12/18 18:57:30 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='PruneSurveyResults')
BEGIN
	print '>>> Drop Stored Procedure: PruneSurveyResults <<<'
	drop procedure PruneSurveyResults
END
IF EXISTS (select * from GxQscripts where name='PruneSurveyResults')
	delete from GxQscripts where name = 'PruneSurveyResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneSurveyResults')
	delete from GXDBVersions where aliasname = 'PruneSurveyResults'
GO
print '... Creating Procedure: PruneSurveyResults'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure PruneSurveyResults
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
SET DEADLOCK_PRIORITY LOW
BEGIN TRY
DECLARE @ErrorCode INTEGER
DECLARE @ErrorString NVARCHAR(MAX)
SELECT @ErrorString = 'PruneSurveyResults - Start'
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
CREATE TABLE #QueryRetention (QueryId INT, DataRetentionDays INT, RetainUntil DATETIME, DataRetentionFlags INT)
CREATE TABLE #SurveyResultsToDelete (CommservSurveyResults_ID INT)
DECLARE @nRow		INT = 1
DECLARE @counts		BIGINT = 0
DECLARE	@TotalRows	BIGINT = 0
DECLARE	@StartDate	DATETIME = GETUTCDATE()
-- Remove CommCells which have no data collection for last 90 days
BEGIN TRANSACTION
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'isPrivate'
DECLARE	@CCRetentionDays INT
IF ( @param_isPrivate = 1)
   SET @CCRetentionDays = 365
ELSE
   SET @CCRetentionDays = 90
SELECT	@CCRetentionDays  = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionDaysForCellsNotUploading'
INSERT INTO cf_CommservSurveyDeletedCommcells
SELECT ID, CommCellID, GETUTCDATE(), 'Deleted via commcell pruning', 0
FROM	cf_CommcellIdNameMap T WITH(NOLOCK)
		LEFT OUTER JOIN
		(SELECT	CommcellIdNameMap_ID, MAX(cast(FileTime as Datetime)) AS maxFileTime
		FROM	cf_CustomerFeedbackXmlFile WITH(NOLOCK)
		GROUP BY CommcellIdNameMap_ID
		HAVING MAX(cast(FileTime as Datetime)) > DATEADD(DAY, -@CCRetentionDays, GETUTCDATE())
		UNION
		SELECT	CommServUniqueId, MAX(LogDateUTC)
		FROM	cf_SurveyUpgradeReadiness WITH(NOLOCK)
		GROUP BY CommServUniqueId
		HAVING MAX(LogDateUTC) > DATEADD(DAY, -@CCRetentionDays, GETUTCDATE())
		) S ON T.ID = S.CommcellIdNameMap_ID
WHERE	S.CommcellIdNameMap_ID IS NULL
DELETE FROM cf_CommcellIdNameMap
WHERE ID IN (SELECT DISTINCT CommcellIdNameMap_ID from cf_CommservSurveyDeletedCommcells WHERE DeleteSchedules = 0)
SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
IF  @ErrorCode = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Remove CommCells which have no data collection for ' + CAST(@CCRetentionDays as varchar(20)) +' days. Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] rows.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Delete orphan rows from cf_SurveyClientGroupAssociation table because FK is missing
DELETE	CGA
FROM	cf_SurveyClientGroupAssociation CGA
		LEFT OUTER JOIN cf_SurveyClientGroup CG ON CGA.commservUniqueId = CG.commservUniqueId AND CGA.clientGroupId =  CG.clientGroupId
WHERE	CG.clientGroupId IS NULL
SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Delete orphan rows from cf_SurveyClientGroupAssociation table. Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] rows.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Delete orphan results for missing QueryId
BEGIN TRANSACTION
DELETE	cf_CommservSurveyResults
FROM	cf_CommservSurveyResults R
		LEFT OUTER JOIN cf_CommservSurveyQueries Q ON R.QueryId = Q.QueryId
WHERE Q.QueryId IS NULL
SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
IF  @ErrorCode = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults -  Delete orphan results for missing QueryId. Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] rows.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Delete all entries for disabled queries
INSERT  INTO #QueryRetention
SELECT Q.QueryId, F.DataRetentionDays, DATEADD(DAY, -F.DataRetentionDays, GETUTCDATE()), Q.DataRetentionIntervalHrs
FROM cf_CommservSurveyQueries Q WITH(NOLOCK)
	INNER JOIN dbo.RptGetMetricsQueryFlags(0) F ON F.QueryId = Q.QueryId
WHERE F.QueryEnabled = 0
SET @nRow = 1
SET	@counts = 0
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET	@counts += @nRow
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] results for disabled queries.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Delete entries not required for parsing (ShredStatus = 3)
TRUNCATE TABLE #QueryRetention
INSERT  INTO #QueryRetention
SELECT Q.QueryId, F.DataRetentionDays, DATEADD(DAY, -F.DataRetentionDays, GETUTCDATE()), Q.DataRetentionIntervalHrs
FROM cf_CommservSurveyQueries Q WITH(NOLOCK)
	INNER JOIN dbo.RptGetMetricsQueryFlags(0) F ON F.QueryId = Q.QueryId
WHERE F.QueryEnabled = 1
-- Retain failed results after 1 day for troubleshooting
DECLARE	@FailedResultsRetentionDays INT = 1
SELECT	@FailedResultsRetentionDays = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionDaysForFailedResults'
DECLARE	@RetainFailedUntil DATETIME = DATEADD(DAY, -@FailedResultsRetentionDays, GETUTCDATE())
SET @nRow = 1
SET @TotalRows += @counts
SET	@counts = 0
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId AND A.Flags <> 1 AND A.ShredStatus = 3 AND A.LogDateUTC < @RetainFailedUntil
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET	@counts += @nRow
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] not required results.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Delete aged entries and those which are not latest
SET @nRow = 1
SET @TotalRows += @counts
SET	@counts = 0
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId AND A.Flags <> 1 AND A.ShredStatus = 2 AND (B.DataRetentionDays = 1 OR A.LogDateUTC < B.RetainUntil)
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET	@counts += @nRow
	IF	@counts%50000 = 0
	BEGIN
		SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] aged survey results.'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] aged survey results.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Retain results for recent 30 days.
-- Retain the last result per week for recent 90 days.
-- Retain the last result per month.
-- DataRetentionIntervalHrs = 0 for retaining all not aged results
DELETE FROM #QueryRetention WHERE DataRetentionDays = 1 or DataRetentionFlags = 0
CREATE TABLE #TblPeriod (BeginDT DATETIME, EndDT DATETIME)
DECLARE	@periodCounter	INT = 13
DECLARE @tempEndDT		DATETIME = DATEADD(WK, DATEDIFF(WK, 0, GETUTCDATE()), 0)
DECLARE @tempBeginDT	DATETIME = DATEADD(WK, -1, @tempEndDT)
WHILE (@periodCounter > 0)
BEGIN
	INSERT	INTO #TblPeriod
	SELECT	@tempBeginDT, @tempEndDT
	SET @tempEndDT	= @tempBeginDT
	SET @tempBeginDT = DATEADD(WK, -1, @tempEndDT)
	SET	@periodCounter = (@periodCounter - 1)
END
SET	@periodCounter	= 12
SET @tempEndDT		= DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
SET @tempBeginDT	= DATEADD(MM, -1, @tempEndDT)
WHILE (@periodCounter > 0)
BEGIN
	INSERT	INTO #TblPeriod
	SELECT	@tempBeginDT, @tempEndDT
	SET @tempEndDT	= @tempBeginDT
	SET @tempBeginDT = DATEADD(MM, -1, @tempEndDT)
	SET	@periodCounter = (@periodCounter - 1)
END
CREATE TABLE #SurveyResultsToRetain (PeriodEndDT DATETIME, CommServUniqueId INT, SurveyID INT, CommservSurveyResults_ID INT)
INSERT	INTO #SurveyResultsToRetain
SELECT	P.EndDT, A.CommcellIdNameMap_ID, A.QueryId, MAX(A.CommservSurveyResults_ID)
FROM	cf_CommservSurveyResults A
		INNER JOIN #QueryRetention B
			 ON A.QueryId = B.QueryId AND A.ShredStatus = 2 AND A.LogDateUTC > B.RetainUntil
		INNER JOIN #TblPeriod P
			 ON A.LogDate BETWEEN P.BeginDT AND P.EndDT
GROUP BY P.EndDT, A.CommcellIdNameMap_ID, A.QueryId
SET @nRow = 1
SET @TotalRows += @counts
SET	@counts = 0
SELECT @tempBeginDT = MIN(BeginDT) FROM #TblPeriod
SELECT @tempEndDT	= MAX(EndDT) FROM #TblPeriod
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId AND A.Flags <> 1 AND A.ShredStatus = 2 AND A.LogDate BETWEEN @tempBeginDT AND @tempEndDT
			LEFT OUTER JOIN #SurveyResultsToRetain C
				ON A.CommservSurveyResults_ID = C.CommservSurveyResults_ID
	WHERE	C.CommservSurveyResults_ID IS NULL
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET @counts += @nRow
	IF	@counts%50000 = 0
	BEGIN
		SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] survey results which are older than 30 days and not the last of each week or month.'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
END
SET @TotalRows += @counts
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] survey results which are older than 30 days and not the last of each week or month.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DROP TABLE #QueryRetention
DROP TABLE #SurveyResultsToDelete
DROP TABLE #SurveyResultsToRetain
DROP TABLE #TblPeriod
-- Delete TransferXMLFile file which are transferred or reach to max RetentionDays
DECLARE @param_RetentionDaysTransferXMLFile INT = 7
SELECT	@param_RetentionDaysTransferXMLFile = ISNULL(cast(Value AS INT), 7) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'RetentionDaysTransferXMLFile'
DELETE	cf_MetricTransferXMLFile WHERE Status =0 OR (datediff(hour, LastRetriedDateUTC,getutcdate()) >= @param_RetentionDaysTransferXMLFile*24 )
-- Delete SurveyLogger older than 30 days
DECLARE	@LogRetentionDays INT = 30
SELECT	@LogRetentionDays = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionDaysForSurveyLogger'
DECLARE	@RetainLogUntil DATETIME = DATEADD(DAY, -@LogRetentionDays, GETUTCDATE())
DELETE	FROM cf_SurveyLogger
WHERE	LogDateUTC < @RetainLogUntil
SET @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] SurveyLogger older than 30 days'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
------ Below prune tables not based on retention of queries
--- Prune backup, admin, company and restore job tables
SET @counts = 0
DECLARE @RetentionForCompany INT = 26
SELECT	@RetentionForCompany = CAST(ISNULL(Value, 26) AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionMonthsForJobDetails'
SELECT @RetentionForCompany = CAST(ISNULL(Value, @RetentionForCompany) AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionMonthsForMonthlyCompanyJobStats'
DELETE	FROM cf_SurveyCompanyMonthlyBkpJobStats
WHERE	MonthStart <= DATEADD(MONTH, -@RetentionForCompany, GETUTCDATE())
	SET @counts += @@ROWCOUNT
SELECT	@RetentionForCompany = CAST(ISNULL(Value, 26) AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionMonthsForJobDetails'
SELECT @RetentionForCompany = CAST(ISNULL(Value, @RetentionForCompany) AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionDaysForDailyCompanyJobStats'
DELETE	FROM cf_SurveyCompanyDailyBkpJobStats
WHERE	JobEndDate <= DATEADD(MONTH, -@RetentionForCompany, GETUTCDATE())
	SET @counts += @@ROWCOUNT
DECLARE @RetentionForRestore INT = 13
SELECT @RetentionForRestore = CAST(ISNULL(Value, 13) AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionMonthsForMonthlyRestoreJobDetails'
DELETE	FROM cf_SurveyIDAMonthlyRSTJobStats
WHERE	MonthStart <= DATEADD(MONTH, -@RetentionForRestore, GETUTCDATE())
	SET @counts += @@ROWCOUNT
SELECT @RetentionForRestore = CAST(ISNULL(Value, 13) AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionMonthsForClientFailureRestoreJobDetails'
DELETE	FROM cf_SurveyIDAMonthlyRSTJobFailurePerClient
WHERE	MonthStart <= DATEADD(MONTH, -@RetentionForRestore, GETUTCDATE())
	SET @counts += @@ROWCOUNT
SELECT @RetentionForRestore = CAST(ISNULL(Value, 1) AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionMonthsForDailyRestoreJobDetails'
DELETE	FROM cf_SurveyIDADailyRSTJobStats
WHERE	JobEndDate <= DATEADD(MONTH, -@RetentionForRestore, GETUTCDATE())
	SET @counts += @@ROWCOUNT
DECLARE	@RetentionMonths INT = 26
DECLARE	@RetentionWeeks  INT = 13
SELECT	@RetentionMonths = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionMonthsForJobDetails'
DECLARE @RetainJobUntilDate DATETIME
DECLARE	@RetainJobUntil INT = DATEDIFF(SECOND, '1970/01/01', DATEADD(MONTH, -@RetentionMonths, GETUTCDATE()))
DELETE	FROM cf_SurveyJobStats
WHERE	EndDate < @RetainJobUntil AND DataStatus IN (2, 3)
	SET @counts += @@ROWCOUNT
DELETE	JM
FROM	cf_SurveyJobsOnTapeMedia JM
		LEFT OUTER JOIN cf_SurveyJobStats J ON J.jobId = JM.jobid and J.CommservUniqueId = JM.CommservUniqueId
WHERE	J.jobID IS NULL
	SET @counts += @@ROWCOUNT
DECLARE @RetentionForRestoreJobs INT
IF ( @param_isPrivate = 1)
	SET @RetentionForRestoreJobs = @RetentionMonths
ELSE
	SET @RetentionForRestoreJobs = 2
SELECT @RetentionForRestoreJobs = CAST(ISNULL(Value, @RetentionForRestoreJobs) AS INT)
FROM    cf_SurveyConfig WITH(NOLOCK)
WHERE   Name = 'RetentionForRestoreJobStats'
DELETE	FROM cf_SurveyRestoreJobStats
WHERE	EndTime < DATEDIFF(SECOND, '1970/01/01', DATEADD(MONTH, -@RetentionForRestoreJobs, GETUTCDATE()))
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyAdminJobStats
WHERE	EndDate < @RetainJobUntil
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyRunningAdminJobStats
WHERE	StartDate < @RetainJobUntil
	SET @counts += @@ROWCOUNT
DECLARE	@RetentionDays INT = 7
SELECT	@RetentionDays = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionDaysForJobDbSize'
SET @RetainJobUntil = DATEDIFF(SECOND, '1970/01/01', DATEADD(DAY, -@RetentionDays, GETUTCDATE()))
DELETE	FROM cf_SurveyJobDbSize
WHERE	JobEndDate < @RetainJobUntil
	SET @counts += @@ROWCOUNT
SET @RetentionDays = 60
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'DailyDataRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyDailyDataRetentionStats WHERE JobEndDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE FROM cf_SurveyDailyRstJobStats WHERE JobEndDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyIDADailyBkpJobStats table
SET @RetentionDays = 400
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'DailyActivityRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyIDADailyBkpJobStats WHERE JobEndDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyIDAMonthlyBkpJobStats
SET @RetentionMonths = 60
SELECT  @RetentionMonths = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'MonthlyActivityRetentionMonths'
SET @RetainJobUntilDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
DELETE FROM cf_SurveyIDAMonthlyBkpJobStats WHERE MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyRunningJobStats table delete jobs which are started before 30 days
SET @RetentionDays = 30
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'RunningJobsRetentionDays'
SET @RetainJobUntil = DATEDIFF(SECOND, '1970/01/01', DATEADD(DAY, -@RetentionDays, GETUTCDATE()))
DELETE FROM R
FROM cf_SurveyRunningJobStats R
	LEFT OUTER JOIN cf_SurveyJobStats JS
		ON R.CommServUniqueId  =  JS.CommServUniqueId
			AND R.JobId  =  JS.JobId
WHERE R.StartDate < @RetainJobUntil
	AND ((JS.CommservUniqueId IS NOT NULL AND JS.JobId IS NOT NULL)) --Do not delete incomplete jobs. Requirement by UBS for the 'Pending Jobs custom report.
	SET @counts += @@ROWCOUNT
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] from backup, admin and restore job stats tables'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--- Prune monthly capacity usage
SET @TotalRows += @counts
SET @counts = 0
DECLARE	@FromDate DATETIME
DECLARE	@FromDateUnixTime BIGINT
-- Prune daily cf_SurveyCommCellCapacityUsage and monthly cf_SurveyCapacityPeakUsageDetails
SET @RetentionMonths = 26
SELECT  @RetentionMonths = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'DailyCommCellCapacityUsageRetentionMonths'
SET @FromDate = DATEADD(MONTH, DATEDIFF(MONTH,0,GETUTCDATE()) - @RetentionMonths, 0)
DELETE cf_SurveyCommCellCapacityUsage WHERE AsOfDate < @FromDate
	SET @counts += @@ROWCOUNT
DELETE cf_SurveyCapacityPeakUsageDetails WHERE MonthStart < @FromDate
	SET @counts += @@ROWCOUNT
SET @RetentionMonths = -1
SELECT	@RetentionMonths = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionMonthsForGrowth'
IF @RetentionMonths > 0
BEGIN
	SET	@FromDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
	SET @FromDateUnixTime = dbo.GetUnixTimeBig(@FromDate)
	DELETE cf_SurveyDeDupStoreConfigPeakSize WHERE WeekStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyIndexCacheUsagePeakSize WHERE WeekStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyAgentCapacityPeakUsage WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyAgentLicensePeakUsage WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyCapacityLicensePeakUsage WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyAgentPeakSize WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyClientGroupPeakSize WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyDiskLibraryPeakSize WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyMonthlyTapeUsageByLibrary WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyLicPeakUsageDetails WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyLicPeakCLALicClientCount WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyLicSCLPeakUsageDetails WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
	DELETE cf_SurveyLicSCLPeakCALDetails WHERE MonthStart < @FromDate
		SET @counts += @@ROWCOUNT
END
-- Prune cf_SurveySLAHistory and cf_SurveyClientGroupSLAHistory
SET @RetentionMonths = 24
SELECT  @RetentionMonths = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'MonthlySLAHistoryRetentionMonths'
SET @RetainJobUntilDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
DELETE	FROM cf_SurveySLAHistory
WHERE	MonthBegin < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyClientGroupSLAHistory
WHERE	AsOfDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] from monthly history/usage tables'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Prune deleted endpoint users after retaining for a year
SET @TotalRows += @counts
SET @counts = 0
SET @RetentionMonths = 12
SET	@FromDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
DELETE cf_SurveyEndusers WHERE ModifiedTime < @FromDate
	SET @counts += @@ROWCOUNT
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] endpoint users from cf_SurveyEndusers table'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--- Prune tables used for Monthly/Quarterly PPT
SET @TotalRows += @counts
SET @counts = 0
-- For cf_SurveyBkpJobStats_Daily used in Quarterly PPT
SET	@RetentionDays = 130
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE	FROM cf_SurveyBkpJobStats_Daily
WHERE	servEndDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- For cf_SurveyMonthlyRstJobStats, cf_SurveyMonthlyErrorSummary and cf_SurveyMonthlyStrikes used in Monthly PPT
SET @RetentionMonths = 13
SET @RetainJobUntilDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
DELETE	FROM cf_SurveyMonthlyRstJobStats
WHERE	MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyDailyDDBRatioByCommCell
WHERE	EndDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyMonthlyErrorSummary
WHERE	MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyMonthlyStrikes
WHERE	MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyMonthlyDataRetentionStats
WHERE	MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
DELETE	FROM cf_SurveyConsumerMonthlyBkpJobStats
WHERE	MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
SET  @RetentionMonths = 24
SELECT  @RetentionMonths = CAST(Value AS INT)
FROM    cf_SurveyConfig WITH(NOLOCK)
WHERE   Name = 'RetentionMonthsForDeletedCompanies'
SET @RetainJobUntilDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
DELETE  FROM cf_SurveyTenants
WHERE   DeletedDate < @RetainJobUntilDate
    SET @counts += @@ROWCOUNT
--prune cf_SurveyDailyStrikes
SET @RetentionMonths = (SELECT Value FROM cf_SurveyConfig WHERE Name = 'RetentionMonthsForDailyStrikes')
DECLARE @RetainStrikesUntilDate DATE = DATEADD(mm, -@RetentionMonths ,getutcdate())
DELETE FROM cf_SurveyDailyStrikes
WHERE DayStart < @RetainStrikesUntilDate
SET @counts += @@ROWCOUNT
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] from tables used for Monthly/Quarterly PPT'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--- Prune tables used for media usage
SET @TotalRows += @counts
SET @counts = 0
-- Prune cf_SurveyDailyDedupeSaving table
SET @RetentionDays = 180
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'DailyDedupeSavingRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyDailyDedupeSaving WHERE JobEndDate < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyMonthlyDedupeSaving
SET @RetentionMonths = 24
SELECT  @RetentionMonths = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'MonthlyDedupeSavingRetentionMonths'
SET @RetainJobUntilDate = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
DELETE FROM cf_SurveyMonthlyDedupeSaving WHERE MonthStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyTapeMediaHistory
SET @RetentionMonths = 26
SELECT @RetentionMonths = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'RetentionMonthsForTapeMediaHistory'
SET @RetainJobUntil = DATEDIFF(SECOND, '1970/01/01', DATEADD(MONTH, -@RetentionMonths, GETUTCDATE()))
DELETE	FROM cf_SurveyTapeMediaHistory WHERE UpdateTime < @RetainJobUntil
	SET @counts += @@ROWCOUNT
DELETE FROM cf_SurveyTapeMediaUsage WHERE MonthVal <= DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyDiskLibraryWeeklyPeakSize
SET @RetentionWeeks = 13
SELECT	@RetentionWeeks = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionWeeksForGrowth'
IF @RetentionWeeks > 0
BEGIN
	SET	@FromDate = DATEADD(WEEK, -@RetentionWeeks, GETUTCDATE())
	DELETE cf_SurveyDiskLibraryWeeklyPeakSize WHERE WeekStart < @FromDate
	SET @counts += @@ROWCOUNT
END
-- Prune cf_SurveyLibraryThroughput
SET @RetentionDays = 180
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'LibraryThroughputRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyLibraryThroughput WHERE DayStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
-- Prune cf_SurveyMountPathThroughput
SET @RetentionDays = 180
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'DailyMountPathThroughputRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyMountPathThroughput WHERE IntervalType = 'D' AND IntervalStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
SET @RetentionDays = 30
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'HourlyMountPathThroughputRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyMountPathThroughput WHERE IntervalType = 'H' AND IntervalStart < @RetainJobUntilDate
	SET @counts += @@ROWCOUNT
SET @TotalRows += @counts
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] from media usage tables'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Prune CVMetricsServiceClientRequest and CVMetricsServiceClientRequestHistory
SET @RetentionDays  = 7 -- Set the default retention days to 7 days for Refresh request.
SELECT	@RetentionDays  = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionDaysForRefresh'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM CVMetricsServiceClientRequest WHERE CreatedTime < @RetainJobUntilDate
SET @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] from CVMetricsServiceClientRequest'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--History retention is * 10
SET @RetainJobUntilDate = DATEADD(DAY, -(@RetentionDays * 10), GETUTCDATE())
DELETE FROM CVMetricsServiceClientRequestHistory WHERE CreatedTime < @RetainJobUntilDate
SET @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] from CVMetricsServiceClientRequestHistory'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Prune cf_NTLiveFeedsMessageHistory
DECLARE @RetainJobUntilUnixTime INT
SET @RetentionDays  = 90 -- Set the default retention days to 90 days for Refresh request.
SELECT	@RetentionDays  = CAST(Value AS INT)
FROM	cf_SurveyConfig WITH(NOLOCK)
WHERE	Name = 'RetentionDaysForAlerts'
SET @RetainJobUntilUnixTime = dbo.GetUnixTimeBig(DATEADD(DAY, -@RetentionDays, GETUTCDATE()))
DELETE FROM cf_NTLiveFeedsMessageHistory WHERE Created < @RetainJobUntilUnixTime
SET @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] from cf_NTLiveFeedsMessageHistory'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Prune cf_SurveyDatabaseSizeHistory
SET @RetentionDays = 30
SELECT @RetentionDays = CAST(Value AS INT) FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'DatabaseSizeHistoryRetentionDays'
SET @RetainJobUntilDate = DATEADD(DAY, -@RetentionDays, GETUTCDATE())
DELETE FROM cf_SurveyDatabaseSizeHistory WHERE LogDate < @RetainJobUntilDate
SET @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] from cf_SurveyDatabaseSizeHistory'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Delete unreferenced CustomerFeedbackXmlFile
DELETE	cf_CustomerFeedbackXmlFile
FROM	cf_CustomerFeedbackXmlFile A LEFT OUTER JOIN cf_CommservSurveyResults B
	ON A.ID = B.CustomerFeedbackXmlFile_ID
WHERE	B.CustomerFeedbackXmlFile_ID IS NULL
SET @nRow = @@ROWCOUNT
SET @TotalRows += @nRow
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] unreferenced CustomerFeedbackXmlFile'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
SET @ErrorString = 'PruneSurveyResults - Completed in ' + CAST(DATEDIFF(SS, @StartDate, GETUTCDATE()) AS VARCHAR(10)) + ' sec. Deleted '
	+ CAST(@TotalRows AS VARCHAR(20)) + ' rows.'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH
	SELECT	@ErrorCode = ERROR_NUMBER(), @ErrorString = ERROR_MESSAGE()
	SET		@ErrorString = 'Session ' + CAST(@@SPID AS VARCHAR(20)) + ' - Exception in PruneSurveyResults procedure. ERROR CODE: '
			+ CAST(@ErrorCode AS VARCHAR(20)) + ' ERROR MESSAGE: ' + ISNULL(@ErrorString, '')
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END CATCH
SELECT @ErrorCode AS 'ErrorCode', @ErrorString AS 'ErrorString'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PruneSurveyResults')
	delete from GxQscripts where name = 'PruneSurveyResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneSurveyResults')
	delete from GXDBVersions where aliasname = 'PruneSurveyResults'
GO

insert into GXDBVersions values(2, 'PruneSurveyResults',  '00010015000200530000', 'PruneSurveyResults', '00010015000200530000')
GO

