

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CommCellUsageReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CommCellUsageReport.sp,v $ $Id: QS_CommCellUsageReport.sp,v 1.78.2.25 2017/08/29 11:23:05 sbhukar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CommCellUsageReport <<<'

IF EXISTS (select * from sysobjects where name='QS_CommCellUsageReport')
	drop procedure QS_CommCellUsageReport
IF EXISTS (select * from GxQscripts where name='QS_CommCellUsageReport')
	delete from GxQscripts where name = 'QS_CommCellUsageReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommCellUsageReport')
	delete from GXDBVersions where aliasname = 'QS_CommCellUsageReport'
GO
print '... Creating Procedure: QS_CommCellUsageReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CommCellUsageReport
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- i_outputType: 0 = QScript output; 1 = report output; 2 = licGetUsageDetails (4 total sizes); 3 = Qscript for VM details
  @i_Param varchar(255)='',
  @i_bIncludeForeignJobs INT=0,
  @i_outputType INT=0
AS
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'CommCellUsageReport'
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------------------------------
-- By Last Month/Week options
DECLARE @BY_LAST_MONTH varchar(64) = 'ByLastMonth'
DECLARE @BY_LAST_WEEK  varchar(64) = 'ByLastWeek'
DECLARE @BY_LAST_DAY   varchar(64) = 'ByLastDay'
DECLARE @i_endDate DATETIME
DECLARE @i_endTime INT = 0x7FFFFFFF
IF	@i_Param = @BY_LAST_MONTH
BEGIN
	DECLARE	@CalendarId INT = -1
	SELECT	@CalendarId = id FROM APP_CustomCalendar WITH (NOLOCK) WHERE name = 'Chargeback'
	IF	@CalendarId > 1
		SELECT @i_endDate = startDate FROM APP_CustomCalendarMonths WITH (NOLOCK)
		WHERE  calendarId = @CalendarId AND startDate < GETDATE() AND endDate >= GETDATE()
	IF	@i_endDate IS NULL
		SET @i_endDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
END
ELSE
IF	@i_Param = @BY_LAST_WEEK
	SET @i_endDate = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
ELSE
IF	@i_Param = @BY_LAST_DAY
	SET @i_endDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
ELSE
IF	ISDATE(@i_Param) = 1
	SET @i_endDate = CAST(@i_Param AS DATETIME)
IF	@i_endDate IS NOT NULL
	SET @i_endTime = dbo.GetUnixTime(dbo.CellLocalToUTCTime(@i_endDate, 2))
--hide options
DECLARE @HIDDEN_CLIENT_NAME varchar(64)
SET @HIDDEN_CLIENT_NAME = 'HideClientName'
DECLARE @HIDDEN varchar(64)
SET @HIDDEN = 'XXX'
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
The following code should be the exact replica of [LicGetUsageDetails.sp]. #tempAppInfo has extra info though
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
DECLARE @in_startTime bigint
DECLARE @num_commcell int
DECLARE @bytesInTB bigint
DECLARE @num_daysforCalculation INTEGER
DECLARE @CommcellId int
SET	@CommcellId = 2
SET	@bytesInTB = 1099511627776
SELECT @num_commcell = number FROM APP_commcell WITH(NOLOCK) WHERE id = @CommcellId
IF @i_outputType = 0
	SELECT @scriptName + ' started for commcell [' + master.dbo.fn_varbintohexstr(CONVERT(VARBINARY(8), @num_commcell)) +').'
SET @num_daysforCalculation = ISNULL((SELECT attrVal FROM LicUsageBasedConfig WITH(NOLOCK) where attrName = 'IntervalToCalcUsage'), 90)
set @in_startTime = ( dbo.GetUnixTime(GETUTCDATE()) - (@num_daysforCalculation*24*60*60) )
--SELECT 'Licesen Usage History days [' + CAST(@num_daysforCalculation as varchar(256)) + ']'
IF @i_bIncludeForeignJobs > 0
	SET @CommcellId = 0
CREATE TABLE #tempAppSize		 (subClientId INT, isArchiver INT, t_client INT, t_appType INT, t_backupSetId INT, t_instanceId INT, size BIGINT, t_jobID INT, t_isEnterprise INT, t_bMultiInstances INT, t_ccID INT, t_VMList XML,subclientStatus INT, t_flag INT)
CREATE TABLE #tempAppInfo		 (appId INT,
								  jobId INT,
								  ClientName varchar(1024),
								  Clientid int,
								  AppTypeId int,
								  AppTypeName varchar(1024),
								  subClientName varchar(1024),
								  SPId int,
								  SPName varchar(1024),
								  bkupSetName varchar(1024),
								  instanceName varchar(1024),
								  UncompBytes float DEFAULT 0,
								  archiverApp int DEFAULT 0,
								  DedupEabled int,
								  SecondaryEncryption int,
				                  flag int)
-- 1: largest job
-- 2: most recent job
-- 3: archive job
-- 4: legal hold job -- in Archive buckets
-- 5: DDR jobs -- need to be counted in enterprise buckets
-- 6: move to tape jobs -- need to be counted in enterprise buckets
-- 7: NDMP job -- need to be counted in enterprise buckets
-- 8: jobs covered by jobs move to tapes -- need to be ignored
-- 9: turbo jobs/ref copy jobs -- in Archive buckets
--10: Commandline job counting for MAX DB-- Count all the streams in the Lastest Full Jobs.
-- Check Usage based license status
-- 1) Exclude VSA jobs if CV_STATUS_PERSONAL_WKSTN license is applied
-- 2.1) End point users -  (includes backup,  live browse,  DLP, privacy, sync, explorer plugin).  Exclude capacity consumption for these
-- 2.2) End point sharing users (includes edge drive (including uploads), sharing)  Exclude capacity consumption for these
-- 2.3) End point E-discovery users: Users doing CI/search, preview
DECLARE @usageLicTbl	TABLE (t_licType INT, t_licStatus INT)
INSERT INTO @usageLicTbl VALUES (100024, 0)
INSERT INTO @usageLicTbl VALUES (100025, 0)
INSERT INTO @usageLicTbl VALUES (100026, 0)
DECLARE @bExcludeVSAJobs INT = 0
DECLARE @bExcludeArchivedVMJobs INT = 0
DECLARE @bExcludeDLPJobs INT = 0
DECLARE @bExcludeEdgeDrive INT = 0
DECLARE @bExcludeVMAppClass1 INT = 0
DECLARE @bExcludeMSimJobs INT = 0
DECLARE @LicType    INT
DECLARE @evalFld    varchar(2048)
DECLARE @permFld    varchar(2048)
DECLARE @LicStatus  INT
DECLARE GetUsageLicStatus CURSOR FOR SELECT t_licType FROM @usageLicTbl
OPEN GetUsageLicStatus
FETCH NEXT FROM GetUsageLicStatus INTO @LicType
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @LicStatus = 0
	SET @evalFld = ''
	SET @permFld = ''
	SELECT @evalFld = eval_fld1, @permFld = perm_fld1 FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = @LicType
	IF LEN(@permFld) > 0
		SET @LicStatus = 1
	ELSE IF LEN(@evalFld) > 0
	BEGIN
		--check licUsage table
		DECLARE @expTime BIGINT = 0
		SET @evalFld = ''
		SELECT @evalFld = EncryptedField FROM LicUsage WITH (NOLOCK) WHERE CId = 2 AND LicType = @LicType
		IF LEN(@evalFld) > 0
			EXEC isLicenseValidManaged @evalFld, @expTime OUTPUT, @LicStatus OUTPUT, @errorString OUTPUT
		ELSE
			-- license is not enforced
			SET @LicStatus = 1
	END
	IF @LicStatus > 0
		UPDATE @usageLicTbl SET t_licStatus = @LicStatus WHERE t_licType = @LicType
	FETCH NEXT FROM GetUsageLicStatus INTO @LicType
END
CLOSE GetUsageLicStatus
DEALLOCATE GetUsageLicStatus
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bExcludeVSAJobs = CASE WHEN @licAppliedStatus&0x1 > 0 OR @licAppliedStatus&0x2 > 0
								THEN 1 ELSE 0 END
SELECT @bExcludeArchivedVMJobs = @licAppliedStatus&0x4
SELECT @bExcludeVMAppClass1 = @licAppliedStatus&0x40
SELECT @bExcludeMSimJobs = @licAppliedStatus&0x80
SELECT @bExcludeDLPJobs = CASE WHEN @licAppliedStatus&0x8 > 0
OR @licAppliedStatus&0x10 > 0
OR @licAppliedStatus&0x20 > 0
									THEN 1 ELSE 0 END
SELECT @bExcludeEdgeDrive = CASE WHEN @licAppliedStatus&0x10 > 0
OR @licAppliedStatus&0x20 > 0
									THEN 1 ELSE 0 END
END
ELSE
BEGIN
	SELECT @bExcludeVSAJobs = ISNULL((SELECT simLicAppTypeId FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100019, 100018)), 0)
	SELECT @bExcludeArchivedVMJobs = ISNULL((SELECT simLicAppTypeId FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = 100021),0)
	SELECT @bExcludeVMAppClass1 = ISNULL((SELECT simLicAppTypeId FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100027)), 0)
	SELECT @bExcludeMSimJobs = ISNULL((SELECT simLicAppTypeId FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100028)), 0)
	SELECT @bExcludeDLPJobs = MAX(t_licStatus) FROM @usageLicTbl WHERE t_licType IN (100024, 100025, 100026)
	SELECT @bExcludeEdgeDrive = MAX(t_licStatus) FROM @usageLicTbl WHERE t_licType IN (100025, 100026)
END
CREATE TABLE #tempJobInfo		 (t_type INT, t_appId INT, t_jobID INT, t_size BIGINT, t_jobIdActedOn INT, t_ccID INT)
CREATE CLUSTERED INDEX tempJobInfo_idx ON #tempJobInfo (t_type, t_ccID, t_jobID)
--get a list of subclients
--Excldue the silo apps
--USE t_ccID for @i_bIncludeForeignJobs option: set t_ccID = 0 for deconfigured/deleted/activity disabled subclients
INSERT INTO #tempAppSize
SELECT	DISTINCT A.id,
		(CASE	WHEN A.appTypeId in (124,137) THEN 1
			WHEN ISNULL(I.isDMAppType, 0) = 1 THEN 1
WHEN A.subclientStatus & 0x10000 > 0 THEN 1
			ELSE 0 END),
		A.clientId, A.appTypeId, A.backupset, A.instance, 0, 0,
0,0, (CASE WHEN (A.subclientStatus & 6) = 0 THEN 2 ELSE 0 END), '',A.subclientStatus, 0x0
FROM	APP_Application A WITH(NOLOCK) LEFT OUTER JOIN APP_IDATypeHandlingInfo I WITH(NOLOCK) ON I.appTypeId = A.appTypeId
WHERE	A.id NOT in (SELECT siloAppId FROM archGroupCopy WITH(NOLOCK)) AND A.appTypeId <> 1064 AND
	(@i_bIncludeForeignJobs > 0 OR (A.subclientStatus & 6) = 0) AND
	(@bExcludeVSAJobs = 0 OR @i_outputType = 4 OR A.appTypeId <> 106 )
IF @i_bIncludeForeignJobs <= 0
BEGIN
	DELETE FROM #tempAppSize WHERE EXISTS
	(select appId from JMJobAction WITH(NOLOCK) where appId = subClientId and action = 1 and opType = 4)
	--Exclude clients for SOLR backup Mr=189490
	DELETE #tempAppSize
	FROM	APP_ClientProp WITH(NOLOCK)
	where attrName = 'Index Server Type' and attrVal = '6' and modified = 0 and componentNameId = t_client
END
IF @i_outputType <> 4
	DELETE #tempAppSize
	FROM	APP_CLient C WITH(NOLOCK)
	WHERE	 t_client = C.id AND
(@bExcludeEdgeDrive > 0 AND (C.status & 0x10000000) > 0 OR @bExcludeDLPJobs > 0 AND (C.status & 0x1000) > 0)
IF object_id('tempdb.dbo.#tempVMsWithIdAppType') IS NOT null DROP TABLE #tempVMsWithIdAppType
CREATE TABLE #tempVMsWithIdAppType(t_Id INT, t_appTypeId INT)
IF @bExcludeVMAppClass1 > 0 AND @i_outputType <> 4
BEGIN
	EXEC LicGetVMAppcalss1 '#tempVMsWithIdAppType'
	DELETE #tempAppSize FROM #tempVMsWithIdAppType WHERE t_client = t_Id AND t_appType = t_appTypeId
	TRUNCATE TABLE #tempVMsWithIdAppType
END
--Exclude Jobs if MSim is Applied
IF @bExcludeMSimJobs > 0 AND @i_outputType <> 4
BEGIN
	DECLARE @o_isValidApptype INT
	DECLARE @o_appTypeList NVARCHAR(1024) = ''
	EXEC LicGetMSimAppType -1,0,@o_isValidApptype OUTPUT, @o_appTypeList OUTPUT
	IF @o_appTypeList <> ''
		DELETE #tempAppSize WHERE t_appType in (select _ID from dbo.SplitIDs(@o_appTypeList))
	-- Exclude Gmail and Gdrive.
	DELETE #tempAppSize FROM
	(SELECT t_instanceId AS instanceId FROM #tempAppSize INNER JOIN
	APP_InstanceProp Prop WITH (NOLOCK) ON t_instanceId = Prop.componentNameId
WHERE t_appType = 134 AND attrName = 'Cloud Apps Instance Type' AND attrVal in ('1','2') ) T  --CV_APPTYPE_CLOUD_APPS
	WHERE instanceId = t_instanceId
END
--Exclude DDB subclients
DELETE #tempAppSize
FROM APP_subclientProp WITH(NOLOCK)
WHERE subClientId = componentNameId AND attrName IN ('DDB Backup', 'Index SubClient') AND attrVal <> '0' AND modified = 0
--Exclude deconfigured agents
if @i_bIncludeForeignJobs = 0
DELETE #tempAppSize
FROM APP_iDAName WITH(NOLOCK)
WHERE clientId = t_client AND appTypeId = t_appType AND (Status & 6) > 0
--Exclude Content Indexing clients
--Create temp table. This temp table will be populated by AppGetFastServerList
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCIEngineDataForLicCapacity'))
DROP TABLE #tmpCIEngineDataForLicCapacity
CREATE TABLE #tmpCIEngineDataForLicCapacity (      serverName    NVARCHAR(MAX)
	                                , clientId      INT
	                                , clientName    NVARCHAR(MAX)
	                                , cloudId       INT
	                                , hostName  NVARCHAR(MAX)
	                                , baseport  INT
	                                , version       VARCHAR(1024)
	                                , engineName    VARCHAR(1024)
									, serverType  INT
	                              )
exec AppGetFastServerList
DELETE #tempAppSize
WHERE EXISTS (select * from #tmpCIEngineDataForLicCapacity where clientId = t_client)
DROP TABLE #tmpCIEngineDataForLicCapacity
--Exclude (DM2)SQL Backup run on the WeBServer Client.
DELETE #tempAppSize
FROM APP_subclientProp WITH(NOLOCK)
WHERE subClientId = componentNameId AND
attrName = 'DM2' AND attrVal <> '0' AND modified = 0 AND t_appType=81
AND EXISTS(
select a.ClientId from simInstalledPackages a WITH(NOLOCK) , APP_ClientProp b WITH(NOLOCK)
where a.ClientId=b.componentNameId and a.ClientId =t_client and a.simPackageID=803
and b.attrname like '%DM2WebService%' AND b.attrVal <>'0' AND b.modified=0 )
IF @i_bIncludeForeignJobs > 0
	UPDATE #tempAppSize
	SET	t_ccID = 0
	WHERE	EXISTS (select * from JMJobAction WITH(NOLOCK) where appId = subClientId and action = 1 and opType = 4)
DECLARE @tempJobStatus TABLE(jobStatus INT)
INSERT INTO @tempJobStatus VALUES (1),(3),(14),(16)
DECLARE @tempJobBkpLevel TABLE(bkpLevel INT)
INSERT INTO @tempJobBkpLevel VALUES (1),(64),(128),(1024),(16384),(32768)
--get a list of jobs from JMBkpStats table
IF object_id('tempdb.dbo.#BKPJOBS') IS NOT null DROP TABLE #BKPJOBS
CREATE TABLE #BKPJOBS (	jobId			integer,
			commCellId		integer,
			appId			integer,
			appType			integer,
			bkpLevel		integer,
			status			integer,
			servStartDate		integer,
			servEndDate		integer,
			opType			integer,
			fullCycleNum		integer,
			totalUncompBytes	bigint,
			bkpattributes		bigint,
			dataStatus		integer,
			jobIdActedOn		integer	)
CREATE CLUSTERED INDEX BKPJOBS_idx ON #BKPJOBS (appId, commCellId, jobId, jobIdActedOn)
INSERT INTO #BKPJOBS
SELECT B.jobId, B.commCellId, B.appId, B.appType, B.bkpLevel, B.status, B.servStartDate, B.servEndDate, B.opType, B.fullCycleNum, B.totalUncompBytes, B.bkpattributes, B.dataStatus, B.jobIdActedOn
FROM	JMBkpStats B WITH(NOLOCK) JOIN #tempAppSize ON appId = subClientId AND t_ccID = 2
WHERE	commcellID = 2 AND status in (SELECT jobStatus FROM @tempJobStatus) AND dataStatus = 0 AND opType NOT IN (65) AND B.servEndDate <= @i_endTime
IF @i_bIncludeForeignJobs > 0
	INSERT INTO #BKPJOBS
	SELECT B.jobId, B.commCellId, B.appId, B.appType, B.bkpLevel, B.status, B.servStartDate, B.servEndDate, B.opType, B.fullCycleNum, B.totalUncompBytes, B.bkpattributes, B.dataStatus, B.jobIdActedOn
	FROM	JMBkpStats B WITH(NOLOCK) JOIN #tempAppSize ON appId = subClientId AND t_ccID = 0
	WHERE	status in (SELECT jobStatus FROM @tempJobStatus) AND dataStatus = 0 AND opType NOT IN (65) AND B.servEndDate <= @i_endTime
-- 5: get DDR jobs
INSERT INTO #tempJobInfo
SELECT DISTINCT 5, B.appId, B.jobID, B.totalUncompBytes, 0, B.commcellId
FROM	#BKPJOBS B JOIN SMVolume V WITH(NOLOCK) ON B.commcellId = V.CommcellId AND B.jobID = V.jobID AND B.appId = V.appId
WHERE	originClientId > 0 AND bkpLevel in (SELECT bkpLevel FROM @tempJobBkpLevel) AND (opType NOT IN (59) OR jobIdActedOn = B.jobId)
-- 6: move to tape jobs
INSERT INTO #tempJobInfo
SELECT DISTINCT (CASE WHEN bkpLevel in (SELECT bkpLevel FROM @tempJobBkpLevel) THEN 6 ELSE 1006 END), appId, jobID, totalUncompBytes, jobIdActedOn, commcellId
FROM	#BKPJOBS T1
WHERE	opType = 60 AND jobIdActedOn > 0 AND EXISTS (select * from #BKPJOBS T2 where T2.commcellId = T1.commcellId and T2.jobId = T1.jobIdActedOn and T2.dataStatus = 0 )
-- 7: NDMP jobs
INSERT INTO #tempJobInfo
SELECT DISTINCT (CASE WHEN bkpLevel in (SELECT bkpLevel FROM @tempJobBkpLevel) THEN 7 ELSE 1007 END), appId, jobID, totalUncompBytes, jobIdActedOn, commcellId
FROM	#BKPJOBS
WHERE	appType = 13 AND (opType NOT IN (59) OR jobIdActedOn = jobId)
-- 8: jobs covered by jobs move to tapes
INSERT INTO #tempJobInfo
SELECT DISTINCT 8, appId, jobID, 0, jobIdActedOn, commcellId
FROM	#BKPJOBS JOIN #tempJobInfo ON jobID = t_jobIdActedOn and commcellId = t_ccId AND (opType NOT IN (59) OR jobIdActedOn = jobId)
-- 9: Turbo jobs
-- t_type: 1 -> Turbo; 2 -> ref copy
IF object_id('tempdb.dbo.#TurboSubclients') IS NOT null DROP TABLE #TurboSubclients
IF object_id('tempdb.dbo.#TurboJobs') IS NOT null DROP TABLE #TurboJobs
IF object_id('tempdb.dbo.#tempSubclientId') IS NOT null DROP TABLE #tempSubclientId
CREATE TABLE #TurboSubclients (t_appId INT, t_type INT, t_skipLastCycle INT, t_newArchiveRetPropId INT)
CREATE TABLE #TurboJobs (t_appId INT, t_jobId INT, t_size BIGINT, fullCycleNum INT, t_ccId INT)
CREATE TABLE #tempSubclientId (t_appId INT, t_newArchiveRetPropId INT, t_turboSubClientPropId INT)
--First insert subclient ID in all the columns
INSERT INTO #tempSubclientId
SELECT subClientId, subClientId, subClientId
FROM #tempAppSize
WHERE t_appType IN
(
	SELECT type from APP_iDAType WHERE
	type < 600 and type not in (28,86)
	and (name like '%file%system%' or type in (select appTypeId from simAppTypeLicTypeMap where display_name = 'File System')
	OR type in (13,54,22,80))
)
-- If subclinet policy id is set look for 'Is Turbo Subclient' against subclient policy Id
-- If subclinet policy id and key is set look for new archive retention property against subclient policy Id
-- Else look against subclient id
-------------------------------------------------------------------------------------------------------------------------------------------------
--SubclientPolicy		Subclient Policy Has Retention			New Archive Retention Prop		Is Turbo Subclient Prop		Honor Archiver Agent Retention
--SET						NOT SET									Subclient ID					Subclient Policy				Subclient ID
--SET						SET										Subclient Policy				Subclient Policy				Subclient ID
--NOT SET					NOT SET									Subclient ID					Subclient ID					Subclient ID
--------------------------------------------------------------------------------------------------------------------------------------------------
UPDATE #tempSubclientId SET t_newArchiveRetPropId = (CASE WHEN newPolicyId > 0 AND policyKey > 0 THEN newPolicyId ELSE componentNameId END),
t_turboSubClientPropId = CASE WHEN newPolicyId > 0 THEN newPolicyId ELSE componentNameId END
FROM (SELECT componentNameId, ISNULL([Associated subclient Policy], 0) AS newPolicyId, ISNULL([Subclient Policy Has Retention],0) AS policyKey
		FROM ( SELECT  componentNameId, attrName, CAST(attrVal AS INT) attrVal
			   FROM APP_subclientProp prop WITH(NOLOCK)
			   WHERE attrName in ('Associated subclient Policy','Subclient Policy Has Retention') AND modified = 0 ) AS B
		PIVOT	( MAX(attrVal) FOR attrName IN (  [Associated subclient Policy], [Subclient Policy Has Retention] ) ) AS P) T
WHERE T.componentNameId = t_appId
--- Turbo Subclients should count against Archive bucket.
INSERT INTO #TurboSubclients
SELECT	t_appId , 1 ,0, t_newArchiveRetPropId
FROM #tempSubclientId A JOIN APP_subclientProp prop WITH(NOLOCK) ON prop.componentNameId = A.t_turboSubClientPropId
AND attrName = 'Is Turbo Subclient' and prop.attrval='1' and prop.modified = 0
DELETE #TurboSubclients FROM
(SELECT componentNameId, ISNULL([Is Backup Retention Mode Enabled], 0) AS BkpRetentionMode, ISNULL([Is Archive Retention Mode Enabled],0) AS ArchRetentionMode
		FROM ( SELECT  componentNameId, attrName, CAST(attrVal AS INT) attrVal
			   FROM APP_subclientProp prop WITH(NOLOCK) JOIN #TurboSubclients A ON prop.componentNameId = t_newArchiveRetPropId
			   WHERE attrName IN ('Is Backup Retention Mode Enabled','Is Archive Retention Mode Enabled') AND attrval = '1' AND modified = 0 ) AS B
		PIVOT	( MAX(attrVal) FOR attrName IN (  [Is Backup Retention Mode Enabled], [Is Archive Retention Mode Enabled] ) ) AS P) T
WHERE T.componentNameId = t_appId AND BkpRetentionMode = 1 AND ArchRetentionMode = 0
UPDATE #TurboSubclients SET t_skipLastCycle = 1
FROM APP_subclientProp prop WITH(NOLOCK)
WHERE prop.componentNameId = t_appId AND prop.attrName = 'Honor Archiver Agent Retention'
AND prop.attrVal = '1' AND prop.modified = 0
UPDATE #tempAppSize SET isArchiver = 1
FROM #TurboSubclients WHERE subClientId = t_appId AND t_skipLastCycle = 1
INSERT INTO #TurboSubclients
SELECT	subClientId, 2, 0, 0
FROM	#tempAppSize	JOIN APP_Application A WITH(NOLOCK) ON subClientId = A.id
WHERE	(A.subclientStatus & 0x10000) > 0
INSERT	#TurboJobs
SELECT	appId, jobID, totalUncompBytes, fullCycleNum, commcellId
FROM	JMBkpStats WITH(NOLOCK) JOIN #TurboSubclients ON appId = t_appId AND t_skipLastCycle = 0
WHERE	@CommcellId in (0, commcellID) AND status in (SELECT jobStatus FROM @tempJobStatus) AND dataStatus = 0 AND totalUncompBytes > 0 AND servEndDate <= @i_endTime
INSERT INTO #tempJobInfo
SELECT DISTINCT 9, t_appId, t_jobId, t_size, 0, t_ccId
FROM	#TurboJobs T
WHERE	fullCycleNum = (select MAX(fullCycleNum) FROM #TurboJobs T2 WHERE T2.t_appId = T.t_appId)
DROP TABLE #TurboSubclients
DROP TABLE #TurboJobs
--10: Commandline job counting for MAX DB
IF object_id('tempdb.dbo.#AllDBCmdlineSubClients') IS NOT null DROP TABLE #AllDBCmdlineSubClients
IF object_id('tempdb.dbo.#AllDBAgentJobs') IS NOT null DROP TABLE #AllDBAgentJobs
CREATE TABLE #AllDBCmdlineSubClients (t_subClientId INT, t_apptype int,t_client int, PRIMARY KEY(t_subClientId))
CREATE TABLE #AllDBAgentJobs (t_appId INT, t_jobId INT,t_totalUncompBytes BIGINT, t_commcellId int, t_client int, t_apptype int, t_release int,t_servStartDate INT, t_servEndDate INT, t_jobIdActedOn INT, PRIMARY KEY(t_appId, t_jobId))
-- Step 1: Get All Command Line SubClients:
INSERT INTO #AllDBCmdlineSubClients
SELECT subClientId,t_appType,t_client
FROM #tempAppSize WHERE subclientStatus&64 >0 and isArchiver = 0 AND t_appType in (3,22,37,61,62,79,80,103)
-- Step 1: Get All Jobs for the Command Line SubClients:
INSERT INTO #AllDBAgentJobs
SELECT	appId,jobId, totalUncompBytes,commcellId, t_client,t_appType,0,servStartDate,servEndDate,jobIdActedOn
FROM	#BKPJOBS JOIN #AllDBCmdlineSubClients ON appId = t_subClientId AND bkpLevel in (SELECT bkpLevel FROM @tempJobBkpLevel)
DELETE #AllDBAgentJobs FROM #AllDBAgentJobs A INNER JOIN #tempJobInfo B ON A.t_jobId = B.t_jobID AND A.t_commcellId = B.t_ccID AND t_type <> 1
DELETE #AllDBAgentJobs
FROM	#AllDBAgentJobs T1
WHERE	t_jobIdActedOn > 0 AND NOT EXISTS (select * from #tempJobInfo T2 where t_type IN (6, 1006) and T2.t_size > 0 and T2.t_ccID = T1.t_commcellId and T1.t_jobId = T2.t_jobId and T1.t_jobIdActedOn = T2.t_jobIdActedOn)
-- Step 3 : Find the largest job get largest full and parallel jobs that ran along with it
IF object_id('tempdb.dbo.#tblDBAgentJobs') IS NOT null DROP TABLE #tblDBAgentJobs
CREATE TABLE #tblDBAgentJobs (t_appId INT, t_jobID INT, t_size BIGINT, t_ccID INT,t_servStartDate INT, t_servEndDate INT)
INSERT INTO #tblDBAgentJobs
SELECT A.t_appId,a.t_jobid , A.t_totalUncompBytes,t_commcellId, t_servStartDate INT, t_servEndDate INT
FROM #AllDBAgentJobs A JOIN (
SELECT b.t_appId, b.t_totalUncompBytes, max(t_jobid) maxJobid FROM #AllDBAgentJobs B JOIN (
	SELECT t_appId,MAX(t_totalUncompBytes) maxTotalUncompBytes	FROM #AllDBAgentJobs GROUP BY t_appId) AS t
	ON B.t_appId = t.t_appId AND B.t_totalUncompBytes = t.maxTotalUncompBytes GROUP BY B.t_appId, B.t_totalUncompBytes) AS C
	ON A.t_jobId = C.maxJobid
-- Step: 4 Update Sum of the jobsize for the latest job ran period
UPDATE T1
SET t_size = (SELECT SUM(t_totalUncompBytes) FROM #AllDBAgentJobs B  where
B.t_appId =T1.t_appId and B.t_commcellId =T1.t_ccID and (B.t_servStartDate <= T1.t_servEndDate AND B.t_servEndDate >= T1.t_servStartDate) )
FROM #tblDBAgentJobs AS T1
INNER JOIN #AllDBCmdlineSubClients T2
ON T1.t_appId= T2.t_subClientId
DROP TABLE #AllDBCmdlineSubClients
DROP TABLE #AllDBAgentJobs
-- Step: 5 Insert into tempJobInfo table..
INSERT INTO #tempJobInfo SELECT	10, t_appId, t_jobID, t_size, 0, t_ccID  FROM	#tblDBAgentJobs
-- Step: 6 Insert into #tempAppSize table ..
INSERT INTO #tempAppSize
SELECT	subClientId, 0, t_client, t_appType, t_backupSetId, t_instanceId, t_size, J.t_jobId, 0, 0, J.t_ccID,'',subclientStatus, 0x0
FROM	#tempJobInfo J JOIN #tempAppSize A ON subClientId = t_appId
WHERE	t_type in (10)
--get the latest full backup
IF object_id('tempdb.dbo.#lastFullTbl') IS NOT null DROP TABLE #lastFullTbl
CREATE TABLE #lastFullTbl (t_appId INT, t_isArchiver INT, t_jobId INT)
-- For blocklevel snap jobid is same as jobidactedon. count this job in backup bucket
INSERT INTO #lastFullTbl
SELECT	appID, isArchiver, MAX(jobId)
FROM	#BKPJOBS JOIN #tempAppSize ON appId = subClientId AND (isArchiver = 0 OR t_appType = 106) AND (opType NOT IN (59) OR jobIdActedOn = jobId)
LEFT OUTER JOIN #tempJobInfo C ON jobID = C.t_jobId AND commcellId = C.t_ccId AND t_type <> 1
WHERE	bkpLevel in (SELECT bkpLevel FROM @tempJobBkpLevel) AND (appType = 106 OR C.t_jobID IS NULL) --AND servStartDate >= @in_startTime
and not exists (select 1 from #tblDBAgentJobs where appId = t_appId AND t_size > 0) --Exclude commandline subclients for DB Agents.
and (jobIdActedOn = 0 OR jobIdActedOn = jobId)
GROUP BY appID, isArchiver
DROP TABLE #tblDBAgentJobs
INSERT INTO #tempJobInfo
SELECT	1, appId, jobId, totalUncompBytes, 0, commcellId
FROM	#BKPJOBS JOIN #lastFullTbl ON appId = t_appId AND t_jobId = jobId AND t_isArchiver = 0
UPDATE #tempAppSize
SET	t_jobID = T.t_jobID, size = T.t_size, t_ccId = T.t_ccId
FROM	#tempJobInfo T
WHERE	t_type = 1 AND subClientId = T.t_appId
--excluded Jobs with data moved to tape
UPDATE	#tempJobInfo
SET	t_size = 0
FROM	#tempJobInfo T1
WHERE	EXISTS (select * from #tempJobInfo T2 where T2.t_type = 6 AND T1.t_jobID = T2.t_jobIdActedOn and T1.t_ccId = T2.t_ccId)
--add NDMP, DDR & move to tape jobs into enterprise bucket
INSERT INTO #tempAppSize
SELECT	subClientId, isArchiver, t_client, t_appType, t_backupSetId, t_instanceId, SUM(J.t_size), MAX(J.t_jobId), 1, 0, J.t_ccID, '',subclientStatus, 0x0
FROM	#tempJobInfo J JOIN #tempAppSize A ON subClientId = t_appId
WHERE	t_type in (5, 6, 7, 1005, 1006, 1007) AND isArchiver > 0
GROUP BY subClientId, isArchiver, t_client, t_appType, t_backupSetId, t_instanceId, J.t_ccID,subclientStatus
INSERT INTO #tempAppSize
SELECT	subClientId, isArchiver, t_client, t_appType, t_backupSetId, t_instanceId, -1, MAX(J.t_jobId), 1, 0, J.t_ccID, '',subclientStatus, 0x0
FROM	#tempJobInfo J JOIN #tempAppSize A ON subClientId = t_appId
WHERE	t_type in (5, 6, 7) AND isArchiver = 0
GROUP BY subClientId, isArchiver, t_client, t_appType, t_backupSetId, t_instanceId, J.t_ccID,subclientStatus
UPDATE #tempAppSize
SET	size = totalUncompBytes
FROM	#BKPJOBS
WHERE	size = -1 AND jobId = t_jobId and appId = subClientId and commcellId = t_ccId AND (opType NOT IN (59) OR jobIdActedOn = jobId)
-- make sure only 1 job is counted per subclient
UPDATE	#tempAppSize
SET	size = 0
FROM	#tempAppSize T1
WHERE	EXISTS (select * from #tempAppSize T2 where T2.size > 0 AND T2.subClientId = T1.subClientId and T2.t_ccId = T1.t_ccId And T2.t_jobID > T1.t_jobID)
-- For NAS if the snapshot is taken by commvault we should not count the backup copy towards capacity license calculation.
IF object_id('tempdb.dbo.#ndmpAppTypeTbl') IS NOT null DROP TABLE #ndmpAppTypeTbl
CREATE TABLE #ndmpAppTypeTbl (t_appId INT, jobId INT)
INSERT INTO #ndmpAppTypeTbl
SELECT subClientId, t_jobId FROM #tempAppSize WHERE t_appType = 13 and size > 0
IF EXISTS(SELECT * FROM #ndmpAppTypeTbl)
BEGIN
	IF object_id('tempdb.dbo.#archFileIdTbl') IS NOT null DROP TABLE #archFileIdTbl
	CREATE TABLE #archFileIdTbl (t_archFileId INT)
	INSERT INTO #archFileIdTbl
	SELECT archFileId FROM archFileCopy WITH (NOLOCK) WHERE flags&0x4000 > 0 -- CVA_BACKUPSNAPCOPY_FLAG
	IF EXISTS(SELECT * FROM #archFileIdTbl)
	BEGIN
		DELETE #tempAppSize FROM #ndmpAppTypeTbl A INNER JOIN archFile arc WITH (NOLOCK) ON A.jobId = arc.jobId
		INNER JOIN #archFileIdTbl arcCpy ON arcCpy.t_archFileId = arc.id
		WHERE subClientId = t_appId AND t_jobId = A.jobId
	END
	DROP TABLE #archFileIdTbl
END
DROP TABLE #ndmpAppTypeTbl
-- Exclude agents supporting multiple instances
UPDATE #tempAppSize
SET	t_bMultiInstances = 1
WHERE	EXISTS (select * from APP_InstanceName WITH(NOLOCK) where id = t_instanceId and name NOT LIKE 'defaultInstance%')
UPDATE #tempAppSize
SET		t_bMultiInstances = CASE WHEN name like 'DB2%' THEN 2 ELSE 3 END
FROM	APP_iDAType
WHERE	type = t_appType AND (name like 'Oracle %' OR name like 'DB2%' OR name like 'SAP%Oracle' OR name like 'Informix%')
-- For Oracle & SAP,Informix Database count largest subclient for each instance
UPDATE	#tempAppSize
SET	size = 0, t_jobID = 0
FROM	(	SELECT	instID = A.t_instanceId, maxSize = MAX(A.size)
		FROM	#tempAppSize A
		WHERE	A.t_bMultiInstances = 3
		GROUP BY A.t_instanceId) T
WHERE	t_bMultiInstances = 3 AND t_instanceId = instID AND size < maxSize AND isArchiver = 0
-- For DB2, count largest subclient for each backupset
;WITH Backupset_CTE (appId,backupSetId,row_num)
AS
(
SELECT	subClientId,t_backupSetId,ROW_NUMBER() OVER (PARTITION BY t_backupSetId ORDER BY size DESC) AS RowNumber
		FROM	#tempAppSize A
		WHERE	A.t_bMultiInstances = 2 AND isArchiver = 0 AND size > 0
)
UPDATE	#tempAppSize
SET	size = 0, t_jobID = 0
FROM Backupset_CTE T
WHERE	t_bMultiInstances = 2 AND subClientId = T.appId AND row_num > 1
--get the SUM of archiver without any time range
INSERT INTO #tempJobInfo
SELECT	3, appId, MAX(jobId), SUM(totalUncompBytes), 0, MIN(commcellId)
FROM	#BKPJOBS JOIN #tempAppSize ON appId = subClientId AND isArchiver = 1
WHERE	NOT EXISTS (select * from #tempJobInfo J where jobID = J.t_jobId and commcellId = J.t_ccId) AND (opType NOT IN (59) OR jobIdActedOn = jobId)
GROUP BY appID
UPDATE	#tempAppSize
SET	size = T.t_size, t_jobID = T.t_jobID, t_ccId = T.t_ccId
FROM	#tempJobInfo T
WHERE	subClientId = T.t_appId and T.t_type = 3
--get legal hold jobs
IF object_id('tempdb.dbo.#legalHoldTbl') IS NOT null DROP TABLE #legalHoldTbl
CREATE TABLE #legalHoldTbl (t_jobId INT, t_ccId INT, t_xmlJobInfo XML)
INSERT INTO #legalHoldTbl
SELECT	jobid, commcellID, SUBSTRING(xmlJobInfo, CHARINDEX('>', xmlJobInfo)+1, LEN(xmlJobInfo))
FROM	JMJobStats WITH(NOLOCK)
WHERE	@CommcellId in (0, commcellID) AND opType = 64
DELETE	#legalHoldTbl
WHERE	t_xmlJobInfo.value('(JobManager_AdminJobDetailsXml/compPolicyJobInfo/compliancePolicyInfo/@phaseDetails)[1]', 'INT') & 0x10 = 0
INSERT INTO #tempJobInfo
SELECT	4, appId, MAX(jobId), SUM(totalBackupSize), 0, MIN(commcellID)
FROM	JMAdminJobStatsTable A WITH(NOLOCK) JOIN #legalHoldTbl ON commcellID = t_ccId AND jobId = t_jobId
WHERE	status in (SELECT jobStatus FROM @tempJobStatus) AND dataStatus = 0 AND servEnd <= @i_endTime
GROUP BY appId
DROP TABLE #legalHoldTbl
DELETE #tempJobInfo
WHERE t_appId NOT IN (select subclientId from #tempAppSize)
UPDATE	#tempAppSize
SET	size = size + T.t_size, t_jobID = (CASE WHEN S.t_jobID > T.t_jobID THEN S.t_jobID ELSE T.t_jobID END), t_ccId = T.t_ccId
FROM	#tempAppSize S, #tempJobInfo T
WHERE	t_type = 4 AND subClientId = T.t_appId and isArchiver > 0
INSERT INTO #tempAppSize
SELECT	t_appID, 1, clientId, apptypeId, backupset, instance, t_size, t_jobID, 0, 0, t_ccId, '',subclientStatus, 0x0
FROM	#tempJobInfo JOIN APP_Application WITH(NOLOCK) ON id=t_appId
WHERE	t_type = 4 AND t_appID NOT in(select subclientId from #tempAppSize where isArchiver > 0)
-- add Turbo jobs into archiver bucket
UPDATE	#tempAppSize
SET	size = 0, t_jobID = 0
WHERE	t_appType <> 106 AND EXISTS (select * from #tempJobInfo where subClientId = t_appId and t_type = 9)
INSERT INTO #tempAppSize
SELECT	subClientId, case when t_appType IN (22,80) then 0 else 1 end , t_client, t_appType, t_backupSetId,
t_instanceId, SUM(J.t_size), MAX(J.t_jobId), 0, 0, J.t_ccID, '',subclientStatus, 0x0
FROM	#tempJobInfo J JOIN #tempAppSize A ON subClientId = t_appId AND t_appType <> 106
WHERE	t_type = 9 AND t_isEnterprise=0
GROUP BY subClientId, isArchiver, t_client, t_appType, t_backupSetId, t_instanceId, J.t_ccID,subclientStatus
-- Multiple backupset of same client/apptype, count only the biggest backset and ignore others.
IF object_id('tempdb.dbo.#BkpSetSizeTbl') IS NOT null DROP TABLE #BkpSetSizeTbl
CREATE TABLE #BkpSetSizeTbl (id INT IDENTITY (1,1), clId INT, appTypeId INT, bkpSet INT, sizeSum BIGINT)
INSERT INTO #BkpSetSizeTbl
SELECT	t_client, t_appType, t_backupSetId, sizeSum=SUM(size)
FROM	#tempAppSize
WHERE	t_bMultiInstances = 0 AND isArchiver = 0
GROUP BY t_client, t_appType, t_backupSetId
ORDER BY t_client, t_appType, sizeSum desc, t_backupSetId
UPDATE	#tempAppSize
SET	size = 0, t_jobID = 0
FROM	(select clId, appTypeId, bkpSet from #BkpSetSizeTbl B1 where not exists (select * from #BkpSetSizeTbl B2 where B1.clId=B2.clId and B1.appTypeId=B2.appTypeId and B1.id > B2.id)) T
WHERE	clId=t_client AND appTypeId=t_appType AND bkpSet<>t_backupSetId AND isArchiver = 0
DROP TABLE #BkpSetSizeTbl
-- For DAG clients, count largest DAG client per DAG group when [ExDAGCombineLicense] flag is enabled in GxGlobalParam
IF EXISTS (select * from GxGlobalParam WITH(NOLOCK) where name ='ExDAGCombineLicense' and value = '1' and modified = 0)
BEGIN
	IF object_id('tempdb.dbo.#DAGClients') IS NOT null DROP TABLE #DAGClients
	CREATE TABLE #DAGClients (t_id INT NOT NULL IDENTITY (1,1), t_clientId INT, t_DAGName VARCHAR(MAX), t_size BIGINT)
	INSERT INTO #DAGClients
	SELECT	componentNameId, attrVal, t_size = (select SUM(size) from #tempAppSize where t_client = componentNameId)
	FROM	APP_ClientProp WITH(NOLOCK)
	WHERE	attrName = 'DAG Name' and modified = 0
	ORDER BY attrVal, t_size
	DELETE	#DAGClients
	FROM	#DAGClients D JOIN (select t_DAGName, id=MAX(t_id) from #DAGClients group by t_DAGName) T ON D.t_id = T.id
	UPDATE	#tempAppSize
	SET	size = 0
	FROM	#DAGClients
	WHERE	t_client = t_clientId AND t_appType <> 106
	DROP TABLE #DAGClients
END
-- 10: VSA jobs: count unique VM size in last FULL/Synthetic FULL jobs of each VSA subclient
IF @bExcludeVSAJobs = 0 OR @i_outputType = 4
BEGIN
IF object_id('tempdb.dbo.#VSAJobList') IS NOT null DROP TABLE #VSAJobList
IF object_id('tempdb.dbo.#VSAVMList')  IS NOT null DROP TABLE #VSAVMList
IF object_id('tempdb.dbo.#VSAJobVMs')  IS NOT null DROP TABLE #VSAJobVMs
CREATE TABLE #VSAJobList(t1_ccId INT, t1_appId INT, t1_bArchive INT, t1_bEnterprise INT, t1_jobId INT)
CREATE TABLE #VSAVMList (t2_ccId INT, t2_jobId INT, t2_bArchive INT, t2_VMId INT, t2_vmSize BIGINT, t2_vmUsedSpace BIGINT, t2_vmStatus INT)
CREATE TABLE #VSAJobVMs (t3_ccId INT, t3_appId INT, t3_bArchive INT, t3_jobId INT, t3_jobSize BIGINT, t3_VMList XML)
-- 1) Get VSA jobs
INSERT INTO #VSAJobList
SELECT	DISTINCT t_ccId, subClientId, isArchiver, t_isEnterprise, t_jobId
FROM	#tempAppSize
WHERE	t_appType = 106
UPDATE #VSAJobList
SET	t1_jobId = t_jobId
FROM	#lastFullTbl
WHERE	t1_bArchive > 0 AND t_appId = t1_appId
DROP TABLE #lastFullTbl
-- 2) Get VM with size
INSERT INTO #VSAVMList
SELECT	commCellId, jobId, ISNULL([vmStubStatus], 0), VMClientId, ISNULL([vmGuestSize], 0), ISNULL([vmUsedSpace], 0), CAST(ISNULL([vmStatus],-1) AS INT)
FROM	( SELECT  jobId, commcellId, VmClientId, attrName, attrVal
	  FROM    APP_VMProp WITH(NOLOCK)
	  WHERE   EXISTS (select * from #VSAJobList where t1_jobId = jobId AND t1_ccId = commCellId) ) AS VMs
PIVOT	( MAX(attrVal) FOR attrName IN (  [vmUsedSpace], [vmGuestSize], [vmStubStatus], [vmStatus]) ) AS P
-- Delete jobs which are failed
DELETE #VSAVMList WHERE t2_vmStatus NOT IN (0,3)
UPDATE #VSAVMList
SET	t2_bArchive	= (CASE WHEN t2_bArchive = 5 THEN 1 ELSE 0 END),
	t2_vmSize	= (CASE WHEN t2_vmSize = 0 THEN t2_vmUsedSpace ELSE t2_vmSize END)
-- If license 100021 is present don't count archived VM towards capacity
IF @bExcludeArchivedVMJobs > 0
	DELETE #VSAVMList WHERE t2_bArchive = 1
DELETE #VSAVMList WHERE t2_vmSize = 0
-- 3) Pick lastest jobs: DP > DA
DELETE #VSAVMList
FROM	(select ccID = T1.t2_ccId, VMId = T1.t2_VMId, bArchive = T1.t2_bArchive, jobID=MAX(T1.t2_jobId) from #VSAVMList T1
	 	 group by T1.t2_ccId, T1.t2_VMId, t2_bArchive ) TT
WHERE	ccID = t2_ccId AND VMId = t2_VMId AND bArchive = t2_bArchive AND jobID <> t2_jobId
DELETE #VSAVMList
FROM	(select ccID = T1.t2_ccId, VMId = T1.t2_VMId, jobID = T1.t2_jobId from #VSAVMList T1 where T1.t2_bArchive = 0) TT
WHERE	ccID = t2_ccId AND VMId = t2_VMId AND jobID <> t2_jobId
INSERT INTO #VSAJobVMs
SELECT	t2_ccId, (select TOP 1 t1_appId from #VSAJobList where t1_ccId = t2_ccId and t1_jobId = t2_jobId), t2_bArchive, t2_jobId, sum(t2_vmSize), ''
FROM	#VSAVMList
GROUP BY t2_ccId, t2_jobId, t2_bArchive
UPDATE #VSAJobVMs
SET	t3_VMList = (select vmId=t2_VMId, vmSize=t2_vmSize from #VSAVMList where t3_ccId = t2_ccId AND t3_jobId = t2_jobId AND t3_bArchive = t2_bArchive FOR XML RAW, ROOT('VMList'))
DELETE #tempAppSize
WHERE	t_appType = 106
INSERT INTO #tempAppSize
SELECT	t3_appId, t3_bArchive, clientId, apptypeId, backupset, instance, t3_jobSize, t3_jobId,
		ISNULL((select MAX(t1_bEnterprise) from #VSAJobList where t1_ccId = t3_ccId and t1_jobId = t3_jobId), 0), 0, t3_ccId, t3_VMList,'',
(CASE WHEN @bExcludeVSAJobs > 0 AND @i_outputType = 4 THEN 0x1
ELSE 0x0 END)
FROM	#VSAJobVMs JOIN APP_Application WITH(NOLOCK) ON id=t3_appId
DROP TABLE #VSAVMList
DROP TABLE #VSAJobVMs
DROP TABLE #VSAJobList
END
-- END: VSA jobs
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SNAP Counting Declaration - Start
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
    DECLARE @SnapSize bigint
    DECLARE @ReplicationSize bigint
    DECLARE     @tSnapFSAppTypes TABLE (AppTypeId   INTEGER)
    INSERT      INTO @tSnapFSAppTypes VALUES (13 /*CV_APPTYPE_NAS_FS*/)
    INSERT      INTO @tSnapFSAppTypes VALUES (17 /*CV_APPTYPE_HPUX32_FS*/)
    INSERT      INTO @tSnapFSAppTypes VALUES (19 /*CV_APPTYPE_SOLARIS32_FS*/)
    INSERT      INTO @tSnapFSAppTypes VALUES (21 /*CV_APPTYPE_AIX_FS */)
    INSERT      INTO @tSnapFSAppTypes VALUES (29 /*CV_APPTYPE_LINUX_FS*/)
    INSERT      INTO @tSnapFSAppTypes VALUES (33 /*CV_APPTYPE_WINDOWS_FILESYSTEM*/)
    IF object_id('tempdb.dbo.#jmbkpSnapJobs') IS NOT null DROP TABLE #jmbkpSnapJobs
    CREATE TABLE #jmbkpSnapJobs (
            AppId                   INTEGER,
            JobId                   INTEGER,
            CommcellId              INTEGER,
            CopyId                        INTEGER,
            AppType                       INTEGER,
            totalUnCompBytes  BIGINT,
            jobStartTime            INTEGER,
            isPrimary               INTEGER
    )
    INSERT  INTO #jmbkpSnapJobs
      SELECT  APP.id, JDS.jobId, jds.commCellId, JDS.archGrpCopyId, JBKP.appType, JBKP.totalUncompBytes, JBKP.servStartDate,
            CASE WHEN AGC.sourceCopyId > 0 THEN 0 ELSE 1 END
      FROM        #BKPJOBS JBKP
                  INNER JOIN APP_Application (NOLOCK) APP ON JBKP.appId = APP.id AND APP.subclientStatus & 2 = 0
            INNER JOIN JMJobDataStats (NOLOCK) JDS
                        ON JDS.jobId = JBKP.jobId AND JDS.commCellId = JBKP.commCellId
                AND JBKP.bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
            INNER JOIN archGroupCopy (NOLOCK) AGC ON JDS.archGrpCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.archGroupId = APP.dataArchGrpID
			WHERE JBKP.jobIdActedOn <> JBKP.jobId -- For blocklevel snap jobid is same as jobidactedon. Don't count this job in snap
    GROUP BY app.Id, jds.jobId, jds.commCellId, jds.archGrpCopyId, JBKP.appType, jbkp.servStartDate, jbkp.totalUncompBytes, AGC.sourceCopyId
    HAVING MAX(jds.status) = 100 AND MIN(jds.status) = 100 AND MAX(disabled & 256) = 0
	IF object_id('tempdb.dbo.#appJobSnapSize') IS NOT null DROP TABLE #appJobSnapSize
    CREATE TABLE #appJobSnapSize (
                CopyId            INTEGER,
                AppId             INTEGER,
				AppTypeId		  INTEGER,
                JobId             INTEGER,
                CommCellId        INTEGER,
                IsReplication     INTEGER,
                SnapSize          BIGINT
            )
    INSERT INTO #appJobSnapSize
    SELECT  CopyId, AppId, AppType, JobID, CommCellId, 0, totalUnCompBytes
    FROM
    (
        SELECT    CopyId, AppId, AppType, JobID, CommCellId, totalUnCompBytes, ROW_NUMBER() OVER(partition by AppId order by jobStartTime desc) as rn
        FROM      #jmbkpSnapJobs
        WHERE     isPrimary = 1
    ) T
    WHERE rn = 1
    INSERT INTO #appJobSnapSize
    SELECT  CopyId, AppId, AppType, JobID, CommCellId, 1, totalUnCompBytes
    FROM
    (
            SELECT      CopyId, AppId, AppType, JobID, CommCellId, totalUnCompBytes, ROW_NUMBER() OVER(partition by AppId order by jobStartTime desc) as rn
        FROM      #jmbkpSnapJobs
        WHERE     isPrimary = 0
    ) T
    WHERE rn = 1
    -- Snap Size for FS subclients
    UPDATE  #appJobSnapSize
    SET     SnapSize = T_SUM.size
    FROM    #appJobSnapSize AJS
    INNER JOIN
            (   SELECT  VOL.AppId, VOL.CopyId, VOL.JobId,
						SUM(CONVERT(BIGINT, SUBSTRING(dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), META.Metadata), 47 /*SM_MDT_VOLUME_SIZE*/),
						(CHARINDEX('|', dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), META.Metadata), 47 /*SM_MDT_VOLUME_SIZE*/))+1), 32))) AS size
				FROM    #appJobSnapSize AJS
						INNER JOIN SMVolume (NOLOCK) VOL
							ON VOL.JobId = AJS.JobId AND VOL.CommCellId = AJS.CommCellId AND VOL.CopyId = AJS.CopyId
							AND VOL.AppId = AJS.AppId
						INNER JOIN @tSnapFSAppTypes FSAT ON FSAT.AppTypeId = AJS.AppTypeId
						INNER JOIN archFileCopy (NOLOCK) AFC
							ON VOL.ArchFileId = AFC.ArchFileId AND AFC.archCopyId = AJS.CopyId AND AFC.isValid = 1
						INNER JOIN archFile (NOLOCK) AF
							ON AF.jobId = AJS.JobId AND AF.commCellId = AJS.CommCellId
							AND AF.id = VOL.ArchFileId
							AND AJS.AppId = AF.appId AND AF.isValid = 1
						INNER JOIN SMMetaData (NOLOCK) META
							ON META.RefType = 1 /*SM_MRT_VOLUME*/
							AND VOL.SMVolumeId = META.RefId
				GROUP BY VOL.AppId, VOL.CopyId, VOL.JobId ) T_SUM
				ON AJS.copyId = T_SUM.copyId AND AJS.AppId = T_SUM.appId AND AJS.JobId = T_SUM.JobId
	IF object_id('tempdb.dbo.#appVolumeSizeNAS') IS NOT null DROP TABLE #appVolumeSizeNAS
    CREATE TABLE #appVolumeSizeNAS (
				SMVolumeId		  INTEGER,
                CopyId            INTEGER,
                AppId             INTEGER,
                AppTypeId         INTEGER,
                JobId             INTEGER,
                CommCellId        INTEGER,
                GroupId			  INTEGER,
                SnapSize          BIGINT )
	INSERT INTO #appVolumeSizeNAS
	SELECT  VOL.SMVolumeId, VOL.CopyId, VOL.AppId, VOL.AppTypeId, VOL.JobId, VOL.CommCellId, SNAP.GroupId,
            CONVERT(BIGINT, SUBSTRING(dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), META.Metadata), 47 /*SM_MDT_VOLUME_SIZE*/),
			(CHARINDEX('|', dbo.MM_SMGetMetaData(CONVERT(NVARCHAR(MAX), META.Metadata), 47 /*SM_MDT_VOLUME_SIZE*/))+1), 32)) AS size
    FROM    #appJobSnapSize AJS
			INNER JOIN SMVolume (NOLOCK) VOL
				ON VOL.JobId = AJS.JobId AND VOL.CommCellId = AJS.CommCellId AND VOL.CopyId = AJS.CopyId
					AND VOL.AppId = AJS.AppId AND AJS.AppTypeId = (13 /*CV_APPTYPE_NAS_FS*/)
			INNER JOIN archFileCopy (NOLOCK) AFC
				ON VOL.ArchFileId = AFC.ArchFileId AND AFC.archCopyId = AJS.CopyId AND AFC.isValid = 1
			INNER JOIN archFile (NOLOCK) AF
				ON AF.jobId = AJS.JobId AND AF.commCellId = AJS.CommCellId
					AND AF.id = VOL.ArchFileId
					AND AJS.AppId = AF.appId AND AF.isValid = 1
			INNER JOIN SMMetaData (NOLOCK) META
				ON META.RefType = 1 /*SM_MRT_VOLUME*/
					AND VOL.SMVolumeId = META.RefId
			INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap (NOLOCK) SNAP ON MAP.SMSnapId = SNAP.SMSnapId
	DELETE	#appVolumeSizeNAS
	WHERE	SMVolumeId NOT IN (SELECT MAX(SMVolumeId) FROM #appVolumeSizeNAS GROUP BY JobId, CopyId, CommCellId, GroupId)
			AND	GroupId > 0
    UPDATE  #appJobSnapSize
    SET     SnapSize = T_SUM.size
    FROM    #appJobSnapSize AJS
    INNER JOIN
            (   SELECT  NAS.AppId, NAS.CopyId, NAS.JobId, NAS.CommCellId, SUM(SnapSize) as size
	            FROM    #appVolumeSizeNAS NAS
                GROUP BY NAS.AppId, NAS.CopyId, NAS.JobId, NAS.CommCellId ) T_SUM
    ON AJS.copyId = T_SUM.copyId AND AJS.AppId = T_SUM.appId AND AJS.JobId = T_SUM.JobId AND AJS.CommCellId = T_SUM.CommCellId
	UPDATE	AJS
	SET		SnapSize = BKP.totalUncompBytes
	FROM	#appJobSnapSize AJS
			INNER JOIN SMvolume VOL (NOLOCK) ON AJS.JobId = VOL.JobId AND AJS.CopyId = VOL.CopyId AND AJS.CommCellId = VOL.CommCellId
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId AND SNAP.SnapShotEngineId = 27 /*SM_SNAPSHOT_ENGINE_ISILON_SNAP*/
			INNER JOIN JMBkpStats BKP ON BKP.jobId = AJS.JobId AND BKP.commCellId = AJS.CommCellId
    SELECT @snapsize = SUM(SnapSize) FROM #appJobSnapSize WHERE isReplication = 0
    SELECT @replicationsize = SUM(SnapSize) FROM #appJobSnapSize WHERE isReplication = 1
    DROP TABLE #jmbkpSnapJobs
	DROP TABLE #appVolumeSizeNAS
--Insert into #tempAppSize table.
insert into #tempAppSize
SELECT b.id,  case when isReplication = 0 then 2 else 3 end, b.clientId, b.appTypeId,b.backupSet, b.instance, a.SnapSize, a.JobId,0,0,2, '',b.subclientStatus, 0x0
FROM #appJobSnapSize A , APP_Application b
where a.AppId =b.id
DROP TABLE #appJobSnapSize
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SNAP Counting Declaration - END
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
--If output is 4 update the flag so that caller will know the capacity which are only for display and should not be counted towards billing
IF @i_outputType = 4
BEGIN
	--End Point Users
UPDATE #tempAppSize SET t_flag = (CASE WHEN @bExcludeEdgeDrive > 0 AND (C.status & 0x10000000) > 0 THEN 0x8
WHEN @bExcludeDLPJobs > 0 AND (C.status & 0x1000) > 0 THEN 0x10
ELSE 0x0 END)
	FROM	APP_CLient C WITH(NOLOCK)
	WHERE	 t_client = C.id AND
(@bExcludeEdgeDrive > 0 AND (C.status & 0x10000000) > 0 OR @bExcludeDLPJobs > 0 AND (C.status & 0x1000) > 0)
	--ACV
	IF @bExcludeVMAppClass1 > 0
	BEGIN
		TRUNCATE TABLE #tempVMsWithIdAppType
		EXEC LicGetVMAppcalss1 '#tempVMsWithIdAppType'
UPDATE #tempAppSize SET t_flag = 0x4
		FROM #tempVMsWithIdAppType WHERE t_client = t_Id AND t_appType = t_appTypeId
	END
	--Msim
	IF @bExcludeMSimJobs > 0
	BEGIN
		SET @o_appTypeList = ''
		EXEC LicGetMSimAppType -1,0,@o_isValidApptype OUTPUT, @o_appTypeList OUTPUT
		IF @o_appTypeList <> ''
UPDATE T SET t_flag = 0x2
			FROM #tempAppSize T WHERE t_appType in (select _ID from dbo.SplitIDs(@o_appTypeList))
	END
END
--for each appid get information for secondary encryption and dedeuplication
INSERT INTO #tempAppInfo (appId, jobId, AppTypeId, archiverApp, UncompBytes, flag)
SELECT	subClientId, t_jobID, t_appType, isArchiver, size, t_flag
FROM	#tempAppSize
GROUP BY subClientId, t_jobID, t_appType, isArchiver, size, t_flag
DECLARE @totalTbl TABLE	(	EnterrpiseBackupSize Float, CoreBackupSize Float, EnterpriseArchiveSize Float, CoreArchiveSize Float, SnapshotSize Float, ReplicationSize Float)
INSERT INTO @totalTbl VALUES(	ISNULL((SELECT SUM(UncompBytes) from #tempAppInfo WHERE archiverApp = 0 AND flag = 0), 0), 0,
				ISNULL((SELECT SUM(UncompBytes) from #tempAppInfo WHERE archiverApp = 1 AND flag = 0), 0), 0,
				@SnapSize, @ReplicationSize
				)
IF @i_outputType = 2
	SELECT * FROM @totalTbl
ELSE
BEGIN
	--update client id, name, sublcClientName, storage policy id, name
	Update #tempAppInfo
	SET	Clientid	= App_Client.id,
		ClientName	= App_Client.name,
		subClientName	= APP_Application.subclientName,
		SPId		= dataArchGrpID,
		SPName		= archGroup.name,
		bkupSetName	= APP_BackupSetName.name,
		instanceName= APP_InstanceName.name,
		AppTypeName	= (select name from APP_iDAType WITH(NOLOCK) where type = APP_Application.AppTypeId)
	FROM	APP_Application	WITH(NOLOCK) INNER JOIN APP_Client WITH(NOLOCK) ON APP_Application.clientId = APP_Client.id
					INNER JOIN archGroup WITH(NOLOCK) ON APP_Application.dataArchGrpID = archGroup.id
					INNER JOIN APP_BackupSetName WITH(NOLOCK) ON APP_Application.backupSet = APP_BackupSetName.id
					INNER JOIN APP_InstanceName WITH(NOLOCK) ON APP_Application.instance = APP_InstanceName.id
	WHERE	appId = APP_Application.id
	--if hide client name option is given, supress the client name
	IF (@i_Param = @HIDDEN_CLIENT_NAME)
		UPDATE #tempAppInfo SET ClientName = @HIDDEN
	-- build table with return data
	IF object_id('tempdb.dbo.#RESULT_TBL') IS NOT null DROP TABLE #RESULT_TBL
	SELECT	nJobType=archiverApp, appId, jobID=(CASE WHEN archiverApp = 1 and AppTypeId <> 106 THEN 0 ELSE jobId END), ClientName, Clientid, AppTypeId, AppTypeName, bkupSetName, instanceName, subClientName, SPId, SPName, UncompBytes,
		DedupEabled, SecondaryEncryption, flag
	INTO	#RESULT_TBL
	FROM	#tempAppInfo
	WHERE	UncompBytes > 0
	IF @i_outputType = 0
	BEGIN
		SELECT	JobType = (CASE nJobType WHEN 0 THEN 'Backup Job' WHEN 1 THEN 'Archive Job' WHEN 2 THEN 'Snap Job' when 3 THEN 'Replication Job' END),
				*, sizeInTB=Cast(UncompBytes/@bytesInTB As decimal(18,3))
		FROM	#RESULT_TBL
		ORDER BY nJobType, ClientName, AppTypeName, subClientName
		SELECT	name = 'Totals',
			EnterrpiseBackupSizeInTB	= Cast(EnterrpiseBackupSize/@bytesInTB As decimal(18,3)),
			CoreBackupSizeInTB		= 0,
			EnterpriseArchiveSizeInTB	= Cast(EnterpriseArchiveSize/@bytesInTB As decimal(18,3)),
			CoreArchiveSizeInTB			= 0,
			SnapshotSizeInTB			= Cast(snapshotsize/@bytesInTB As decimal(18,3)),
			ReplicationSizeInTB			= Cast(ReplicationSize/@bytesInTB As decimal(18,3))
		FROM	@totalTbl
	END
	ELSE IF @i_outputType = 3
	BEGIN
		SELECT	*, VMList=(select t_VMList from #tempAppSize where appId = subClientId and jobId = t_jobID and nJobType = isArchiver)
		FROM	#RESULT_TBL
		WHERE	appTypeId = 106 AND nJobType < 2
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#tmpCommcellUsageReport') IS NOT NULL
		BEGIN
			INSERT INTO #tmpCommcellUsageReport (
			EnterpriseBackupSize , CoreBackupSize , EnterpriseArchiveSize , CoreArchiveSize ,
			SnapshotSize , ReplicationSize , nJobType ,
			appId , jobID , ClientName , ClientId , AppTypeId , AppTypeName ,
			BackupSetName , InstanceName , SubclientName ,
			SPId , SPName , UncompBytes , DedupEnabled , SecondaryEncryption , flag
			)
			SELECT	*
			FROM	@totalTbl, #RESULT_TBL
			ORDER BY nJobType, ClientName, AppTypeName, subClientName
		END
		ELSE
			SELECT	*
			FROM	@totalTbl, #RESULT_TBL
			ORDER BY nJobType, ClientName, AppTypeName, subClientName
	END
	DROP TABLE #RESULT_TBL
END
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
DROP TABLE #tempAppSize
DROP TABLE #tempAppInfo
DROP TABLE #tempJobInfo
DROP TABLE #BKPJOBS
DROP TABLE #tempVMsWithIdAppType
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CommCellUsageReport')
	delete from GxQscripts where name = 'QS_CommCellUsageReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommCellUsageReport')
	delete from GXDBVersions where aliasname = 'QS_CommCellUsageReport'
GO

insert into GXDBVersions values(2, 'QS_CommCellUsageReport',  '00010078000200250000', 'QS_CommCellUsageReport', '00010078000200250000')
GO

insert into GxQscripts values(2,'QS_CommCellUsageReport',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CommCellUsageReport [-si HideClientName] [-si IncludeForeignJob]
'
 + CHAR(10) + '-- 	script_name: CommCellUsageReport'
 + CHAR(10) + '-- 	List the detail usage of backup/archiver jobs used for computing totals towards capacity usage'
)
GO

