

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBillingTagToAgent.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBillingTagToAgent.sp,v $ $Id: RptBillingTagToAgent.sp,v 1.1.2.2 2016/04/16 22:38:16 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBillingTagToAgent <<<'

IF EXISTS (select * from sysobjects where name='RptBillingTagToAgent')
	drop procedure RptBillingTagToAgent
IF EXISTS (select * from GxQscripts where name='RptBillingTagToAgent')
	delete from GxQscripts where name = 'RptBillingTagToAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTagToAgent')
	delete from GXDBVersions where aliasname = 'RptBillingTagToAgent'
GO
print '... Creating Procedure: RptBillingTagToAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBillingTagToAgent
  @i_UserId INT = -1,
  @i_EntityId INT,
  @i_AllAssociated INT = 1,
  @i_AppTypeId INT = 0,
  @i_CellUniqueId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @i_AllAssociated = 1
BEGIN
	CREATE TABLE #CommCell (CommServUniqueId INT, CommServName NVARCHAR(256))
	CREATE TABLE #Agent (AppTypeId INT, AgentName NVARCHAR(256))
	INSERT	INTO  #CommCell
	SELECT	CommServUniqueId, CommServName
	FROM	dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, -1)
	INSERT	INTO #Agent
	SELECT	U.AppTypeId, U.AgentName
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN (SELECT DISTINCT AppTypeId, AgentName FROM cf_SurveySubclientAssociation) U
				ON U.AppTypeId = M.AppTypeId AND M.AppTypeId > 0 AND M.ClientId = 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.AppTypeId, U.AgentName
	IF @i_EntityId > 0
		SELECT	M.AppTypeId AS 'Agent Type ID<DONOTSHOW>',
				U.AgentName AS 'Agent',
				M.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				ISNULL(C.CommServName, '') AS 'CommCell Name'
		FROM	cf_SurveyBillingEntityMember M
				INNER JOIN (SELECT DISTINCT AppTypeId, AgentName FROM cf_SurveySubclientAssociation) U
					ON U.AppTypeId = M.AppTypeId AND M.AppTypeId > 0 AND M.ClientId = 0 AND @i_EntityId IN (0, M.EntityID)
				LEFT OUTER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
		ORDER BY 'Agent', 'CommCell Name'
	ELSE
		SELECT	E.ID AS 'Tag ID<DONOTSHOW>',
				E.Name AS 'Tag Name',
				M.AppTypeId AS 'Agent Type ID<DONOTSHOW>',
				U.AgentName AS 'Agent',
				M.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				ISNULL(C.CommServName, '') AS 'CommCell Name'
		FROM	cf_SurveyBillingEntityMember M
				INNER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
				INNER JOIN (SELECT DISTINCT AppTypeId, AgentName FROM cf_SurveySubclientAssociation) U
					ON U.AppTypeId = M.AppTypeId AND M.AppTypeId > 0 AND M.ClientId = 0 AND @i_EntityId IN (0, M.EntityID)
				LEFT OUTER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
		ORDER BY E.Name, 'Agent', 'CommCell Name'
	DROP TABLE #CommCell
	DROP TABLE #Agent
END
ELSE
IF @i_AppTypeId = 0
	SELECT	U.AppTypeId AS 'AppType ID',
			U.AgentName AS 'Agent Name',
			CASE WHEN M.AppTypeId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT DISTINCT AppTypeId, AgentName FROM cf_SurveySubclientAssociation) U
			LEFT OUTER JOIN
			(SELECT EntityID, AppTypeId, CommServUniqueId FROM cf_SurveyBillingEntityMember
			WHERE ClientId = 0 AND AppTypeId > 0 AND InstanceId = 0
			) M ON M.AppTypeId = U.AppTypeId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.AgentName
ELSE
IF @i_CellUniqueId = 0
	SELECT	C.ID AS 'CommServ UniqueId',
			C.CommServName AS 'CommCell Name',
			CASE WHEN M.CommServUniqueId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_CommcellIdNameMap C
			INNER JOIN dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, -1) R ON R.CommServUniqueId = C.ID
			LEFT OUTER JOIN
			(SELECT EntityID, AppTypeId, CommServUniqueId FROM cf_SurveyBillingEntityMember
			WHERE ClientId = 0 AND AppTypeId = @i_AppTypeId AND InstanceId = 0
			) M  ON M.CommServUniqueId = R.CommServUniqueId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	(C.CommCellSurveyServices&32) = 32
	ORDER BY C.CommServName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBillingTagToAgent')
	delete from GxQscripts where name = 'RptBillingTagToAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTagToAgent')
	delete from GXDBVersions where aliasname = 'RptBillingTagToAgent'
GO

insert into GXDBVersions values(2, 'RptBillingTagToAgent',  '00010001000200020000', 'RptBillingTagToAgent', '00010001000200020000')
GO

